/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.MarkupParser;
import net.java.textilej.parser.markup.Block;
import net.java.textilej.parser.markup.ContentState;
import net.java.textilej.parser.markup.PatternBasedElement;
import net.java.textilej.parser.markup.PatternBasedElementProcessor;
import net.java.textilej.util.LocationTrackingReader;

public abstract class Dialect {
    private String name;
    private boolean filterGenerativeBlocks;
    private boolean blocksOnly;

    protected ContentState createState() {
        return new ContentState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processContent(MarkupParser parser, String markupContent, boolean asDocument) {
        ContentState state = this.createState();
        state.setMarkupContent(markupContent);
        LocationTrackingReader reader = new LocationTrackingReader(new StringReader(markupContent));
        Block currentBlock = null;
        DocumentBuilder builder = parser.getBuilder();
        builder.setLocator(state);
        try {
            if (asDocument) {
                builder.beginDocument();
            }
            try {
                String line;
                block5: while ((line = reader.readLine()) != null) {
                    state.setLineNumber(reader.getLineNumber() + 1);
                    state.setLineOffset(reader.getLineOffset());
                    state.setLineCharacterOffset(0);
                    state.setLineSegmentEndOffset(0);
                    state.setLineLength(line.length());
                    int lineOffset = 0;
                    do {
                        if (currentBlock == null) {
                            currentBlock = this.startBlock(line, lineOffset);
                            if (currentBlock == null) continue block5;
                            currentBlock.setState(state);
                            currentBlock.setParser(parser);
                        }
                        lineOffset = currentBlock.processLineContent(line, lineOffset);
                        if (currentBlock.isClosed()) {
                            currentBlock = null;
                        }
                        if (lineOffset >= line.length() || lineOffset < 0) continue block5;
                    } while (currentBlock == null);
                    throw new IllegalStateException("if a block does not fully process a line then it must be closed");
                }
                state.setLineNumber(reader.getLineNumber() + 1);
                state.setLineOffset(reader.getLineOffset());
                state.setLineCharacterOffset(0);
                state.setLineLength(0);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            if (currentBlock != null && !currentBlock.isClosed()) {
                currentBlock.setClosed(true);
            }
            if (asDocument) {
                builder.endDocument();
            }
        }
        finally {
            builder.setLocator(null);
        }
    }

    public Block startBlock(String line, int lineOffset) {
        if (this.isEmptyLine(line)) {
            return null;
        }
        for (Block block : this.getBlocks()) {
            if (!block.canStart(line, lineOffset)) continue;
            return block.clone();
        }
        return null;
    }

    public abstract List<Block> getBlocks();

    public void emitMarkupLine(MarkupParser parser, ContentState state, int textLineOffset, String line, int offset) {
        block3: {
            PatternBasedElementProcessor phraseModifier;
            if (this.blocksOnly) {
                this.emitMarkupText(parser, state, line.substring(offset));
                return;
            }
            while ((phraseModifier = this.getPhraseModifierSyntax().findPatternBasedElement(line, offset)) != null) {
                int newOffset = phraseModifier.getLineStartOffset();
                if (offset < newOffset) {
                    state.setLineCharacterOffset(textLineOffset + offset);
                    state.setLineSegmentEndOffset(textLineOffset + newOffset);
                    String text = line.substring(offset, newOffset);
                    this.emitMarkupText(parser, state, text);
                }
                phraseModifier.setParser(parser);
                phraseModifier.setState(state);
                state.setLineCharacterOffset(textLineOffset + phraseModifier.getLineStartOffset());
                state.setLineSegmentEndOffset(textLineOffset + phraseModifier.getLineEndOffset());
                phraseModifier.emit();
                offset = phraseModifier.getLineEndOffset();
                if (offset < line.length()) continue;
                break block3;
            }
            state.setLineCharacterOffset(textLineOffset + offset);
            state.setLineSegmentEndOffset(textLineOffset + line.length());
            this.emitMarkupText(parser, state, line.substring(offset));
        }
    }

    public void emitMarkupLine(MarkupParser parser, ContentState state, String line, int offset) {
        this.emitMarkupLine(parser, state, 0, line, offset);
    }

    public void emitMarkupText(MarkupParser parser, ContentState state, String text) {
        block3: {
            PatternBasedElementProcessor patternBasedElement;
            if (this.blocksOnly) {
                parser.getBuilder().characters(text);
                return;
            }
            int offset = 0;
            while ((patternBasedElement = this.getReplacementTokenSyntax().findPatternBasedElement(text, offset)) != null) {
                int newOffset = patternBasedElement.getLineStartOffset();
                if (offset < newOffset) {
                    String text2 = text.substring(offset, newOffset);
                    this.emitMarkupText(parser, state, text2);
                }
                patternBasedElement.setParser(parser);
                patternBasedElement.setState(state);
                patternBasedElement.emit();
                offset = patternBasedElement.getLineEndOffset();
                if (offset < text.length()) continue;
                break block3;
            }
            parser.getBuilder().characters(offset > 0 ? text.substring(offset) : text);
        }
    }

    protected abstract PatternBasedSyntax getPhraseModifierSyntax();

    protected abstract PatternBasedSyntax getReplacementTokenSyntax();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Dialect clone() {
        Dialect dialect;
        try {
            dialect = (Dialect)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        dialect.setName(this.name);
        return dialect;
    }

    public boolean isFilterGenerativeContents() {
        return this.filterGenerativeBlocks;
    }

    public void setFilterGenerativeContents(boolean filterGenerativeBlocks) {
        this.filterGenerativeBlocks = filterGenerativeBlocks;
    }

    public boolean isBlocksOnly() {
        return this.blocksOnly;
    }

    public void setBlocksOnly(boolean blocksOnly) {
        this.blocksOnly = blocksOnly;
    }

    public boolean isEmptyLine(String line) {
        if (line.length() == 0) {
            return true;
        }
        for (int x = 0; x < line.length(); ++x) {
            if (Character.isWhitespace(line.charAt(x))) continue;
            return false;
        }
        return true;
    }

    public static class PatternBasedSyntax {
        protected List<PatternBasedElement> elements = new ArrayList<PatternBasedElement>();
        protected Pattern elementPattern;
        protected List<Integer> elementGroup = new ArrayList<Integer>();
        private StringBuilder patternBuffer = new StringBuilder();
        private int patternGroup = 0;
        private Stack<Group> groups = new Stack();

        public PatternBasedSyntax() {
            this.groups.push(new Group());
        }

        public void add(PatternBasedElement element) {
            this.elementPattern = null;
            this.elements.add(element);
            if (this.groups.peek().count++ > 0) {
                this.patternBuffer.append('|');
            }
            ++this.patternGroup;
            this.patternBuffer.append('(');
            this.patternBuffer.append(element.getPattern(this.patternGroup));
            this.patternBuffer.append(')');
            this.elementGroup.add(this.patternGroup);
            this.patternGroup += element.getPatternGroupCount();
        }

        public void beginGroup(String regexFragment, int size) {
            this.add(regexFragment, size, true);
        }

        public void endGroup(String regexFragment, int size) {
            this.add(regexFragment, size, false);
        }

        private void add(String regexFragment, int size, boolean beginGroup) {
            this.elementPattern = null;
            if (beginGroup) {
                if (this.groups.peek().count++ > 0) {
                    this.patternBuffer.append('|');
                }
                this.groups.push(new Group());
                this.patternBuffer.append("(?:");
            } else {
                this.groups.pop();
            }
            this.patternBuffer.append(regexFragment);
            if (!beginGroup) {
                this.patternBuffer.append(")");
            }
            this.patternGroup += size;
        }

        public PatternBasedElementProcessor findPatternBasedElement(String lineText, int offset) {
            Matcher matcher = this.getPattern().matcher(lineText);
            if (offset > 0) {
                matcher.region(offset, lineText.length());
            }
            if (matcher.find()) {
                int size = this.elementGroup.size();
                for (int x = 0; x < size; ++x) {
                    int group = this.elementGroup.get(x);
                    String value = matcher.group(group);
                    if (value == null) continue;
                    PatternBasedElement element = this.elements.get(x);
                    PatternBasedElementProcessor processor = element.newProcessor();
                    processor.setLineStartOffset(matcher.start());
                    processor.setLineEndOffset(matcher.end());
                    for (int y = 0; y < element.getPatternGroupCount(); ++y) {
                        int groupIndex = group + y + 1;
                        processor.setGroup(y + 1, matcher.group(groupIndex), matcher.start(groupIndex), matcher.end(groupIndex));
                    }
                    return processor;
                }
                throw new IllegalStateException();
            }
            return null;
        }

        public Pattern getPattern() {
            if (this.elementPattern == null) {
                if (this.patternBuffer.length() > 0) {
                    this.elementPattern = Pattern.compile(this.patternBuffer.toString());
                } else {
                    return null;
                }
            }
            return this.elementPattern;
        }
    }

    private static class Group {
        int count;

        private Group() {
        }
    }
}

