/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.confluence.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.markup.Block;

public class HeadingBlock
extends Block {
    static final Pattern startPattern = Pattern.compile("\\s*h([1-6])\\.\\s+(.*)");
    private int blockLineCount = 0;
    private int level = -1;
    private Matcher matcher;

    @Override
    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            this.level = Integer.parseInt(this.matcher.group(1));
            offset = this.matcher.start(2);
            if (attributes.getId() == null) {
                attributes.setId(this.state.getIdGenerator().newId("h" + this.level, line.substring(offset)));
            }
            this.builder.beginHeading(this.level, attributes);
        }
        if (this.blockLineCount != 0 || this.dialect.isEmptyLine(line)) {
            this.setClosed(true);
            return 0;
        }
        ++this.blockLineCount;
        this.getDialect().emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    @Override
    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    @Override
    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endHeading();
        }
        super.setClosed(closed);
    }
}

