/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.confluence.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.markup.confluence.block.ParameterizedBlock;

public class TextBoxBlock
extends ParameterizedBlock {
    private final Pattern startPattern;
    private final Pattern endPattern;
    private final DocumentBuilder.BlockType blockType;
    private int blockLineCount = 0;
    private Matcher matcher;
    private String title;
    private StringBuilder markupContent;

    public TextBoxBlock(DocumentBuilder.BlockType blockType, String name) {
        this.blockType = blockType;
        this.startPattern = Pattern.compile("\\{" + name + "(?::([^\\}]*))?\\}(.*)");
        this.endPattern = Pattern.compile("(\\{" + name + "\\})(.*)");
    }

    @Override
    public int processLineContent(String line, int offset) {
        int end;
        if (this.blockLineCount == 0) {
            this.setOptions(this.matcher.group(1));
            Attributes attributes = new Attributes();
            attributes.setTitle(this.title);
            offset = this.matcher.start(2);
            this.builder.beginBlock(this.blockType, attributes);
            this.markupContent = new StringBuilder();
        }
        int segmentEnd = end = line.length();
        boolean terminating = false;
        Matcher endMatcher = this.endPattern.matcher(line);
        if (offset < end) {
            if (this.blockLineCount == 0) {
                endMatcher.region(offset, end);
            }
            if (endMatcher.find()) {
                terminating = true;
                end = endMatcher.start(2);
                segmentEnd = endMatcher.start(1);
            }
        }
        ++this.blockLineCount;
        if (end < line.length()) {
            this.state.setLineSegmentEndOffset(end);
        }
        this.markupContent.append(line.substring(offset, segmentEnd));
        this.markupContent.append("\n");
        if (terminating) {
            this.setClosed(true);
        }
        return end == line.length() ? -1 : end;
    }

    @Override
    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        this.title = null;
        this.markupContent = null;
        this.matcher = this.startPattern.matcher(line);
        if (lineOffset > 0) {
            this.matcher.region(lineOffset, line.length());
        }
        return this.matcher.matches();
    }

    @Override
    public void setClosed(boolean closed) {
        if (closed && !this.isClosed() && this.markupContent != null) {
            this.getParser().parse(this.markupContent.toString(), false);
            this.markupContent = null;
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }

    @Override
    protected void setOption(String key, String value) {
        if (key.equals("title")) {
            this.title = value;
        }
    }
}

