/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.confluence.phrase;

import java.util.regex.Pattern;
import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.markup.PatternBasedElement;
import net.java.textilej.parser.markup.PatternBasedElementProcessor;

public class SimpleWrappedPhraseModifier
extends PatternBasedElement {
    protected static final int CONTENT_GROUP = 1;
    private String startDelimiter;
    private String endDelimiter;
    private DocumentBuilder.SpanType spanType;
    private final boolean nesting;

    public SimpleWrappedPhraseModifier(String startDelimiter, String endDelimiter, DocumentBuilder.SpanType spanType, boolean nesting) {
        this.startDelimiter = startDelimiter;
        this.endDelimiter = endDelimiter;
        this.spanType = spanType;
        this.nesting = nesting;
    }

    @Override
    protected String getPattern(int groupOffset) {
        return Pattern.quote(this.startDelimiter) + "([^\\s-](?:.*?[^\\s-])?)" + Pattern.quote(this.endDelimiter);
    }

    @Override
    protected int getPatternGroupCount() {
        return 1;
    }

    protected static String getContent(PatternBasedElementProcessor processor) {
        return processor.group(1);
    }

    protected static int getStart(PatternBasedElementProcessor processor) {
        return processor.start(1);
    }

    @Override
    protected PatternBasedElementProcessor newProcessor() {
        return new SimplePhraseModifierProcessor(this.spanType, this.nesting);
    }

    private static class SimplePhraseModifierProcessor
    extends PatternBasedElementProcessor {
        private final DocumentBuilder.SpanType spanType;
        private final boolean nesting;

        public SimplePhraseModifierProcessor(DocumentBuilder.SpanType spanType, boolean nesting) {
            this.spanType = spanType;
            this.nesting = nesting;
        }

        @Override
        public void emit() {
            Attributes attributes = new Attributes();
            this.getBuilder().beginSpan(this.spanType, attributes);
            if (this.nesting) {
                this.getDialect().emitMarkupLine(this.parser, this.state, this.state.getLineCharacterOffset() + SimpleWrappedPhraseModifier.getStart(this), SimpleWrappedPhraseModifier.getContent(this), 0);
            } else {
                this.getDialect().emitMarkupText(this.parser, this.state, SimpleWrappedPhraseModifier.getContent(this));
            }
            this.getBuilder().endSpan();
        }
    }
}

