/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.mediawiki.token;

import net.java.textilej.parser.LinkAttributes;
import net.java.textilej.parser.markup.PatternBasedElement;
import net.java.textilej.parser.markup.PatternBasedElementProcessor;
import net.java.textilej.parser.markup.mediawiki.MediaWikiDialect;

public class HyperlinkInternalReplacementToken
extends PatternBasedElement {
    @Override
    protected String getPattern(int groupOffset) {
        return "(?:\\[\\[([^\\]\\|]+?)\\s*(?:\\|\\s*([^\\]]*))?\\]\\])";
    }

    @Override
    protected int getPatternGroupCount() {
        return 2;
    }

    @Override
    protected PatternBasedElementProcessor newProcessor() {
        return new HyperlinkReplacementTokenProcessor();
    }

    private static class HyperlinkReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private HyperlinkReplacementTokenProcessor() {
        }

        @Override
        public void emit() {
            String pageName = this.group(1);
            String altText = this.group(2);
            String href = ((MediaWikiDialect)this.getDialect()).toInternalHref(pageName);
            if (pageName.startsWith(":")) {
                pageName = pageName.substring(1);
            }
            if ((altText == null || altText.trim().length() == 0) && (altText = pageName).startsWith("#")) {
                altText = altText.substring(1);
            }
            if (pageName.startsWith("#")) {
                this.builder.link(href, altText);
            } else {
                LinkAttributes attributes = new LinkAttributes();
                attributes.setTitle(pageName);
                this.builder.link(attributes, href, altText);
            }
        }
    }
}

