/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.mediawiki.token;

import net.java.textilej.parser.ImageAttributes;
import net.java.textilej.parser.markup.PatternBasedElement;
import net.java.textilej.parser.markup.PatternBasedElementProcessor;

public class ImageReplacementToken
extends PatternBasedElement {
    @Override
    protected String getPattern(int groupOffset) {
        return "(?:\\[\\[Image:([^\\]\\|]+)(?:\\|([^\\]]*))?\\]\\])";
    }

    @Override
    protected int getPatternGroupCount() {
        return 2;
    }

    @Override
    protected PatternBasedElementProcessor newProcessor() {
        return new ImageReplacementTokenProcessor();
    }

    private static class ImageReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private ImageReplacementTokenProcessor() {
        }

        @Override
        public void emit() {
            String imageUrl = this.group(1);
            String optionsString = this.group(2);
            ImageAttributes attributes = new ImageAttributes();
            if (optionsString != null) {
                String[] options;
                for (String option : options = optionsString.split("\\s*\\|\\s*")) {
                    if ("center".equals(option)) {
                        attributes.setAlign(ImageAttributes.Align.Middle);
                        continue;
                    }
                    if ("left".equals(option)) {
                        attributes.setAlign(ImageAttributes.Align.Left);
                        continue;
                    }
                    if ("right".equals(option)) {
                        attributes.setAlign(ImageAttributes.Align.Right);
                        continue;
                    }
                    if ("none".equals(option)) {
                        attributes.setAlign(null);
                        continue;
                    }
                    if ("thumb".equals(option) || "thumbnail".equals(option)) continue;
                    if (option.matches("\\d+px")) {
                        try {
                            int size = Integer.parseInt(option.substring(0, option.length() - 2));
                            attributes.setWidth(size);
                            attributes.setHeight(size);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if ("frameless".equals(option)) {
                        attributes.setBorder(0);
                        continue;
                    }
                    if ("frame".equals(option)) {
                        attributes.setBorder(1);
                        continue;
                    }
                    attributes.setTitle(option);
                }
            }
            this.builder.image(attributes, imageUrl);
        }
    }
}

