/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.textile;

import java.util.ArrayList;
import java.util.List;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.markup.Block;
import net.java.textilej.parser.markup.ContentState;
import net.java.textilej.parser.markup.Dialect;
import net.java.textilej.parser.markup.phrase.HtmlEndTagPhraseModifier;
import net.java.textilej.parser.markup.phrase.HtmlStartTagPhraseModifier;
import net.java.textilej.parser.markup.textile.TextileContentState;
import net.java.textilej.parser.markup.textile.block.CodeBlock;
import net.java.textilej.parser.markup.textile.block.FootnoteBlock;
import net.java.textilej.parser.markup.textile.block.HeadingBlock;
import net.java.textilej.parser.markup.textile.block.ListBlock;
import net.java.textilej.parser.markup.textile.block.ParagraphBlock;
import net.java.textilej.parser.markup.textile.block.PreformattedBlock;
import net.java.textilej.parser.markup.textile.block.QuoteBlock;
import net.java.textilej.parser.markup.textile.block.TableBlock;
import net.java.textilej.parser.markup.textile.block.TableOfContentsBlock;
import net.java.textilej.parser.markup.textile.block.TextileGlossaryBlock;
import net.java.textilej.parser.markup.textile.phrase.EscapeTextilePhraseModifier;
import net.java.textilej.parser.markup.textile.phrase.ImageTextilePhraseModifier;
import net.java.textilej.parser.markup.textile.phrase.SimpleTextilePhraseModifier;
import net.java.textilej.parser.markup.textile.token.FootnoteReferenceReplacementToken;
import net.java.textilej.parser.markup.textile.token.HyperlinkReplacementToken;
import net.java.textilej.parser.markup.token.AcronymReplacementToken;
import net.java.textilej.parser.markup.token.EntityReferenceReplacementToken;
import net.java.textilej.parser.markup.token.EntityWrappingReplacementToken;
import net.java.textilej.parser.markup.token.PatternEntityReferenceReplacementToken;

public class TextileDialect
extends Dialect {
    private List<Block> blocks = new ArrayList<Block>();
    private List<Block> paragraphBreakingBlocks = new ArrayList<Block>();
    private static Dialect.PatternBasedSyntax tokenSyntax = new Dialect.PatternBasedSyntax();
    private static Dialect.PatternBasedSyntax phraseModifierSyntax = new Dialect.PatternBasedSyntax();

    public TextileDialect() {
        this.blocks.add(new HeadingBlock());
        ListBlock listBlock = new ListBlock();
        this.blocks.add(listBlock);
        this.paragraphBreakingBlocks.add(listBlock);
        this.blocks.add(new PreformattedBlock());
        this.blocks.add(new QuoteBlock());
        this.blocks.add(new CodeBlock());
        this.blocks.add(new FootnoteBlock());
        TableBlock tableBlock = new TableBlock();
        this.blocks.add(tableBlock);
        this.paragraphBreakingBlocks.add(tableBlock);
        this.blocks.add(new TextileGlossaryBlock());
        this.blocks.add(new TableOfContentsBlock());
        this.blocks.add(new ParagraphBlock());
    }

    @Override
    protected Dialect.PatternBasedSyntax getPhraseModifierSyntax() {
        return phraseModifierSyntax;
    }

    @Override
    protected Dialect.PatternBasedSyntax getReplacementTokenSyntax() {
        return tokenSyntax;
    }

    public List<Block> getParagraphBreakingBlocks() {
        return this.paragraphBreakingBlocks;
    }

    @Override
    public List<Block> getBlocks() {
        return this.blocks;
    }

    @Override
    protected ContentState createState() {
        return new TextileContentState();
    }

    static {
        phraseModifierSyntax.add(new HtmlEndTagPhraseModifier());
        phraseModifierSyntax.add(new HtmlStartTagPhraseModifier());
        phraseModifierSyntax.beginGroup("(?:(?<=[\\s\\.,\\\"'?!;:\\)\\(\\{\\}\\[\\]])|^)(?:", 0);
        phraseModifierSyntax.add(new EscapeTextilePhraseModifier());
        phraseModifierSyntax.add(new SimpleTextilePhraseModifier("**", DocumentBuilder.SpanType.BOLD, true));
        phraseModifierSyntax.add(new SimpleTextilePhraseModifier("??", DocumentBuilder.SpanType.CITATION, true));
        phraseModifierSyntax.add(new SimpleTextilePhraseModifier("__", DocumentBuilder.SpanType.ITALIC, true));
        phraseModifierSyntax.add(new SimpleTextilePhraseModifier("_", DocumentBuilder.SpanType.EMPHASIS, true));
        phraseModifierSyntax.add(new SimpleTextilePhraseModifier("*", DocumentBuilder.SpanType.STRONG, true));
        phraseModifierSyntax.add(new SimpleTextilePhraseModifier("+", DocumentBuilder.SpanType.INSERTED, true));
        phraseModifierSyntax.add(new SimpleTextilePhraseModifier("~", DocumentBuilder.SpanType.SUBSCRIPT, false));
        phraseModifierSyntax.add(new SimpleTextilePhraseModifier("^", DocumentBuilder.SpanType.SUPERSCRIPT, false));
        phraseModifierSyntax.add(new SimpleTextilePhraseModifier("@", DocumentBuilder.SpanType.CODE, false));
        phraseModifierSyntax.add(new SimpleTextilePhraseModifier("%", DocumentBuilder.SpanType.SPAN, true));
        phraseModifierSyntax.add(new SimpleTextilePhraseModifier("-", DocumentBuilder.SpanType.DELETED, true));
        phraseModifierSyntax.add(new ImageTextilePhraseModifier());
        phraseModifierSyntax.endGroup(")(?=\\W|$)", 0);
        tokenSyntax.add(new EntityReferenceReplacementToken("(tm)", "#8482"));
        tokenSyntax.add(new EntityReferenceReplacementToken("(TM)", "#8482"));
        tokenSyntax.add(new EntityReferenceReplacementToken("(c)", "#169"));
        tokenSyntax.add(new EntityReferenceReplacementToken("(C)", "#169"));
        tokenSyntax.add(new EntityReferenceReplacementToken("(r)", "#174"));
        tokenSyntax.add(new EntityReferenceReplacementToken("(R)", "#174"));
        tokenSyntax.add(new HyperlinkReplacementToken());
        tokenSyntax.add(new FootnoteReferenceReplacementToken());
        tokenSyntax.add(new EntityWrappingReplacementToken("\"", "#8220", "#8221"));
        tokenSyntax.add(new EntityWrappingReplacementToken("'", "#8216", "#8217"));
        tokenSyntax.add(new PatternEntityReferenceReplacementToken("(?:(?<=\\w)(')(?=\\w))", "#8217"));
        tokenSyntax.add(new PatternEntityReferenceReplacementToken("(?:(?<=\\w\\s)(--)(?=\\s\\w))", "#8212"));
        tokenSyntax.add(new PatternEntityReferenceReplacementToken("(?:(?<=\\w\\s)(-)(?=\\s\\w))", "#8211"));
        tokenSyntax.add(new PatternEntityReferenceReplacementToken("(?:(?<=\\d\\s)(x)(?=\\s\\d))", "#215"));
        tokenSyntax.add(new AcronymReplacementToken());
    }
}

