/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.textile.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.markup.Block;
import net.java.textilej.parser.markup.textile.Textile;
import net.java.textilej.parser.markup.textile.TextileDialect;

public class ParagraphBlock
extends Block {
    private static final int LINE_REMAINDER_GROUP_OFFSET = 8;
    static final Pattern startPattern = Pattern.compile("p(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}\\.\\s+(.*)");
    private int blockLineCount = 0;
    private boolean unwrapped = false;

    @Override
    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            if (offset == 0) {
                Matcher matcher = startPattern.matcher(line);
                if (matcher.matches()) {
                    Textile.configureAttributes(attributes, matcher, 1, true);
                    offset = matcher.start(8);
                } else if (line.charAt(0) == ' ') {
                    offset = 1;
                    this.unwrapped = true;
                }
            }
            if (!this.unwrapped) {
                this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, attributes);
            }
        }
        if (this.dialect.isEmptyLine(line)) {
            this.setClosed(true);
            return 0;
        }
        TextileDialect dialect = (TextileDialect)this.getDialect();
        for (Block block : dialect.getParagraphBreakingBlocks()) {
            if (!block.canStart(line, offset)) continue;
            this.setClosed(true);
            return 0;
        }
        if (this.blockLineCount != 0) {
            if (this.unwrapped) {
                this.builder.characters("\n");
            } else {
                this.builder.lineBreak();
            }
        }
        ++this.blockLineCount;
        dialect.emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    @Override
    public boolean canStart(String line, int lineOffset) {
        this.unwrapped = false;
        this.blockLineCount = 0;
        return true;
    }

    @Override
    public void setClosed(boolean closed) {
        if (closed && !this.isClosed() && !this.unwrapped) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

