/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.textile.phrase;

import java.util.regex.Pattern;
import net.java.textilej.parser.ImageAttributes;
import net.java.textilej.parser.markup.PatternBasedElement;
import net.java.textilej.parser.markup.PatternBasedElementProcessor;
import net.java.textilej.parser.markup.textile.Textile;
import net.java.textilej.parser.markup.textile.TextileContentState;

public class ImageTextilePhraseModifier
extends PatternBasedElement {
    protected static final int ALIGNMENT_GROUP = 5;
    protected static final int CONTENT_GROUP = 6;
    protected static final int ATTRIBUTES_OFFSET = 1;

    @Override
    protected String getPattern(int groupOffset) {
        String quotedDelimiter = Pattern.quote("!");
        return quotedDelimiter + "(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}" + "(<|>|=)?(\\S(?:.*?\\S)?)(\\([^\\)]+\\))?" + quotedDelimiter + "(:([^\\s]*[^\\s!.)(,]))?";
    }

    @Override
    protected int getPatternGroupCount() {
        return 9;
    }

    @Override
    protected PatternBasedElementProcessor newProcessor() {
        return new ImagePhraseModifierProcessor();
    }

    private static class ImagePhraseModifierProcessor
    extends PatternBasedElementProcessor {
        private ImagePhraseModifierProcessor() {
        }

        @Override
        public void emit() {
            String namedLinkUrl;
            String alignment = this.group(5);
            String imageUrl = this.group(6);
            String altAndTitle = this.group(7);
            String href = this.group(9);
            String string = namedLinkUrl = href == null ? null : ((TextileContentState)this.getState()).getNamedLinkUrl(href);
            if (namedLinkUrl != null) {
                href = namedLinkUrl;
            }
            ImageAttributes attributes = new ImageAttributes();
            attributes.setTitle(altAndTitle);
            attributes.setAlt(altAndTitle);
            if (alignment != null) {
                if ("<".equals(alignment)) {
                    attributes.setAlign(ImageAttributes.Align.Left);
                } else if (">".equals(alignment)) {
                    attributes.setAlign(ImageAttributes.Align.Right);
                } else if ("=".equals(alignment)) {
                    attributes.setAlign(ImageAttributes.Align.Center);
                }
            }
            Textile.configureAttributes(this, attributes, 1, false);
            if (href != null) {
                this.builder.imageLink(attributes, href, imageUrl);
            } else {
                this.builder.image(attributes, imageUrl);
            }
        }
    }
}

