/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.textile.phrase;

import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.markup.PatternBasedElement;
import net.java.textilej.parser.markup.PatternBasedElementProcessor;
import net.java.textilej.parser.markup.textile.Textile;

public class SimpleTextilePhraseModifier
extends PatternBasedElement {
    protected static final int CONTENT_GROUP = 5;
    protected static final int ATTRIBUTES_OFFSET = 1;
    private String delimiter;
    private DocumentBuilder.SpanType spanType;
    private final boolean nesting;

    public SimpleTextilePhraseModifier(String delimiter, DocumentBuilder.SpanType spanType, boolean nesting) {
        this.delimiter = delimiter;
        this.spanType = spanType;
        this.nesting = nesting;
    }

    @Override
    protected String getPattern(int groupOffset) {
        String quotedDelimiter = this.quoteLite(this.getDelimiter());
        return quotedDelimiter + "(?!" + quotedDelimiter + ")" + "(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}" + "([^\\s" + quotedDelimiter + "]+|\\S[^" + quotedDelimiter + "]*[^\\s" + quotedDelimiter + "])" + quotedDelimiter;
    }

    private String quoteLite(String literal) {
        StringBuilder buf = new StringBuilder(literal.length() * 2);
        for (int x = 0; x < literal.length(); ++x) {
            char c = literal.charAt(x);
            switch (c) {
                case '*': 
                case '+': 
                case '?': 
                case '^': {
                    buf.append('\\');
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    @Override
    protected int getPatternGroupCount() {
        return 5;
    }

    protected String getDelimiter() {
        return this.delimiter;
    }

    protected static void configureAttributes(PatternBasedElementProcessor processor, Attributes attributes) {
        Textile.configureAttributes(processor, attributes, 1, false);
    }

    protected static String getContent(PatternBasedElementProcessor processor) {
        return processor.group(5);
    }

    protected static int getStart(PatternBasedElementProcessor processor) {
        return processor.start(5);
    }

    @Override
    protected PatternBasedElementProcessor newProcessor() {
        return new SimplePhraseModifierProcessor(this.spanType, this.nesting);
    }

    private static class SimplePhraseModifierProcessor
    extends PatternBasedElementProcessor {
        private final DocumentBuilder.SpanType spanType;
        private final boolean nesting;

        public SimplePhraseModifierProcessor(DocumentBuilder.SpanType spanType, boolean nesting) {
            this.spanType = spanType;
            this.nesting = nesting;
        }

        @Override
        public void emit() {
            Attributes attributes = new Attributes();
            SimpleTextilePhraseModifier.configureAttributes(this, attributes);
            this.getBuilder().beginSpan(this.spanType, attributes);
            if (this.nesting) {
                this.getDialect().emitMarkupLine(this.parser, this.state, this.state.getLineCharacterOffset() + SimpleTextilePhraseModifier.getStart(this), SimpleTextilePhraseModifier.getContent(this), 0);
            } else {
                this.getDialect().emitMarkupText(this.parser, this.state, SimpleTextilePhraseModifier.getContent(this));
            }
            this.getBuilder().endSpan();
        }
    }
}

