/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.trac;

import java.util.ArrayList;
import java.util.List;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.markup.Block;
import net.java.textilej.parser.markup.Dialect;
import net.java.textilej.parser.markup.token.ImpliedHyperlinkReplacementToken;
import net.java.textilej.parser.markup.trac.block.HeadingBlock;
import net.java.textilej.parser.markup.trac.block.ListBlock;
import net.java.textilej.parser.markup.trac.block.ParagraphBlock;
import net.java.textilej.parser.markup.trac.block.PreformattedBlock;
import net.java.textilej.parser.markup.trac.block.QuoteBlock;
import net.java.textilej.parser.markup.trac.block.TableBlock;
import net.java.textilej.parser.markup.trac.phrase.EscapePhraseModifier;
import net.java.textilej.parser.markup.trac.phrase.SimplePhraseModifier;
import net.java.textilej.parser.markup.trac.token.BangEscapeToken;
import net.java.textilej.parser.markup.trac.token.HyperlinkReplacementToken;
import net.java.textilej.parser.markup.trac.token.LineBreakToken;

public class TracWikiDialect
extends Dialect {
    private List<Block> blocks = new ArrayList<Block>();
    private List<Block> paragraphNestableBlocks = new ArrayList<Block>();
    private static Dialect.PatternBasedSyntax tokenSyntax = new Dialect.PatternBasedSyntax();
    private static Dialect.PatternBasedSyntax phraseModifierSyntax = new Dialect.PatternBasedSyntax();

    public TracWikiDialect() {
        ListBlock listBlock = new ListBlock();
        this.blocks.add(listBlock);
        this.paragraphNestableBlocks.add(listBlock);
        HeadingBlock headingBlock = new HeadingBlock();
        this.blocks.add(headingBlock);
        this.paragraphNestableBlocks.add(listBlock);
        PreformattedBlock preformattedBlock = new PreformattedBlock();
        this.blocks.add(preformattedBlock);
        this.paragraphNestableBlocks.add(preformattedBlock);
        QuoteBlock quoteBlock = new QuoteBlock();
        this.blocks.add(quoteBlock);
        this.paragraphNestableBlocks.add(quoteBlock);
        TableBlock tableBlock = new TableBlock();
        this.blocks.add(tableBlock);
        this.paragraphNestableBlocks.add(tableBlock);
        this.blocks.add(new ParagraphBlock());
    }

    @Override
    public List<Block> getBlocks() {
        return this.blocks;
    }

    public List<Block> getParagraphNestableBlocks() {
        return this.paragraphNestableBlocks;
    }

    @Override
    protected Dialect.PatternBasedSyntax getPhraseModifierSyntax() {
        return phraseModifierSyntax;
    }

    @Override
    protected Dialect.PatternBasedSyntax getReplacementTokenSyntax() {
        return tokenSyntax;
    }

    static {
        phraseModifierSyntax.beginGroup("(?:(?<=[\\s\\.\\\"'?!;:\\)\\(\\{\\}\\[\\]])|^)(?:", 0);
        phraseModifierSyntax.add(new EscapePhraseModifier());
        phraseModifierSyntax.add(new SimplePhraseModifier("'''''", new DocumentBuilder.SpanType[]{DocumentBuilder.SpanType.BOLD, DocumentBuilder.SpanType.ITALIC}, true));
        phraseModifierSyntax.add(new SimplePhraseModifier("'''", DocumentBuilder.SpanType.BOLD, true));
        phraseModifierSyntax.add(new SimplePhraseModifier("''", DocumentBuilder.SpanType.ITALIC, true));
        phraseModifierSyntax.add(new SimplePhraseModifier("__", DocumentBuilder.SpanType.UNDERLINED, true));
        phraseModifierSyntax.add(new SimplePhraseModifier("--", DocumentBuilder.SpanType.DELETED, true));
        phraseModifierSyntax.add(new SimplePhraseModifier("^", DocumentBuilder.SpanType.SUPERSCRIPT, true));
        phraseModifierSyntax.add(new SimplePhraseModifier(",,", DocumentBuilder.SpanType.SUBSCRIPT, true));
        phraseModifierSyntax.endGroup(")(?=\\W|$)", 0);
        tokenSyntax.add(new BangEscapeToken());
        tokenSyntax.add(new LineBreakToken());
        tokenSyntax.add(new HyperlinkReplacementToken());
        tokenSyntax.add(new ImpliedHyperlinkReplacementToken());
    }
}

