/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.trac.block;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.markup.Block;

public class QuoteBlock
extends Block {
    static final Pattern startPattern = Pattern.compile("(?:(?:(>+)\\s+)|(  ))(.*)");
    private int blockLineCount = 0;
    private Matcher matcher;
    private Stack<BlockState> quoteBlockState;

    @Override
    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            this.quoteBlockState = new Stack();
        } else {
            this.matcher = startPattern.matcher(line);
            if (!this.matcher.matches()) {
                this.setClosed(true);
                return 0;
            }
        }
        String quoteStartGroup = this.matcher.group(1);
        int level = quoteStartGroup == null ? 1 : quoteStartGroup.length();
        offset = this.matcher.start(3);
        while (this.quoteBlockState.size() > level) {
            this.closeOne();
        }
        while (this.quoteBlockState.size() < level) {
            this.openOne(new Attributes());
        }
        BlockState blockState = this.quoteBlockState.peek();
        if (!blockState.paraOpen) {
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
            blockState.paraOpen = true;
        } else if (this.blockLineCount != 0) {
            this.builder.lineBreak();
        }
        ++this.blockLineCount;
        this.getDialect().emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    private void openOne(Attributes attributes) {
        if (!this.quoteBlockState.isEmpty()) {
            BlockState blockState = this.quoteBlockState.peek();
            if (blockState.paraOpen) {
                blockState.paraOpen = false;
                this.builder.endBlock();
            }
        }
        this.builder.beginBlock(DocumentBuilder.BlockType.QUOTE, attributes);
        this.quoteBlockState.push(new BlockState());
    }

    @Override
    public boolean canStart(String line, int lineOffset) {
        this.quoteBlockState = null;
        this.blockLineCount = 0;
        this.matcher = startPattern.matcher(line);
        if (lineOffset > 0) {
            this.matcher.region(lineOffset, line.length());
        }
        return this.matcher.matches();
    }

    @Override
    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            while (this.quoteBlockState != null && !this.quoteBlockState.isEmpty()) {
                this.closeOne();
            }
            this.quoteBlockState = null;
        }
        super.setClosed(closed);
    }

    private void closeOne() {
        BlockState blockState = this.quoteBlockState.pop();
        if (blockState.paraOpen) {
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    private static class BlockState {
        boolean paraOpen;

        private BlockState() {
        }
    }
}

