/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import net.java.textilej.parser.markup.textile.TextileDialect;
import net.java.textilej.parser.util.MarkupToDocbook;

public class TextileToDocbook
extends MarkupToDocbook {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block10: {
            try {
                File outputFile;
                if (args.length < 1) {
                    TextileToDocbook.usage();
                    System.exit(-1);
                }
                File inputFile = new File(args[0]);
                File file = outputFile = args.length < 2 ? null : new File(args[1]);
                if (outputFile != null && outputFile.exists()) {
                    System.err.println("File " + outputFile + " already exists");
                    TextileToDocbook.usage();
                    System.exit(-1);
                }
                if (!inputFile.exists()) {
                    System.err.println("File " + outputFile + " does not exist");
                    TextileToDocbook.usage();
                    System.exit(-1);
                }
                String textileSource = TextileToDocbook.readFully(inputFile);
                TextileToDocbook textileToDocbook = new TextileToDocbook();
                String name = inputFile.getName();
                if (name.lastIndexOf(46) != -1) {
                    name = name.substring(0, name.lastIndexOf(46));
                }
                textileToDocbook.setBookTitle(name);
                String docbookSource = textileToDocbook.parse(textileSource);
                if (outputFile == null) {
                    System.out.println(docbookSource);
                    break block10;
                }
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "utf-8");
                try {
                    writer.write(docbookSource);
                }
                finally {
                    ((Writer)writer).close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    public TextileToDocbook() {
        this.setDialect(new TextileDialect());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFully(File inputFile) throws IOException {
        int length = (int)inputFile.length();
        if (length <= 0) {
            length = 2048;
        }
        StringBuilder buf = new StringBuilder(length);
        BufferedReader reader = new BufferedReader(new FileReader(inputFile));
        try {
            int c;
            while ((c = ((Reader)reader).read()) != -1) {
                buf.append((char)c);
            }
        }
        finally {
            ((Reader)reader).close();
        }
        return buf.toString();
    }

    private static void usage() {
        System.err.println("Usage: java " + TextileToDocbook.class.getName() + " <input file> [output file]");
    }
}

