/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.java.textilej.util.XmlStreamWriter;

public class LoggingXMLStreamWriter
implements XmlStreamWriter {
    private XmlStreamWriter delegate;
    private Logger logger = Logger.getLogger(LoggingXMLStreamWriter.class.getName());
    private List<String> elementNames = new ArrayList<String>();

    public LoggingXMLStreamWriter(XmlStreamWriter delegate) {
        this.delegate = delegate;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public String getPrefix(String uri) {
        return this.delegate.getPrefix(uri);
    }

    @Override
    public void setDefaultNamespace(String uri) {
        this.delegate.setDefaultNamespace(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) {
        this.delegate.setPrefix(prefix, uri);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) {
        this.delegate.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) {
        this.delegate.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String localName, String value) {
        this.delegate.writeAttribute(localName, value);
    }

    @Override
    public void writeCData(String data) {
        this.delegate.writeCData(data);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) {
        this.delegate.writeCharacters(text, start, len);
    }

    @Override
    public void writeCharacters(String text) {
        this.delegate.writeCharacters(text);
    }

    @Override
    public void writeLiteral(String literal) {
        this.delegate.writeLiteral(literal);
    }

    @Override
    public void writeComment(String data) {
        this.delegate.writeComment(data);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) {
        this.delegate.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeDTD(String dtd) {
        this.delegate.writeDTD(dtd);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) {
        this.logger.info("Empty element[" + this.elementNames.size() + "] " + localName);
        this.delegate.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) {
        this.logger.info("Empty element[" + this.elementNames.size() + "] " + localName);
        this.delegate.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String localName) {
        this.logger.info("Empty element[" + this.elementNames.size() + "] " + localName);
        this.delegate.writeEmptyElement(localName);
    }

    @Override
    public void writeEndDocument() {
        this.delegate.writeEndDocument();
    }

    @Override
    public void writeEndElement() {
        if (this.elementNames.size() == 0) {
            throw new IllegalStateException("Too many end elements");
        }
        this.logger.info("End element[" + this.elementNames.size() + "]: " + this.elementNames);
        this.elementNames.remove(this.elementNames.size() - 1);
        this.delegate.writeEndElement();
    }

    @Override
    public void writeEntityRef(String name) {
        this.delegate.writeEntityRef(name);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) {
        this.delegate.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) {
        this.delegate.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeProcessingInstruction(String target) {
        this.delegate.writeProcessingInstruction(target);
    }

    @Override
    public void writeStartDocument() {
        this.delegate.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String encoding, String version) {
        this.delegate.writeStartDocument(encoding, version);
    }

    @Override
    public void writeStartDocument(String version) {
        this.delegate.writeStartDocument(version);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) {
        this.elementNames.add(localName);
        this.logger.info("Start element[" + this.elementNames.size() + "] " + this.elementNames);
        this.delegate.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) {
        this.elementNames.add(localName);
        this.logger.info("Start element[" + this.elementNames.size() + "] " + this.elementNames);
        this.delegate.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String localName) {
        this.elementNames.add(localName);
        this.logger.info("Start element[" + this.elementNames.size() + "] " + this.elementNames);
        this.delegate.writeStartElement(localName);
    }
}

