/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.util.anttask;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.java.textilej.parser.MarkupParser;
import net.java.textilej.parser.builder.DocBookDocumentBuilder;
import net.java.textilej.parser.markup.textile.TextileDialect;
import net.java.textilej.util.XmlStreamWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class TextileToDocbookTask
extends Task {
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private String docbookFilenameFormat = "$1.xml";
    private String bookTitle;
    private boolean overwrite = true;
    protected File file;
    private String doctype;

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void execute() throws BuildException {
        if (this.file == null && this.filesets.isEmpty()) {
            throw new BuildException("Please add one or more source filesets or specify @file");
        }
        if (this.file != null && !this.filesets.isEmpty()) {
            throw new BuildException("@file may not be specified if filesets are also specified");
        }
        if (this.file != null) {
            if (!this.file.exists()) {
                throw new BuildException(String.format("File cannot be found: %s", this.file));
            }
            if (!this.file.isFile()) {
                throw new BuildException(String.format("Not a file: %s", this.file));
            }
            if (!this.file.canRead()) {
                throw new BuildException(String.format("Cannot read file: %s", this.file));
            }
        }
        for (FileSet fileset : this.filesets) {
            File filesetBaseDir = fileset.getDir(this.getProject());
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            if (files == null) continue;
            File baseDir = ds.getBasedir();
            for (String file : files) {
                File inputFile = new File(baseDir, file);
                try {
                    this.processFile(filesetBaseDir, inputFile);
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BuildException(String.format("Cannot process file '%s': %s", inputFile, e.getMessage()), (Throwable)e);
                }
            }
        }
        if (this.file != null) {
            try {
                this.processFile(this.file.getParentFile(), this.file);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException(String.format("Cannot process file '%s': %s", this.file, e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(File baseDir, File source) throws BuildException {
        File docbookOutputFile;
        this.log(String.format("Processing file '%s'", source), 3);
        String textile = null;
        String name = source.getName();
        if (name.lastIndexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if (!(docbookOutputFile = new File(source.getParentFile(), this.docbookFilenameFormat.replace("$1", name))).exists() || this.overwrite || docbookOutputFile.lastModified() < source.lastModified()) {
            OutputStreamWriter writer;
            if (textile == null) {
                textile = this.readFully(source);
            }
            try {
                writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(docbookOutputFile)), "utf-8");
            }
            catch (Exception e) {
                throw new BuildException(String.format("Cannot write to file '%s': %s", docbookOutputFile, e.getMessage()), (Throwable)e);
            }
            try {
                DocBookDocumentBuilder builder = new DocBookDocumentBuilder(writer){

                    @Override
                    protected XmlStreamWriter createXmlStreamWriter(Writer out) {
                        return super.createFormattingXmlStreamWriter(out);
                    }
                };
                MarkupParser parser = new MarkupParser();
                parser.setDialect(new TextileDialect());
                parser.setBuilder(builder);
                builder.setBookTitle(this.bookTitle == null ? name : this.bookTitle);
                if (this.doctype != null) {
                    builder.setDoctype(this.doctype);
                }
                parser.parse(textile);
            }
            catch (Throwable throwable) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception e) {
                    throw new BuildException(String.format("Cannot write to file '%s': %s", docbookOutputFile, e.getMessage()), (Throwable)e);
                }
                throw throwable;
            }
            try {
                ((Writer)writer).close();
            }
            catch (Exception e) {
                throw new BuildException(String.format("Cannot write to file '%s': %s", docbookOutputFile, e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFully(File inputFile) {
        StringWriter w = new StringWriter();
        try {
            InputStreamReader r = new InputStreamReader(new BufferedInputStream(new FileInputStream(inputFile)));
            try {
                int i;
                while ((i = ((Reader)r).read()) != -1) {
                    w.write((char)i);
                }
            }
            finally {
                ((Reader)r).close();
            }
        }
        catch (IOException e) {
            throw new BuildException(String.format("Cannot read file '%s': %s", inputFile, e.getMessage()), (Throwable)e);
        }
        return w.toString();
    }

    public String getDocbookFilenameFormat() {
        return this.docbookFilenameFormat;
    }

    public void setHtmlFilenameFormat(String docbookFilenameFormat) {
        this.docbookFilenameFormat = docbookFilenameFormat;
    }

    public String getBookTitle() {
        return this.bookTitle;
    }

    public void setBookTitle(String bookTitle) {
        this.bookTitle = bookTitle;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public String getDoctype() {
        return this.doctype;
    }
}

