/*
 * Decompiled with CFR 0.152.
 */
package plugins.Sharesite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import plugins.Sharesite.Freesite;
import plugins.Sharesite.Plugin;
import plugins.Sharesite.common.FileStorage;
import plugins.Sharesite.common.SmartMap;

public class Database {
    private ArrayList<Freesite> freesites = new ArrayList();
    private ArrayList<Freesite> recentlyDeleted = new ArrayList();
    private int nextUniqueKey = 0;
    private long lastDeletedTime = 0L;

    public Database() {
        this.addFromMap(FileStorage.load("Sharesite.db"));
    }

    public synchronized int numFreesites() {
        return this.freesites.size();
    }

    public synchronized ArrayList<Freesite> getFreesites() {
        return new ArrayList<Freesite>(this.freesites);
    }

    public synchronized Freesite getFreesiteWithUniqueKey(int uniqueKey) {
        for (int i = 0; i < this.freesites.size(); ++i) {
            if (this.freesites.get(i).getUniqueKey() != uniqueKey) continue;
            return this.freesites.get(i);
        }
        return null;
    }

    public synchronized int numDeleted() {
        return this.recentlyDeleted.size();
    }

    public synchronized void createFreesite() {
        Freesite c = new Freesite(this.nextUniqueKey);
        ++this.nextUniqueKey;
        this.freesites.add(c);
    }

    public synchronized void delete(Freesite freesite) {
        this.freesites.remove(freesite);
        this.recentlyDeleted.add(freesite);
        this.lastDeletedTime = System.currentTimeMillis();
    }

    public synchronized void restoreDeleted() {
        this.freesites.addAll(this.recentlyDeleted);
        this.recentlyDeleted = new ArrayList();
        Collections.sort(this.freesites);
    }

    public synchronized void save() {
        if (this.recentlyDeleted.size() > 0 && System.currentTimeMillis() > this.lastDeletedTime + 10800000L) {
            this.recentlyDeleted = new ArrayList();
        }
        try {
            FileStorage.save("Sharesite.db", this.getDatabaseAsMap());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized SmartMap getDatabaseAsMap() {
        SmartMap map = new SmartMap();
        map.putint("increasingCounter", this.nextUniqueKey);
        map.putlong("lastDeletedTime", this.lastDeletedTime);
        for (Freesite c : this.freesites) {
            c.save(map);
        }
        for (Freesite c : this.recentlyDeleted) {
            c.save(map);
        }
        ArrayList<Integer> keys = new ArrayList<Integer>();
        for (int i = 0; i < this.freesites.size(); ++i) {
            keys.add(this.freesites.get(i).getUniqueKey());
        }
        map.putintary("keys", keys);
        ArrayList<Integer> deleted = new ArrayList<Integer>();
        for (int i = 0; i < this.recentlyDeleted.size(); ++i) {
            deleted.add(this.recentlyDeleted.get(i).getUniqueKey());
        }
        map.putintary("deleted_keys", deleted);
        return map;
    }

    public synchronized void addFromMap(SmartMap map) {
        int appendUniqueKey = this.nextUniqueKey;
        this.nextUniqueKey += map.getint("increasingCounter", 0);
        long deletedTime = map.getlong("lastDeletedTime", 0L);
        if (deletedTime > this.lastDeletedTime) {
            this.lastDeletedTime = deletedTime;
        }
        Plugin.instance.logger.putstr("nextUniqueKey=" + this.nextUniqueKey);
        Plugin.instance.logger.putstr("keys=" + map.getstr("keys", "(none)"));
        ArrayList<Integer> keys = map.getintary("keys", new ArrayList<Integer>());
        for (int key : keys) {
            Plugin.instance.logger.putstr("Loading freesite key=" + key);
            Freesite c = new Freesite(appendUniqueKey + key);
            c.load(map, key);
            this.freesites.add(c);
            if (key < this.nextUniqueKey) continue;
            this.nextUniqueKey = key + 1;
        }
        Plugin.instance.logger.putstr("deleted_keys=" + map.getstr("deleted_keys", "(none)"));
        ArrayList<Integer> deleted = map.getintary("deleted_keys", new ArrayList<Integer>());
        for (int key : deleted) {
            Plugin.instance.logger.putstr("Loading freesite key=" + key);
            Freesite c = new Freesite(appendUniqueKey + key);
            c.load(map, key);
            this.recentlyDeleted.add(c);
            if (key < this.nextUniqueKey) continue;
            this.nextUniqueKey = key + 1;
        }
    }
}

