/*
 * Decompiled with CFR 0.152.
 */
package plugins.Sharesite.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import plugins.Sharesite.Plugin;
import plugins.Sharesite.common.MapToData;
import plugins.Sharesite.common.SmartMap;

public class FileStorage {
    public static synchronized SmartMap load(String filename) {
        File userdir = Plugin.instance.pluginRespirator.getNode().getUserDir();
        File file = new File(userdir, filename);
        File temp = new File(userdir, filename + ".tmp");
        SmartMap map = new SmartMap();
        if (temp.exists()) {
            Plugin.instance.logger.putstr("Reverting database from unclean shutdown ...");
            file.delete();
            temp.renameTo(file);
        }
        if (!file.exists()) {
            Plugin.instance.logger.putstr("No file " + filename + " exists!");
            return map;
        }
        try {
            int got;
            long lsize = file.length();
            if (lsize > 0x40000000L) {
                throw new IOException();
            }
            int size = (int)lsize;
            Plugin.instance.logger.putstr("File " + filename + " is of size " + size + " bytes");
            FileInputStream in = new FileInputStream(file);
            byte[] data = new byte[size];
            for (int read = 0; read < size; read += got) {
                got = in.read(data, read, size - read);
                if (got >= 0) continue;
                throw new IOException();
            }
            if (in.read() >= 0) {
                throw new IOException();
            }
            in.close();
            map = MapToData.dataToMap(data);
            if (map.size() == 0) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            Plugin.instance.logger.putstr("File appears corrupted!!!");
            File corrupted = new File(userdir, filename + ".corrupted");
            corrupted.delete();
            file.renameTo(corrupted);
            map = new SmartMap();
        }
        return map;
    }

    public static synchronized void save(String filename, SmartMap map) throws IOException {
        File userdir = Plugin.instance.pluginRespirator.getNode().getUserDir();
        File file = new File(userdir, filename);
        File temp = new File(userdir, filename + ".tmp");
        Plugin.instance.logger.putstr("Saving as " + filename + " ...");
        temp.delete();
        if (file.exists()) {
            file.renameTo(temp);
        }
        FileOutputStream out = new FileOutputStream(file);
        out.write(MapToData.mapToData(map));
        out.flush();
        out.getFD().sync();
        out.close();
        temp.delete();
    }
}

