/*
 * Decompiled with CFR 0.152.
 */
package plugins.Sharesite.webui;

import freenet.clients.http.InfoboxNode;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.BaseL10n;
import freenet.pluginmanager.PluginRespirator;
import freenet.support.HTMLNode;
import freenet.support.api.HTTPRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import plugins.Sharesite.Freesite;
import plugins.Sharesite.Plugin;

public class EditToadlet
extends Toadlet {
    private PluginRespirator pr;
    private PageMaker pageMaker;
    private BaseL10n l10n;

    protected EditToadlet() {
        super(null);
        this.pr = Plugin.instance.pluginRespirator;
        this.pageMaker = this.pr.getPageMaker();
        this.l10n = Plugin.instance.l10n;
    }

    public String path() {
        return "/Sharesite/Edit/";
    }

    public void handleMethodGET(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        String[] split = uri.getPath().split("/");
        int siteId = -1;
        try {
            siteId = Integer.parseInt(split[3]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Freesite c = Plugin.instance.database.getFreesiteWithUniqueKey(siteId);
        if (c == null) {
            this.writeTemporaryRedirect(ctx, "Redirecting...", "/Sharesite/");
            return;
        }
        PageNode pageNode = this.pageMaker.getPageNode(this.l10n.getString("Sharesite.Menu.Name"), ctx);
        HTMLNode editForm = this.pr.addFormChild(pageNode.content, "/Sharesite/Edit/" + siteId, "editForm");
        this.addNodes(editForm, c.getName(), c.getDescription(), c.getText(), c.getCSS(), c.getActivelinkUri(), c.getRequestSSK(), c.getInsertSSK());
        String ret = pageNode.outer.generate();
        this.writeHTMLReply(ctx, 200, "OK", ret);
    }

    private void addNodes(HTMLNode form, String name, String desc, String text, String css, String aUri, String rkey, String ikey) {
        InfoboxNode editBox = this.pageMaker.getInfobox(this.l10n.getString("Sharesite.Edit.Header"));
        form.addChild(editBox.outer);
        HTMLNode quickLinks = editBox.content.addChild("p");
        quickLinks.addChild("a", "href", "/Sharesite/", this.l10n.getString("Sharesite.Edit.MenuLink"));
        HTMLNode topBtnDiv = editBox.content.addChild("p");
        String[] attrs = new String[]{"type", "name", "value"};
        String[] vals = new String[]{"submit", "saveBtn", this.l10n.getString("Sharesite.Edit.SaveBtn")};
        topBtnDiv.addChild("input", attrs, vals);
        attrs = new String[]{"type", "name", "value"};
        vals = new String[]{"submit", "previewBtn", this.l10n.getString("Sharesite.Edit.PreviewBtn")};
        topBtnDiv.addChild("input", attrs, vals);
        attrs = new String[]{"type", "name", "value"};
        vals = new String[]{"submit", "preprocessBtn", this.l10n.getString("Sharesite.Edit.PreprocessBtn")};
        topBtnDiv.addChild("input", attrs, vals);
        HTMLNode nameDiv = editBox.content.addChild("p");
        HTMLNode nameSpan = nameDiv.addChild("span");
        nameSpan.addChild("span", this.l10n.getString("Sharesite.Edit.Name"));
        nameSpan.addChild("br");
        attrs = new String[]{"type", "size", "name", "value"};
        vals = new String[]{"text", "80", "nameInput", name};
        nameDiv.addChild("input", attrs, vals);
        HTMLNode descDiv = editBox.content.addChild("p");
        HTMLNode descSpan = descDiv.addChild("span");
        descSpan.addChild("span", this.l10n.getString("Sharesite.Edit.Description"));
        descSpan.addChild("br");
        attrs = new String[]{"name", "rows", "cols", "style"};
        vals = new String[]{"descInput", "3", "80", "font-size: medium;"};
        descDiv.addChild("textarea", attrs, vals, desc);
        HTMLNode textDiv = editBox.content.addChild("p");
        HTMLNode textSpan = textDiv.addChild("span");
        textSpan.addChild("span", this.l10n.getString("Sharesite.Edit.Text"));
        textSpan.addChild("br");
        attrs = new String[]{"name", "rows", "cols", "style"};
        vals = new String[]{"textInput", "20", "80", "font-size: medium;"};
        textDiv.addChild("textarea", attrs, vals, text);
        HTMLNode syntaxHelpNode = editBox.content.addChild("p", this.l10n.getString("Sharesite.Edit.TextSyntax"));
        HTMLNode syntaxTable = syntaxHelpNode.addChild("table");
        HTMLNode syntaxHelp = syntaxTable.addChild("tr");
        HTMLNode syntaxHelpTextile = syntaxHelp.addChild("td", "h2. headline (or h3, h4, ...)");
        HTMLNode syntaxHelpHtml = syntaxHelp.addChild("td");
        HTMLNode syntaxHelpHtmlContent = syntaxHelpHtml.addChild("h2", "headline (or h3, h4, ...)");
        syntaxHelp = syntaxTable.addChild("tr");
        syntaxHelpTextile = syntaxHelp.addChild("td", "\"linkname\":/USK@key/name/N/filepath");
        syntaxHelpHtml = syntaxHelp.addChild("td");
        syntaxHelpHtmlContent = syntaxHelpHtml.addChild("a", "href", "/USK@key/name/N/filepath", "linkname");
        syntaxHelpHtmlContent = syntaxHelpHtml.addChild("em", " (to end of line!)");
        syntaxHelp = syntaxTable.addChild("tr");
        syntaxHelpTextile = syntaxHelp.addChild("td", "!/USK@key/path/N/activelink.png!");
        syntaxHelpHtml = syntaxHelp.addChild("td");
        syntaxHelpHtmlContent = syntaxHelpHtml.addChild("img", "src", "/USK@0iU87PXyodL2nm6kCpmYntsteViIbMwlJE~wlqIVvZ0,nenxGvjXDElX5RIZxMvwSnOtRzUKJYjoXEDgkhY6Ljw,AQACAAE/freenetproject-mirror/166/activelink.png");
        syntaxHelp = syntaxTable.addChild("tr");
        syntaxHelpTextile = syntaxHelp.addChild("td", "- list item");
        syntaxHelpHtml = syntaxHelp.addChild("td");
        syntaxHelpHtmlContent = syntaxHelpHtml.addChild("ul");
        HTMLNode syntaxHelpHtmlContentInner = syntaxHelpHtml.addChild("li", "list item");
        syntaxHelp = syntaxTable.addChild("tr");
        syntaxHelpTextile = syntaxHelp.addChild("td", "{toc}");
        syntaxHelpHtml = syntaxHelp.addChild("td", "(as the only element in a line inserts table of contents for h2,h3,h4)");
        syntaxHelp = syntaxTable.addChild("tr");
        syntaxHelpTextile = syntaxHelp.addChild("td", "*strong*");
        syntaxHelpHtml = syntaxHelp.addChild("td");
        syntaxHelpHtmlContent = syntaxHelpHtml.addChild("strong", "strong");
        syntaxHelp = syntaxTable.addChild("tr");
        syntaxHelpTextile = syntaxHelp.addChild("td", "_emphasized_");
        syntaxHelpHtml = syntaxHelp.addChild("td");
        syntaxHelpHtmlContent = syntaxHelpHtml.addChild("em", "emphasized");
        syntaxHelp = syntaxTable.addChild("tr");
        syntaxHelpTextile = syntaxHelp.addChild("td", "@code@");
        syntaxHelpHtml = syntaxHelp.addChild("td");
        syntaxHelpHtmlContent = syntaxHelpHtml.addChild("code", "code");
        syntaxHelp = syntaxTable.addChild("tr");
        syntaxHelpTextile = syntaxHelp.addChild("td", "bc. code block");
        syntaxHelpTextile.addChild("br");
        syntaxHelpTextile.addChild("span", "continuing");
        syntaxHelpHtml = syntaxHelp.addChild("td");
        syntaxHelpHtmlContent = syntaxHelpHtml.addChild("pre").addChild("code", "code block\ncontinuing");
        syntaxHelp = syntaxTable.addChild("tr");
        syntaxHelpTextile = syntaxHelp.addChild("td").addChild("pre", "bq. quote\ncontinued");
        syntaxHelpHtml = syntaxHelp.addChild("td");
        syntaxHelpHtmlContent = syntaxHelpHtml.addChild("blockquote", "quote\ncontinued");
        HTMLNode cssDiv = editBox.content.addChild("p");
        HTMLNode cssSpan = cssDiv.addChild("span");
        cssSpan.addChild("span", this.l10n.getString("Sharesite.Edit.CSS"));
        cssSpan.addChild("br");
        attrs = new String[]{"name", "rows", "cols", "style"};
        vals = new String[]{"cssInput", "15", "80", "font-size: medium;"};
        try {
            cssDiv.addChild("textarea", attrs, vals, css);
        }
        catch (Exception e) {
            cssDiv.addChild("textarea", attrs, vals, "");
        }
        HTMLNode bottomBtnDiv = editBox.content.addChild("p");
        attrs = new String[]{"type", "name", "value"};
        vals = new String[]{"submit", "saveBtn", this.l10n.getString("Sharesite.Edit.SaveBtn")};
        bottomBtnDiv.addChild("input", attrs, vals);
        attrs = new String[]{"type", "name", "value"};
        vals = new String[]{"submit", "previewBtn", this.l10n.getString("Sharesite.Edit.PreviewBtn")};
        bottomBtnDiv.addChild("input", attrs, vals);
        InfoboxNode advBox = this.pageMaker.getInfobox(this.l10n.getString("Sharesite.Edit.Advanced"));
        form.addChild(advBox.outer);
        HTMLNode activelink = advBox.content.addChild("p");
        activelink.addChild("span", this.l10n.getString("Sharesite.Edit.ActivelinkUri"));
        activelink.addChild("br");
        attrs = new String[]{"type", "size", "name", "value"};
        vals = new String[]{"text", "100", "activelinkUriInput", aUri};
        activelink.addChild("input", attrs, vals);
        HTMLNode backup = advBox.content.addChild("p");
        backup.addChild("span", this.l10n.getString("Sharesite.Edit.InsertKey"));
        backup.addChild("br");
        attrs = new String[]{"type", "size", "name", "value"};
        vals = new String[]{"text", "100", "insertKeyInput", ikey};
        backup.addChild("input", attrs, vals);
        backup.addChild("br");
        backup.addChild("span", this.l10n.getString("Sharesite.Edit.RequestKey"));
        backup.addChild("br");
        attrs = new String[]{"type", "size", "name", "value"};
        vals = new String[]{"text", "100", "requestKeyInput", rkey};
        backup.addChild("input", attrs, vals);
    }

    public void handleMethodPOST(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        String[] split = uri.getPath().split("/");
        int siteId = -1;
        try {
            siteId = Integer.parseInt(split[3]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Freesite c = Plugin.instance.database.getFreesiteWithUniqueKey(siteId);
        if (c == null) {
            this.writeTemporaryRedirect(ctx, "Redirecting...", "/Sharesite/Error/");
            return;
        }
        if (req.isPartSet("saveBtn") || req.isPartSet("previewBtn") || req.isPartSet("preprocessBtn")) {
            String name = req.getPartAsStringFailsafe("nameInput", 1000).trim();
            String desc = req.getPartAsStringFailsafe("descInput", 10000).trim();
            String text = req.getPartAsStringFailsafe("textInput", 1000000000).trim();
            String css = req.getPartAsStringFailsafe("cssInput", 1000000000).trim();
            String activelinkUri = req.getPartAsStringFailsafe("activelinkUriInput", 1000).trim();
            String ikey = req.getPartAsStringFailsafe("insertKeyInput", 1000).trim();
            String rkey = req.getPartAsStringFailsafe("requestKeyInput", 1000).trim();
            Plugin.instance.logger.putstr("POST values:");
            Plugin.instance.logger.putstr("   name=\"" + name + "\"");
            Plugin.instance.logger.putstr("   desc=\"" + desc + "\"");
            Plugin.instance.logger.putstr("   activelinkUri=\"" + activelinkUri + "\"");
            Plugin.instance.logger.putstr("   ikey=\"" + ikey + "\"");
            Plugin.instance.logger.putstr("   rkey=\"" + rkey + "\"");
            boolean changed = false;
            if (!ikey.equals(c.getInsertSSK()) || rkey.equals(c.getRequestSSK())) {
                c.setInsertSSK(ikey);
                c.setRequestSSK(rkey);
                changed = true;
            }
            if (name != null && name.length() > 0 && !name.equals(c.getName())) {
                c.setName(name);
                changed = true;
            }
            if (desc != null && !desc.equals(c.getDescription())) {
                c.setDescription(desc);
                changed = true;
            }
            if (text != null && text.length() > 0 && !text.equals(c.getText())) {
                c.setText(text);
                Plugin.instance.logger.putstr("Source changed!");
                changed = true;
            }
            if (text != null && text.length() > 0 && req.isPartSet("preprocessBtn")) {
                String pstr = this.preprocess(text);
                if (!c.getText().equals(pstr)) {
                    c.setText(pstr);
                    changed = true;
                }
            }
            if (css != null && !css.equals(c.getCSS())) {
                c.setCSS(css);
                changed = true;
            }
            if (activelinkUri != null && !activelinkUri.equals(c.getActivelinkUri())) {
                c.setActivelinkUri(activelinkUri);
                changed = true;
            }
            if (changed) {
                c.setL10nStatus("Status.Modified");
                Plugin.instance.database.save();
            }
        }
        if (req.isPartSet("previewBtn")) {
            this.writeTemporaryRedirect(ctx, "Redirecting...", "/Sharesite/Preview/" + siteId + "/index.html");
        } else {
            this.writeTemporaryRedirect(ctx, "Redirecting...", "/Sharesite/Edit/" + siteId);
        }
    }

    private String preprocess(String text) {
        BufferedReader br = new BufferedReader(new StringReader(text));
        StringBuffer builder = new StringBuffer();
        try {
            int lcount = 1;
            String line = "";
            while ((line = br.readLine()) != null) {
                Pattern keypath;
                Matcher m4;
                Plugin.instance.logger.putstr(lcount + "\t" + line);
                Pattern frostheader = Pattern.compile("^[-]{5}(.*)[-]{5}(.*)[-]{5}$");
                Matcher m5 = frostheader.matcher(line);
                line = m5.replaceAll("p(from). \u2013\u2013\u2013\u2013\u2013 $1 \u2013\u2013\u2013\u2013\u2013 $2 \u2013\u2013\u2013\u2013\u2013");
                Pattern imgpat = Pattern.compile("^(CHK|USK|SSK|KSK)@([^/]*)/(.*\\.)(jpg|JPG|jpeg|JPEG|gif|GIF|png|PNG)$");
                Pattern linkpat = Pattern.compile("^(CHK|USK|SSK|KSK)@([^/]*)/(.*)$");
                Matcher m1 = imgpat.matcher(line);
                line = m1.replaceAll("!(preview)/$1@$2/$3$4!");
                Matcher m2 = linkpat.matcher(line);
                line = m2.replaceAll("\"$3\":/$1@$2/$3");
                Pattern linkdesc = Pattern.compile("(\".*\")(?=:/..K@)");
                Matcher m3 = linkdesc.matcher(line);
                if (m3.find()) {
                    String desc = m3.group();
                    line = m3.replaceFirst(desc.replaceAll("%20", " "));
                }
                if ((m4 = (keypath = Pattern.compile("((?<=--8/)(.*))|((?<=CAAE/)(.*))")).matcher(line)).find()) {
                    String esckey = m4.group();
                    line = m4.replaceFirst(esckey.replaceAll("\\ ", "%20"));
                }
                line = line.replaceAll("%28", "(");
                line = line.replaceAll("%29", ")");
                line = line.replaceAll("%5b", "[");
                line = line.replaceAll("%5d", "]");
                line = line.replaceAll("http://[^/]+:8888/", "");
                builder.append(line + "\n");
                ++lcount;
            }
        }
        catch (IOException e) {
            Plugin.instance.logger.putstr(e.getMessage());
        }
        return builder.toString();
    }
}

