/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.Entry4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.HashtableByteArrayEntry;
import com.db4o.foundation.HashtableIntEntry;
import com.db4o.foundation.HashtableIterator;
import com.db4o.foundation.HashtableObjectEntry;
import com.db4o.foundation.Iterable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.Map4;
import com.db4o.foundation.Visitor4;

public class Hashtable4
implements DeepClone,
Map4 {
    private static final float FILL = 0.5f;
    public int _tableSize;
    public int _mask;
    public int _maximumSize;
    public int _size;
    public HashtableIntEntry[] _table;

    public Hashtable4(int size) {
        size = this.newSize(size);
        this._tableSize = 1;
        while (this._tableSize < size) {
            this._tableSize <<= 1;
        }
        this._mask = this._tableSize - 1;
        this._maximumSize = (int)((float)this._tableSize * 0.5f);
        this._table = new HashtableIntEntry[this._tableSize];
    }

    public Hashtable4() {
        this(1);
    }

    protected Hashtable4(DeepClone cloneOnlyCtor) {
    }

    public int size() {
        return this._size;
    }

    @Override
    public Object deepClone(Object obj) {
        return this.deepCloneInternal(new Hashtable4(null), obj);
    }

    public void forEachKeyForIdentity(Visitor4 visitor, Object obj) {
        for (int i = 0; i < this._table.length; ++i) {
            HashtableIntEntry entry = this._table[i];
            while (entry != null) {
                if (entry._object == obj) {
                    visitor.visit(entry.key());
                }
                entry = entry._next;
            }
        }
    }

    public Object get(byte[] key) {
        int intKey = HashtableByteArrayEntry.hash(key);
        return this.getFromObjectEntry(intKey, key);
    }

    public Object get(int key) {
        HashtableIntEntry entry = this._table[key & this._mask];
        while (entry != null) {
            if (entry._key == key) {
                return entry._object;
            }
            entry = entry._next;
        }
        return null;
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        return this.getFromObjectEntry(key.hashCode(), key);
    }

    public Iterator4 iterator() {
        return new HashtableIterator(this._table);
    }

    public Iterator4 keys() {
        return Iterators.map(this.iterator(), new Function4(){

            @Override
            public Object apply(Object current) {
                return ((Entry4)current).key();
            }
        });
    }

    public Iterator4 values() {
        return Iterators.map(this.iterator(), new Function4(){

            @Override
            public Object apply(Object current) {
                return ((Entry4)current).value();
            }
        });
    }

    public boolean containsKey(Object key) {
        if (null == key) {
            return false;
        }
        return null != this.getObjectEntry(key.hashCode(), key);
    }

    public boolean containsAllKeys(Iterable4 collection) {
        return this.containsAllKeys(collection.iterator());
    }

    public boolean containsAllKeys(Iterator4 iterator) {
        while (iterator.moveNext()) {
            if (this.containsKey(iterator.current())) continue;
            return false;
        }
        return true;
    }

    public void put(byte[] key, Object value) {
        this.putEntry(new HashtableByteArrayEntry(key, value));
    }

    public void put(int key, Object value) {
        this.putEntry(new HashtableIntEntry(key, value));
    }

    @Override
    public void put(Object key, Object value) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        this.putEntry(new HashtableObjectEntry(key, value));
    }

    public Object remove(byte[] key) {
        int intKey = HashtableByteArrayEntry.hash(key);
        return this.removeObjectEntry(intKey, key);
    }

    public void remove(int key) {
        HashtableIntEntry entry = this._table[key & this._mask];
        HashtableIntEntry predecessor = null;
        while (entry != null) {
            if (entry._key == key) {
                this.removeEntry(predecessor, entry);
                return;
            }
            predecessor = entry;
            entry = entry._next;
        }
    }

    public void remove(Object objectKey) {
        int intKey = objectKey.hashCode();
        this.removeObjectEntry(intKey, objectKey);
    }

    public String toString() {
        return Iterators.join(this.iterator(), "{", "}", ", ");
    }

    protected Hashtable4 deepCloneInternal(Hashtable4 ret, Object obj) {
        ret._mask = this._mask;
        ret._maximumSize = this._maximumSize;
        ret._size = this._size;
        ret._tableSize = this._tableSize;
        ret._table = new HashtableIntEntry[this._tableSize];
        for (int i = 0; i < this._tableSize; ++i) {
            if (this._table[i] == null) continue;
            ret._table[i] = (HashtableIntEntry)this._table[i].deepClone(obj);
        }
        return ret;
    }

    private int entryIndex(HashtableIntEntry entry) {
        return entry._key & this._mask;
    }

    private HashtableIntEntry findWithSameKey(HashtableIntEntry newEntry) {
        HashtableIntEntry existing = this._table[this.entryIndex(newEntry)];
        while (null != existing) {
            if (existing.sameKeyAs(newEntry)) {
                return existing;
            }
            existing = existing._next;
        }
        return null;
    }

    private Object getFromObjectEntry(int intKey, Object objectKey) {
        HashtableObjectEntry entry = this.getObjectEntry(intKey, objectKey);
        return entry == null ? null : entry._object;
    }

    private HashtableObjectEntry getObjectEntry(int intKey, Object objectKey) {
        HashtableObjectEntry entry = (HashtableObjectEntry)this._table[intKey & this._mask];
        while (entry != null) {
            if (entry._key == intKey && entry.hasKey(objectKey)) {
                return entry;
            }
            entry = (HashtableObjectEntry)entry._next;
        }
        return null;
    }

    private void increaseSize() {
        this._tableSize <<= 1;
        this._maximumSize <<= 1;
        this._mask = this._tableSize - 1;
        HashtableIntEntry[] temp = this._table;
        this._table = new HashtableIntEntry[this._tableSize];
        for (int i = 0; i < temp.length; ++i) {
            this.reposition(temp[i]);
        }
    }

    private void insert(HashtableIntEntry newEntry) {
        ++this._size;
        if (this._size > this._maximumSize) {
            this.increaseSize();
        }
        int index = this.entryIndex(newEntry);
        newEntry._next = this._table[index];
        this._table[index] = newEntry;
    }

    private final int newSize(int size) {
        return (int)((float)size / 0.5f);
    }

    private void putEntry(HashtableIntEntry newEntry) {
        HashtableIntEntry existing = this.findWithSameKey(newEntry);
        if (null != existing) {
            this.replace(existing, newEntry);
        } else {
            this.insert(newEntry);
        }
    }

    private void removeEntry(HashtableIntEntry predecessor, HashtableIntEntry entry) {
        if (predecessor != null) {
            predecessor._next = entry._next;
        } else {
            this._table[this.entryIndex((HashtableIntEntry)entry)] = entry._next;
        }
        --this._size;
    }

    private Object removeObjectEntry(int intKey, Object objectKey) {
        HashtableObjectEntry entry = (HashtableObjectEntry)this._table[intKey & this._mask];
        HashtableObjectEntry predecessor = null;
        while (entry != null) {
            if (entry._key == intKey && entry.hasKey(objectKey)) {
                this.removeEntry(predecessor, entry);
                return entry._object;
            }
            predecessor = entry;
            entry = (HashtableObjectEntry)entry._next;
        }
        return null;
    }

    private void replace(HashtableIntEntry existing, HashtableIntEntry newEntry) {
        newEntry._next = existing._next;
        HashtableIntEntry entry = this._table[this.entryIndex(existing)];
        if (entry == existing) {
            this._table[this.entryIndex((HashtableIntEntry)existing)] = newEntry;
        } else {
            while (entry._next != existing) {
                entry = entry._next;
            }
            entry._next = newEntry;
        }
    }

    private void reposition(HashtableIntEntry entry) {
        if (entry != null) {
            this.reposition(entry._next);
            entry._next = this._table[this.entryIndex(entry)];
            this._table[this.entryIndex((HashtableIntEntry)entry)] = entry;
        }
    }
}

