/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation.network;

import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.Closure4;
import com.db4o.foundation.Lock4;

class BlockingByteChannel {
    private static final int DISCARD_BUFFER_SIZE = 500;
    protected byte[] i_cache;
    boolean i_closed = false;
    protected int i_readOffset;
    private int i_timeout;
    protected int i_writeOffset;
    protected final Lock4 i_lock = new Lock4();

    public BlockingByteChannel(int timeout) {
        this.i_timeout = timeout;
    }

    protected int available() {
        return this.i_writeOffset - this.i_readOffset;
    }

    protected void checkDiscardCache() {
        if (this.i_readOffset == this.i_writeOffset && this.i_cache.length > 500) {
            this.i_cache = null;
            this.i_readOffset = 0;
            this.i_writeOffset = 0;
        }
    }

    void close() {
        this.i_lock.run(new Closure4(){

            @Override
            public Object run() {
                BlockingByteChannel.this.i_closed = true;
                BlockingByteChannel.this.i_lock.awake();
                return null;
            }
        });
    }

    protected void makefit(int length) {
        if (this.i_cache == null) {
            this.i_cache = new byte[length];
        } else if (this.i_writeOffset + length > this.i_cache.length) {
            if (this.i_writeOffset + length - this.i_readOffset <= this.i_cache.length) {
                byte[] temp = new byte[this.i_cache.length];
                System.arraycopy(this.i_cache, this.i_readOffset, temp, 0, this.i_cache.length - this.i_readOffset);
                this.i_cache = temp;
                this.i_writeOffset -= this.i_readOffset;
                this.i_readOffset = 0;
            } else {
                byte[] temp = new byte[this.i_writeOffset + length];
                System.arraycopy(this.i_cache, 0, temp, 0, this.i_cache.length);
                this.i_cache = temp;
            }
        }
    }

    public int read() throws Db4oIOException {
        Integer ret = (Integer)this.i_lock.run(new Closure4(){

            @Override
            public Object run() {
                BlockingByteChannel.this.waitForAvailable();
                byte retVal = BlockingByteChannel.this.i_cache[BlockingByteChannel.this.i_readOffset++];
                BlockingByteChannel.this.checkDiscardCache();
                return new Integer(retVal);
            }
        });
        return ret;
    }

    public int read(final byte[] bytes, final int offset, final int length) throws Db4oIOException {
        Integer ret = (Integer)this.i_lock.run(new Closure4(){

            @Override
            public Object run() {
                BlockingByteChannel.this.waitForAvailable();
                int avail = BlockingByteChannel.this.available();
                int toRead = length;
                if (avail < length) {
                    toRead = avail;
                }
                System.arraycopy(BlockingByteChannel.this.i_cache, BlockingByteChannel.this.i_readOffset, bytes, offset, toRead);
                BlockingByteChannel.this.i_readOffset += toRead;
                BlockingByteChannel.this.checkDiscardCache();
                return new Integer(toRead);
            }
        });
        return ret;
    }

    public void setTimeout(int timeout) {
        this.i_timeout = timeout;
    }

    protected void waitForAvailable() {
        long beginTime = System.currentTimeMillis();
        while (this.available() == 0) {
            this.checkClosed();
            this.i_lock.snooze(this.i_timeout);
            if (!this.isTimeout(beginTime)) continue;
            throw new Db4oIOException();
        }
    }

    private boolean isTimeout(long start) {
        return System.currentTimeMillis() - start >= (long)this.i_timeout;
    }

    public void write(byte[] bytes) throws Db4oIOException {
        this.write(bytes, 0, bytes.length);
    }

    public void write(final byte[] bytes, final int off, final int len) throws Db4oIOException {
        this.i_lock.run(new Closure4(){

            @Override
            public Object run() {
                BlockingByteChannel.this.checkClosed();
                BlockingByteChannel.this.makefit(len);
                System.arraycopy(bytes, off, BlockingByteChannel.this.i_cache, BlockingByteChannel.this.i_writeOffset, len);
                BlockingByteChannel.this.i_writeOffset += len;
                BlockingByteChannel.this.i_lock.awake();
                return null;
            }
        });
    }

    public void write(final int i) throws Db4oIOException {
        this.i_lock.run(new Closure4(){

            @Override
            public Object run() {
                BlockingByteChannel.this.checkClosed();
                BlockingByteChannel.this.makefit(1);
                BlockingByteChannel.this.i_cache[BlockingByteChannel.this.i_writeOffset++] = (byte)i;
                BlockingByteChannel.this.i_lock.awake();
                return null;
            }
        });
    }

    public void checkClosed() {
        if (this.i_closed) {
            throw new Db4oIOException();
        }
    }
}

