/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.index.xml;

import freenet.client.events.ClientEvent;
import freenet.client.events.ExpectedFileSizeEvent;
import freenet.client.events.ExpectedHashesEvent;
import freenet.client.events.ExpectedMIMEEvent;
import freenet.client.events.SendingToNetworkEvent;
import freenet.client.events.SplitfileCompatibilityModeEvent;
import freenet.client.events.SplitfileProgressEvent;
import freenet.support.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import plugins.Library.index.TermEntry;
import plugins.Library.index.TermPageEntry;
import plugins.Library.util.exec.AbstractExecution;
import plugins.Library.util.exec.ChainedProgress;
import plugins.Library.util.exec.Execution;
import plugins.Library.util.exec.Progress;
import plugins.Library.util.exec.ProgressParts;
import plugins.Library.util.exec.TaskAbortException;

public class FindRequest
extends AbstractExecution<Set<TermEntry>>
implements Comparable<Execution>,
ChainedProgress,
Execution<Set<TermEntry>> {
    private Set<TermPageEntry> resultnotfinished;
    private SubProgress currentProgress = new SubProgress(Stages.UNSTARTED);

    public FindRequest(String subject) {
        super(subject);
    }

    @Override
    public void setError(TaskAbortException e) {
        super.setError(e);
    }

    @Override
    public void setResult(Set<TermPageEntry> result) {
        this.resultnotfinished = result;
    }

    public void setFinished() {
        super.setResult(Collections.unmodifiableSet(this.resultnotfinished));
        this.resultnotfinished = null;
        this.setStage(Stages.DONE);
    }

    @Override
    public int compareTo(Execution right) {
        return this.subject.compareTo(right.getSubject());
    }

    @Override
    public ProgressParts getParts() throws TaskAbortException {
        int end;
        int stage;
        return ProgressParts.normalise(stage, (stage = this.currentProgress.stage.ordinal()) < (end = Stages.DONE.ordinal()) - 1 ? stage + 1 : end, end, -1);
    }

    @Override
    public Progress getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    public String getStatus() {
        return this.getCurrentProgress().getSubject();
    }

    @Override
    public boolean isDone() throws TaskAbortException {
        super.isDone();
        return this.currentProgress.stage == Stages.DONE;
    }

    Set<TermPageEntry> getUnfinishedResult() {
        return this.resultnotfinished;
    }

    void setStage(Stages stage) {
        this.currentProgress = new SubProgress(stage);
    }

    static void updateWithEvent(ArrayList<FindRequest> receivingEvent, ClientEvent ce) {
        for (FindRequest findRequest : receivingEvent) {
            findRequest.partsFromEvent(ce);
        }
    }

    private void partsFromEvent(ClientEvent ce) {
        this.currentProgress.partsFromEvent(ce);
    }

    public String toString() {
        try {
            return "FindRequest: " + this.getStatus() + " " + this.getParts() + " - " + this.currentProgress;
        }
        catch (TaskAbortException ex) {
            return "Error forming FindRequest string";
        }
    }

    class SubProgress
    implements Progress {
        private ProgressParts parts = ProgressParts.normalise(0, 1, 2, -1);
        boolean done = false;
        public final Stages stage;

        public SubProgress(Stages stage) {
            this.stage = stage;
            this.parts = ProgressParts.normalise(0, 0, 1, -2);
        }

        @Override
        public String getSubject() {
            return this.stage.description;
        }

        @Override
        public String getStatus() {
            return this.stage.description;
        }

        @Override
        public ProgressParts getParts() throws TaskAbortException {
            return this.parts;
        }

        @Override
        public boolean isStarted() {
            return true;
        }

        @Override
        public boolean isDone() throws TaskAbortException {
            return this.parts.isDone();
        }

        @Override
        public void join() throws InterruptedException, TaskAbortException {
            throw new UnsupportedOperationException("Not supported.");
        }

        public void partsFromEvent(ClientEvent ce) {
            if (ce instanceof SplitfileProgressEvent) {
                SplitfileProgressEvent spe = (SplitfileProgressEvent)ce;
                this.parts = ProgressParts.normalise(spe.succeedBlocks, spe.minSuccessfulBlocks, spe.minSuccessfulBlocks, spe.finalizedTotal ? -1 : -2);
            } else {
                if (ce instanceof SendingToNetworkEvent || ce instanceof ExpectedMIMEEvent || ce instanceof ExpectedFileSizeEvent || ce instanceof SplitfileCompatibilityModeEvent || ce instanceof ExpectedHashesEvent) {
                    return;
                }
                this.parts = ProgressParts.normalise(0, 0);
                Logger.error((Object)this, (String)("Fetch progress will not update due to unrecognised ClientEvent : " + ce.getClass().getName()));
            }
        }

        public String toString() {
            return this.parts.toString();
        }
    }

    public static enum Stages {
        UNSTARTED("Not Started"),
        FETCHROOT("Fetching Index Root"),
        FETCHSUBINDEX("Fetching Subindex"),
        PARSE("Parsing Subindex"),
        DONE("Done");

        public final String description;

        private Stages(String desc) {
            this.description = desc;
        }
    }
}

