/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util;

final class SkeletonValue<V>
implements Cloneable {
    private Object meta;
    private V data;
    private boolean isLoaded;

    public SkeletonValue(V d, Object o, boolean loaded) {
        if (loaded) {
            assert (o == null);
            this.isLoaded = true;
            this.data = d;
        } else {
            assert (d == null);
            assert (o != null);
            this.isLoaded = false;
            this.meta = o;
        }
    }

    public final V data() {
        return this.data;
    }

    public final Object meta() {
        return this.meta;
    }

    public final boolean isLoaded() {
        return this.isLoaded;
    }

    public V set(V v) {
        V old = this.data;
        this.data = v;
        this.isLoaded = true;
        return old;
    }

    public Object setGhost(Object m) {
        if (m == null) {
            throw new NullPointerException();
        }
        Object old = this.meta;
        this.meta = m;
        this.data = null;
        this.isLoaded = false;
        return old;
    }

    public String toString() {
        return "(" + this.data + ", " + this.meta + ", " + this.isLoaded + ")";
    }

    public SkeletonValue<V> clone() {
        try {
            return (SkeletonValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

