/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util.event;

import java.util.Iterator;
import plugins.Library.util.event.Sweeper;

public abstract class AbstractSweeper<T>
implements Sweeper<T> {
    protected Sweeper.State state;
    public final boolean once;

    protected AbstractSweeper(boolean autostart, boolean onceonly) {
        this.state = autostart ? Sweeper.State.OPEN : Sweeper.State.NEW;
        this.once = onceonly;
    }

    protected abstract boolean add(T var1);

    protected abstract boolean remove(T var1);

    protected void releaseFrom(Iterator<T> it) {
        if (this.state == Sweeper.State.NEW) {
            throw new IllegalStateException("Sweeper: not yet opened");
        }
        if (this.state == Sweeper.State.CLEARED) {
            throw new IllegalStateException("Sweeper: already cleared");
        }
        it.remove();
        if (this.state == Sweeper.State.CLOSED && !it.hasNext()) {
            this.state = Sweeper.State.CLEARED;
        }
    }

    @Override
    public void open() {
        if (this.state != Sweeper.State.NEW && (this.once || this.state != Sweeper.State.CLOSED)) {
            throw new IllegalStateException("Sweeper: already opened or cleared");
        }
        this.state = Sweeper.State.OPEN;
    }

    @Override
    public boolean acquire(T object) {
        if (this.state != Sweeper.State.OPEN) {
            throw new IllegalStateException("Sweeper: not open");
        }
        return this.add(object);
    }

    @Override
    public boolean release(T object) {
        if (this.state == Sweeper.State.NEW) {
            throw new IllegalStateException("Sweeper: not yet opened");
        }
        if (this.state == Sweeper.State.CLEARED) {
            throw new IllegalStateException("Sweeper: already cleared");
        }
        boolean b = this.remove(object);
        if (this.state == Sweeper.State.CLOSED && this.size() == 0) {
            this.state = Sweeper.State.CLEARED;
        }
        return b;
    }

    @Override
    public void close() {
        if (this.state != Sweeper.State.OPEN) {
            throw new IllegalStateException("Sweeper: not open");
        }
        this.state = Sweeper.State.CLOSED;
        if (this.size() == 0) {
            this.state = Sweeper.State.CLEARED;
        }
    }

    @Override
    public Sweeper.State getState() {
        return this.state;
    }

    @Override
    public boolean isCleared() {
        return this.state == Sweeper.State.CLEARED;
    }
}

