/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.ClientGet;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.support.SimpleFieldSet;
import java.io.File;

public class PersistentGet
extends FCPMessage {
    static final String name = "PersistentGet";
    final String identifier;
    final FreenetURI uri;
    final int verbosity;
    final short priorityClass;
    final ClientGet.ReturnType returnType;
    final ClientRequest.Persistence persistence;
    final File targetFile;
    final String clientToken;
    final boolean global;
    final boolean started;
    final int maxRetries;
    final boolean binaryBlob;
    final long maxSize;
    final boolean realTime;

    public PersistentGet(String identifier, FreenetURI uri, int verbosity, short priorityClass, ClientGet.ReturnType returnType, ClientRequest.Persistence persistence, File targetFile, String clientToken, boolean global, boolean started, int maxRetries, boolean binaryBlob, long maxSize, boolean realTime) {
        this.identifier = identifier;
        this.uri = uri;
        if (uri == null) {
            throw new NullPointerException();
        }
        this.verbosity = verbosity;
        this.priorityClass = priorityClass;
        this.returnType = returnType;
        this.persistence = persistence;
        this.targetFile = targetFile;
        this.clientToken = clientToken;
        this.global = global;
        this.started = started;
        this.maxRetries = maxRetries;
        this.binaryBlob = binaryBlob;
        this.maxSize = maxSize;
        this.realTime = realTime;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        fs.putSingle("URI", this.uri.toString(false, false));
        fs.put("Verbosity", this.verbosity);
        fs.putSingle("ReturnType", this.returnType.toString().toLowerCase());
        fs.putSingle("Persistence", this.persistence.toString().toLowerCase());
        if (this.returnType == ClientGet.ReturnType.DISK) {
            fs.putSingle("Filename", this.targetFile.getAbsolutePath());
        }
        fs.put("PriorityClass", this.priorityClass);
        if (this.clientToken != null) {
            fs.putSingle("ClientToken", this.clientToken);
        }
        fs.put("Global", this.global);
        fs.put("Started", this.started);
        fs.put("MaxRetries", this.maxRetries);
        fs.put("BinaryBlob", this.binaryBlob);
        fs.put("MaxSize", this.maxSize);
        fs.put("RealTime", this.realTime);
        return fs;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "PersistentGet goes from server to client not the other way around", this.identifier, this.global);
    }
}

