/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.ChecksumChecker;
import freenet.crypt.ChecksumFailedException;
import freenet.crypt.ChecksumOutputStream;
import freenet.support.Fields;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.CRC32;

public class CRCChecksumChecker
extends ChecksumChecker {
    @Override
    public int checksumLength() {
        return 4;
    }

    @Override
    public OutputStream checksumWriter(OutputStream os, int prefix) {
        return new ChecksumOutputStream(os, new CRC32(), true, prefix);
    }

    @Override
    public boolean checkChecksum(byte[] data, int offset, int length, byte[] checksum) {
        if (checksum.length != 4) {
            throw new IllegalArgumentException();
        }
        CRC32 crc = new CRC32();
        crc.update(data, offset, length);
        int computed = (int)crc.getValue();
        int stored = Fields.bytesToInt(checksum);
        return computed == stored;
    }

    @Override
    public byte[] appendChecksum(byte[] data) {
        byte[] output = new byte[data.length + 4];
        System.arraycopy(data, 0, output, 0, data.length);
        CRC32 crc = new CRC32();
        crc.update(data, 0, data.length);
        byte[] checksum = Fields.intToBytes((int)crc.getValue());
        System.arraycopy(checksum, 0, output, data.length, 4);
        return output;
    }

    @Override
    public byte[] generateChecksum(byte[] data, int offset, int length) {
        CRC32 crc = new CRC32();
        crc.update(data, offset, length);
        return Fields.intToBytes((int)crc.getValue());
    }

    @Override
    public int getChecksumTypeID() {
        return 1;
    }

    @Override
    public void copyAndStripChecksum(InputStream is, OutputStream destination, long length) throws IOException, ChecksumFailedException {
        CRC32 crc = new CRC32();
        long remaining = length;
        byte[] buffer = new byte[32768];
        int read = 0;
        DataInputStream source = new DataInputStream(is);
        while (remaining == -1L || remaining > 0L) {
            read = source.read(buffer, 0, remaining > 32768L || remaining == -1L ? 32768 : (int)remaining);
            if (read == -1) {
                if (length == -1L) {
                    return;
                }
                throw new EOFException("stream reached eof");
            }
            if (read == 0) {
                throw new IOException("stream returning 0 bytes");
            }
            if (read != 0) {
                crc.update(buffer, 0, read);
            }
            destination.write(buffer, 0, read);
            if (remaining <= 0L) continue;
            remaining -= (long)read;
        }
        byte[] checksum = new byte[this.checksumLength()];
        source.readFully(checksum);
        byte[] myChecksum = Fields.intToBytes((int)crc.getValue());
        if (!Arrays.equals(checksum, myChecksum)) {
            throw new ChecksumFailedException();
        }
    }

    @Override
    public void readAndChecksum(DataInput is, byte[] buf, int offset, int length) throws IOException, ChecksumFailedException {
        is.readFully(buf, offset, length);
        byte[] checksum = new byte[this.checksumLength()];
        is.readFully(checksum);
        if (!this.checkChecksum(buf, offset, length, checksum)) {
            Arrays.fill(buf, offset, offset + length, (byte)0);
            throw new ChecksumFailedException();
        }
    }
}

