/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.AnnouncementCallback;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.OpennetManager;
import freenet.node.OpennetPeerNode;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.io.NativeThread;
import java.util.HashSet;

public class AnnounceSender
implements PrioRunnable,
ByteCounter {
    private static volatile boolean logMINOR;
    static final int ACCEPTED_TIMEOUT = 10000;
    static final int ANNOUNCE_TIMEOUT = 120000;
    static final int END_TIMEOUT = 30000;
    private final PeerNode source;
    private final long uid;
    private final OpennetManager om;
    private final Node node;
    private final long xferUID;
    private final int noderefLength;
    private final int paddedLength;
    private byte[] noderefBuf;
    private short htl;
    private final double target;
    private final AnnouncementCallback cb;
    private final PeerNode onlyNode;
    private int forwardedRefs;
    private int waitingForTransfers = 0;

    public AnnounceSender(double target, short htl, long uid, PeerNode source, OpennetManager om, Node node, long xferUID, int noderefLength, int paddedLength, AnnouncementCallback cb) {
        this.source = source;
        this.uid = uid;
        this.om = om;
        this.node = node;
        this.onlyNode = null;
        this.htl = htl;
        this.xferUID = xferUID;
        this.paddedLength = paddedLength;
        this.noderefLength = noderefLength;
        this.target = target;
        this.cb = cb;
    }

    public AnnounceSender(double target, OpennetManager om, Node node, AnnouncementCallback cb, PeerNode onlyNode) {
        this.source = null;
        this.uid = node.random.nextLong();
        node.tracker.completed(this.uid);
        this.om = om;
        this.node = node;
        this.htl = node.maxHTL();
        this.target = target;
        this.cb = cb;
        this.onlyNode = onlyNode;
        this.noderefBuf = om.crypto.myCompressedFullRef();
        this.xferUID = 0L;
        this.paddedLength = 0;
        this.noderefLength = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.realRun();
            this.node.nodeStats.reportAnnounceForwarded(this.forwardedRefs, this.source);
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t + " announcing " + this.uid + " from " + this.source, t);
        }
        finally {
            if (this.source != null) {
                this.source.completedAnnounce(this.uid);
            }
            this.node.tracker.completed(this.uid);
            if (this.cb != null) {
                this.cb.completed();
            }
            this.node.nodeStats.endAnnouncement(this.uid);
        }
    }

    private void realRun() {
        boolean hasForwarded = false;
        if (this.source != null) {
            try {
                this.source.sendAsync(DMT.createFNPAccepted(this.uid), null, this);
            }
            catch (NotConnectedException e) {
                return;
            }
            if (!this.transferNoderef()) {
                return;
            }
        }
        HashSet<PeerNode> nodesRoutedTo = new HashSet<PeerNode>();
        PeerNode next = null;
        block14: while (true) {
            MessageFilter mfRejectedOverload;
            if (logMINOR) {
                Logger.minor(this, "htl=" + this.htl);
            }
            if (this.onlyNode == null) {
                this.htl = this.node.decrementHTL(hasForwarded ? next : this.source, this.htl);
            }
            if (this.htl == 0) {
                this.complete();
                return;
            }
            if (!this.node.isOpennetEnabled()) {
                this.complete();
                return;
            }
            if (this.onlyNode == null) {
                next = this.node.peers.closerPeer(this.source, nodesRoutedTo, this.target, true, this.node.isAdvancedModeEnabled(), -1, null, null, this.htl, 0L, this.source == null, false, false);
            } else {
                next = this.onlyNode;
                if (nodesRoutedTo.contains(this.onlyNode)) {
                    this.rnf(this.onlyNode);
                    return;
                }
            }
            if (next == null) {
                this.rnf(next);
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Routing request to " + next);
            }
            if (this.onlyNode == null) {
                next.reportRoutedTo(this.target, this.source == null, false, this.source, nodesRoutedTo);
            }
            nodesRoutedTo.add(next);
            long xferUID = this.sendTo(next);
            if (xferUID == -1L) continue;
            hasForwarded = true;
            Message msg = null;
            while (true) {
                block53: {
                    MessageFilter mfAccepted = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000L).setType(DMT.FNPAccepted);
                    MessageFilter mfRejectedLoop = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000L).setType(DMT.FNPRejectedLoop);
                    mfRejectedOverload = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000L).setType(DMT.FNPRejectedOverload);
                    MessageFilter mfOpennetDisabled = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000L).setType(DMT.FNPOpennetDisabled);
                    MessageFilter mf = mfAccepted.or(mfRejectedLoop.or(mfRejectedOverload.or(mfOpennetDisabled)));
                    try {
                        msg = this.node.usm.waitFor(mf, this);
                        if (!logMINOR) break block53;
                        Logger.minor(this, "first part got " + msg);
                    }
                    catch (DisconnectedException e) {
                        Logger.normal(this, "Disconnected from " + next + " while waiting for Accepted on " + this.uid);
                        break;
                    }
                }
                if (msg == null) {
                    if (logMINOR) {
                        Logger.minor(this, "Timeout waiting for Accepted");
                    }
                    msg = null;
                    break;
                }
                if (msg.getSpec() == DMT.FNPRejectedLoop) {
                    if (logMINOR) {
                        Logger.minor(this, "Rejected loop");
                    }
                    msg = null;
                    break;
                }
                if (msg.getSpec() == DMT.FNPRejectedOverload) {
                    if (logMINOR) {
                        Logger.minor(this, "Rejected: overload");
                    }
                    msg = null;
                    break;
                }
                if (msg.getSpec() == DMT.FNPOpennetDisabled) {
                    if (logMINOR) {
                        Logger.minor(this, "Opennet disabled");
                    }
                    msg = null;
                    break;
                }
                if (msg.getSpec() == DMT.FNPAccepted) break;
                Logger.error(this, "Unrecognized message: " + msg);
            }
            if (msg == null || msg.getSpec() != DMT.FNPAccepted) continue;
            if (logMINOR) {
                Logger.minor(this, "Got Accepted");
            }
            if (this.cb != null) {
                this.cb.acceptedSomewhere();
            }
            try {
                this.sendRest(next, xferUID);
            }
            catch (NotConnectedException e1) {
                if (!logMINOR) continue;
                Logger.minor(this, "Not connected while sending noderef on " + next);
                continue;
            }
            while (true) {
                MessageFilter mfAnnounceCompleted = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000L).setType(DMT.FNPOpennetAnnounceCompleted);
                MessageFilter mfRouteNotFound = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000L).setType(DMT.FNPRouteNotFound);
                mfRejectedOverload = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000L).setType(DMT.FNPRejectedOverload);
                MessageFilter mfAnnounceReply = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000L).setType(DMT.FNPOpennetAnnounceReply);
                MessageFilter mfOpennetDisabled = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000L).setType(DMT.FNPOpennetDisabled);
                MessageFilter mfNotWanted = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000L).setType(DMT.FNPOpennetAnnounceNodeNotWanted);
                MessageFilter mfOpennetNoderefRejected = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000L).setType(DMT.FNPOpennetNoderefRejected);
                MessageFilter mf = mfAnnounceCompleted.or(mfRouteNotFound.or(mfRejectedOverload.or(mfAnnounceReply.or(mfOpennetDisabled.or(mfNotWanted.or(mfOpennetNoderefRejected))))));
                try {
                    msg = this.node.usm.waitFor(mf, this);
                }
                catch (DisconnectedException e) {
                    Logger.normal(this, "Disconnected from " + next + " while waiting for announcement");
                    continue block14;
                }
                if (logMINOR) {
                    Logger.minor(this, "second part got " + msg);
                }
                if (msg == null) {
                    this.timedOut(next);
                    return;
                }
                if (msg.getSpec() == DMT.FNPOpennetNoderefRejected) {
                    int reason = msg.getInt("rejectCode");
                    Logger.normal(this, "Announce rejected by " + next + " : " + DMT.getOpennetRejectedCode(reason));
                    msg = null;
                    continue block14;
                }
                if (msg.getSpec() == DMT.FNPOpennetAnnounceCompleted) {
                    this.complete();
                    mfAnnounceReply.setTimeout(30000L).setTimeoutRelativeToCreation(true);
                    mfNotWanted.setTimeout(30000L).setTimeoutRelativeToCreation(true);
                    mfAnnounceReply.clearOr();
                    mfNotWanted.clearOr();
                    mf = mfAnnounceReply.or(mfNotWanted);
                    while (true) {
                        try {
                            msg = this.node.usm.waitFor(mf, this);
                        }
                        catch (DisconnectedException e) {
                            return;
                        }
                        if (msg == null) {
                            return;
                        }
                        if (msg.getSpec() == DMT.FNPOpennetAnnounceReply) {
                            this.validateForwardReply(msg, next);
                            continue;
                        }
                        if (msg.getSpec() != DMT.FNPOpennetAnnounceNodeNotWanted) continue;
                        if (this.cb != null) {
                            this.cb.nodeNotWanted();
                        }
                        if (this.source == null) continue;
                        try {
                            this.sendNotWanted();
                        }
                        catch (NotConnectedException e) {
                            Logger.warning(this, "Lost connection to source (announce completed)");
                            return;
                        }
                    }
                }
                if (msg.getSpec() == DMT.FNPRouteNotFound) {
                    short newHtl = msg.getShort("hopsToLive");
                    if (newHtl < 0) {
                        newHtl = 0;
                    }
                    if (newHtl >= this.htl) continue block14;
                    this.htl = newHtl;
                    continue block14;
                }
                if (msg.getSpec() == DMT.FNPRejectedOverload) continue block14;
                if (msg.getSpec() == DMT.FNPOpennetDisabled) {
                    Logger.minor(this, "Opennet disabled");
                    msg = null;
                    continue block14;
                }
                if (msg.getSpec() == DMT.FNPOpennetAnnounceReply) {
                    this.validateForwardReply(msg, next);
                    continue;
                }
                if (msg.getSpec() == DMT.FNPOpennetAnnounceNodeNotWanted) {
                    if (this.cb != null) {
                        this.cb.nodeNotWanted();
                    }
                    if (this.source == null) continue;
                    try {
                        this.sendNotWanted();
                    }
                    catch (NotConnectedException e) {
                        Logger.warning(this, "Lost connection to source (announce not wanted)");
                        return;
                    }
                }
                Logger.error(this, "Unexpected message: " + msg);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateForwardReply(Message msg, final PeerNode next) {
        final long xferUID = msg.getLong("transferUID");
        final int noderefLength = msg.getInt("noderefLength");
        final int paddedLength = msg.getInt("paddedLength");
        AnnounceSender announceSender = this;
        synchronized (announceSender) {
            ++this.waitingForTransfers;
        }
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    byte[] noderefBuf = OpennetManager.innerWaitForOpennetNoderef(xferUID, paddedLength, noderefLength, next, false, AnnounceSender.this.uid, true, AnnounceSender.this, AnnounceSender.this.node);
                    if (noderefBuf == null) {
                        return;
                    }
                    SimpleFieldSet fs = OpennetManager.validateNoderef(noderefBuf, 0, noderefLength, next, false);
                    if (fs == null) {
                        if (AnnounceSender.this.cb == null) return;
                        AnnounceSender.this.cb.bogusNoderef("invalid noderef");
                        return;
                    }
                    if (AnnounceSender.this.source != null) {
                        try {
                            AnnounceSender.this.forwardedRefs++;
                            AnnounceSender.this.om.sendAnnouncementReply(AnnounceSender.this.uid, AnnounceSender.this.source, noderefBuf, AnnounceSender.this);
                            if (AnnounceSender.this.cb == null) return;
                            AnnounceSender.this.cb.relayedNoderef();
                            return;
                        }
                        catch (NotConnectedException e) {
                            AnnounceSender announceSender = AnnounceSender.this;
                            synchronized (announceSender) {
                                AnnounceSender.this.waitingForTransfers--;
                                AnnounceSender.this.notifyAll();
                                return;
                            }
                        }
                    }
                    try {
                        OpennetPeerNode pn = AnnounceSender.this.node.addNewOpennetNode(fs, OpennetManager.ConnectionType.ANNOUNCE);
                        if (AnnounceSender.this.cb == null) return;
                        if (pn != null) {
                            AnnounceSender.this.cb.addedNode(pn);
                            return;
                        }
                        AnnounceSender.this.cb.nodeNotAdded();
                        return;
                    }
                    catch (FSParseException e) {
                        Logger.normal(this, "Failed to parse reply: " + e, (Throwable)e);
                        if (AnnounceSender.this.cb == null) return;
                        AnnounceSender.this.cb.bogusNoderef("parse failed: " + e);
                        return;
                    }
                    catch (PeerParseException e) {
                        Logger.normal(this, "Failed to parse reply: " + e, (Throwable)e);
                        if (AnnounceSender.this.cb == null) return;
                        AnnounceSender.this.cb.bogusNoderef("parse failed: " + e);
                        return;
                    }
                    catch (ReferenceSignatureVerificationException e) {
                        Logger.normal(this, "Failed to parse reply: " + e, (Throwable)e);
                        if (AnnounceSender.this.cb == null) return;
                        AnnounceSender.this.cb.bogusNoderef("parse failed: " + e);
                    }
                    return;
                }
                finally {
                    AnnounceSender announceSender = AnnounceSender.this;
                    synchronized (announceSender) {
                        AnnounceSender.this.waitingForTransfers--;
                        AnnounceSender.this.notifyAll();
                    }
                }
            }
        };
        try {
            this.node.executor.execute(r);
        }
        catch (Throwable t) {
            AnnounceSender announceSender2 = this;
            synchronized (announceSender2) {
                --this.waitingForTransfers;
            }
        }
    }

    private long sendTo(PeerNode next) {
        try {
            return this.om.startSendAnnouncementRequest(this.uid, next, this.noderefBuf, this, this.target, this.htl);
        }
        catch (NotConnectedException e) {
            if (logMINOR) {
                Logger.minor(this, "Disconnected");
            }
            return -1L;
        }
    }

    private void sendRest(PeerNode next, long xferUID) throws NotConnectedException {
        this.om.finishSentAnnouncementRequest(next, this.noderefBuf, this, xferUID);
    }

    private void timedOut(PeerNode next) {
        Message msg = DMT.createFNPRejectedOverload(this.uid, true, false, false);
        if (this.source != null) {
            try {
                this.source.sendAsync(msg, null, this);
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
        }
        if (this.cb != null) {
            this.cb.nodeFailed(next, "timed out");
        }
    }

    private synchronized void waitForRunningTransfers() {
        while (this.waitingForTransfers > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void rnf(PeerNode next) {
        this.waitForRunningTransfers();
        Message msg = DMT.createFNPRouteNotFound(this.uid, this.htl);
        if (this.source != null) {
            try {
                this.source.sendAsync(msg, null, this);
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
        }
        if (this.cb != null) {
            if (next != null) {
                this.cb.nodeFailed(next, "route not found");
            } else {
                this.cb.noMoreNodes();
            }
        }
    }

    private void complete() {
        this.waitForRunningTransfers();
        Message msg = DMT.createFNPOpennetAnnounceCompleted(this.uid);
        if (this.source != null) {
            try {
                this.source.sendAsync(msg, null, this);
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
        }
    }

    private boolean transferNoderef() {
        this.noderefBuf = OpennetManager.innerWaitForOpennetNoderef(this.xferUID, this.paddedLength, this.noderefLength, this.source, false, this.uid, true, this, this.node);
        if (this.noderefBuf == null) {
            return false;
        }
        SimpleFieldSet fs = OpennetManager.validateNoderef(this.noderefBuf, 0, this.noderefLength, this.source, false);
        if (fs == null) {
            OpennetManager.rejectRef(this.uid, this.source, 4, this);
            return false;
        }
        try {
            if (this.om.addNewOpennetNode(fs, OpennetManager.ConnectionType.ANNOUNCE, true) != null) {
                this.sendOurRef(this.source, this.om.crypto.myCompressedFullRef());
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Don't need the node");
                }
                this.sendNotWanted();
            }
        }
        catch (FSParseException e) {
            Logger.warning(this, "Rejecting noderef: " + e, (Throwable)e);
            OpennetManager.rejectRef(this.uid, this.source, 4, this);
            return false;
        }
        catch (PeerParseException e) {
            Logger.warning(this, "Rejecting noderef: " + e, (Throwable)e);
            OpennetManager.rejectRef(this.uid, this.source, 4, this);
            return false;
        }
        catch (ReferenceSignatureVerificationException e) {
            Logger.warning(this, "Rejecting noderef: " + e, (Throwable)e);
            OpennetManager.rejectRef(this.uid, this.source, 4, this);
            return false;
        }
        catch (NotConnectedException e) {
            Logger.normal(this, "Could not receive noderef, disconnected");
            return false;
        }
        return true;
    }

    private void sendNotWanted() throws NotConnectedException {
        Message msg = DMT.createFNPOpennetAnnounceNodeNotWanted(this.uid);
        this.source.sendAsync(msg, null, this);
    }

    private void sendOurRef(PeerNode next, byte[] ref) throws NotConnectedException {
        this.om.sendAnnouncementReply(this.uid, next, ref, this);
    }

    @Override
    public void sentBytes(int x) {
        this.node.nodeStats.announceByteCounter.sentBytes(x);
    }

    @Override
    public void receivedBytes(int x) {
        this.node.nodeStats.announceByteCounter.receivedBytes(x);
    }

    @Override
    public void sentPayload(int x) {
        this.node.nodeStats.announceByteCounter.sentPayload(x);
    }

    @Override
    public int getPriority() {
        return NativeThread.HIGH_PRIORITY;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

