/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.updater;

import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.HighLevelSimpleClient;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.PersistenceDisabledException;
import freenet.config.Config;
import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.SubConfig;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.Message;
import freenet.io.comm.NotConnectedException;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.node.NodeFile;
import freenet.node.NodeStarter;
import freenet.node.OpennetManager;
import freenet.node.PeerNode;
import freenet.node.ProgramDirectory;
import freenet.node.RequestClient;
import freenet.node.Version;
import freenet.node.updater.LegacyJarFetcher;
import freenet.node.updater.MainJarDependenciesChecker;
import freenet.node.updater.MainJarUpdater;
import freenet.node.updater.NodeUpdater;
import freenet.node.updater.PluginJarUpdater;
import freenet.node.updater.RevocationChecker;
import freenet.node.updater.UpdateDeployContext;
import freenet.node.updater.UpdateOverMandatoryManager;
import freenet.node.updater.UpdaterParserException;
import freenet.node.useralerts.RevocationKeyFoundUserAlert;
import freenet.node.useralerts.SimpleUserAlert;
import freenet.node.useralerts.UpdatedVersionAvailableUserAlert;
import freenet.pluginmanager.OfficialPlugins;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.support.HTMLNode;
import freenet.support.JVMVersion;
import freenet.support.Logger;
import freenet.support.api.BooleanCallback;
import freenet.support.api.Bucket;
import freenet.support.api.StringCallback;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class NodeUpdateManager {
    public static final int TRANSITION_VERSION = 1472;
    public static final String UPDATE_URI = "USK@O~UmMwTeDcyDIW-NsobFBoEicdQcogw7yrLO2H-sJ5Y,JVU4L7m9mNppkd21UNOCzRHKuiTucd6Ldw8vylBOe5o,AQACAAE/jar/" + Version.buildNumber();
    public static final String LEGACY_UPDATE_URI = "freenet:SSK@sabn9HY9MKLbFPp851AO98uKtsCtYHM9rqB~A5cCGW4,3yps2z06rLnwf50QU4HvsILakRBYd4vBlPtLv0elUts,AQACAAE/jar-1472";
    public static final String REVOCATION_URI = "SSK@tHlY8BK2KFB7JiO2bgeAw~e4sWU43YdJ6kmn73gjrIw,DnQzl0BYed15V8WQn~eRJxxIA-yADuI8XW7mnzEbut8,AQACAAE/revoked";
    public static final long MAX_REVOCATION_KEY_LENGTH = 32768L;
    public static final long MAX_REVOCATION_KEY_TEMP_LENGTH = 65536L;
    public static final long MAX_REVOCATION_KEY_BLOB_LENGTH = 131072L;
    public static final long MAX_MAIN_JAR_LENGTH = 0x1000000L;
    public static final FreenetURI transitionMainJarURI;
    public static final FreenetURI transitionMainJarURIAsUSK;
    public static final String transitionMainJarFilename = "legacy-freenet-jar-1472.fblob";
    public final File transitionMainJarFile;
    private FreenetURI updateURI;
    private FreenetURI revocationURI;
    private final LegacyJarFetcher transitionMainJarFetcher;
    private MainJarUpdater mainUpdater;
    private Map<String, PluginJarUpdater> pluginUpdaters;
    private boolean autoDeployPluginsOnRestart;
    private final boolean wasEnabledOnStartup;
    private volatile boolean isAutoUpdateAllowed;
    private volatile boolean armed;
    private boolean isDeployingUpdate;
    private final Object broadcastUOMAnnouncesSync = new Object();
    private boolean broadcastUOMAnnouncesOld = false;
    private boolean broadcastUOMAnnouncesNew = false;
    public final Node node;
    final RevocationChecker revocationChecker;
    private String revocationMessage;
    private volatile boolean hasBeenBlown;
    private volatile boolean peersSayBlown;
    private boolean updateSeednodes;
    private boolean updateInstallers;
    private boolean updateIPToCountry = true;
    private volatile boolean hasNewMainJar;
    private long startedFetchingNextMainJar;
    private long gotJarTime;
    private RevocationKeyFoundUserAlert revocationAlert;
    private final UpdatedVersionAvailableUserAlert alert;
    public final UpdateOverMandatoryManager uom;
    private static volatile boolean logMINOR;
    private boolean disabledThisSession;
    private MainJarDependenciesChecker.MainJarDependencies latestMainJarDependencies;
    private int dependenciesValidForBuild;
    private int fetchedMainJarVersion;
    private Bucket fetchedMainJarData;
    private File currentVersionBlobFile;
    private int maybeNextMainJarVersion;
    private Bucket maybeNextMainJarData;
    private static final Object deployLock;
    static final String TEMP_BLOB_SUFFIX = ".updater.fblob.tmp";
    static final String TEMP_FILE_SUFFIX = ".updater.tmp";
    private static final long WAIT_FOR_SECOND_FETCH_TO_COMPLETE;
    private static final long RECENT_REVOCATION_INTERVAL;
    private static final long REVOCATION_FETCH_TIMEOUT;
    private boolean disabledNotBlown;
    final ByteCounter ctr = new ByteCounter(){

        @Override
        public void receivedBytes(int x) {
        }

        @Override
        public void sentBytes(int x) {
            NodeUpdateManager.this.node.nodeStats.reportUOMBytesSent(x);
        }

        @Override
        public void sentPayload(int x) {
        }
    };

    public NodeUpdateManager(Node node, Config config) throws InvalidConfigValueException {
        this.node = node;
        this.hasBeenBlown = false;
        this.alert = new UpdatedVersionAvailableUserAlert(this);
        this.alert.isValid(false);
        SubConfig updaterConfig = config.createSubConfig("node.updater");
        updaterConfig.register("enabled", true, 1, false, false, "NodeUpdateManager.enabled", "NodeUpdateManager.enabledLong", new UpdaterEnabledCallback());
        this.wasEnabledOnStartup = updaterConfig.getBoolean("enabled");
        updaterConfig.register("autoupdate", false, 2, false, true, "NodeUpdateManager.installNewVersions", "NodeUpdateManager.installNewVersionsLong", new AutoUpdateAllowedCallback());
        this.isAutoUpdateAllowed = updaterConfig.getBoolean("autoupdate");
        updaterConfig.register("URI", JVMVersion.isTooOld() ? transitionMainJarURIAsUSK.toString() : UPDATE_URI, 3, true, true, "NodeUpdateManager.updateURI", "NodeUpdateManager.updateURILong", new UpdateURICallback());
        try {
            this.updateURI = new FreenetURI(updaterConfig.getString("URI"));
        }
        catch (MalformedURLException e) {
            throw new InvalidConfigValueException(this.l10n("invalidUpdateURI", "error", e.getLocalizedMessage()));
        }
        if (this.updateURI.equalsKeypair(transitionMainJarURI) && !JVMVersion.isTooOld()) {
            try {
                updaterConfig.set("URI", UPDATE_URI);
            }
            catch (NodeNeedRestartException e) {
                Logger.warning(this, "Unexpected failure setting update URI", (Throwable)e);
            }
        }
        this.updateURI = this.updateURI.setSuggestedEdition(Version.buildNumber());
        if (this.updateURI.hasMetaStrings()) {
            throw new InvalidConfigValueException(this.l10n("updateURIMustHaveNoMetaStrings"));
        }
        if (!this.updateURI.isUSK()) {
            throw new InvalidConfigValueException(this.l10n("updateURIMustBeAUSK"));
        }
        updaterConfig.register("revocationURI", REVOCATION_URI, 4, true, false, "NodeUpdateManager.revocationURI", "NodeUpdateManager.revocationURILong", new UpdateRevocationURICallback());
        try {
            this.revocationURI = new FreenetURI(updaterConfig.getString("revocationURI"));
        }
        catch (MalformedURLException e) {
            throw new InvalidConfigValueException(this.l10n("invalidRevocationURI", "error", e.getLocalizedMessage()));
        }
        LegacyJarFetcher.LegacyFetchCallback legacyFetcherCallback = new LegacyJarFetcher.LegacyFetchCallback(){

            @Override
            public void onSuccess(LegacyJarFetcher fetcher) {
                if (NodeUpdateManager.this.transitionMainJarFetcher.fetched()) {
                    System.out.println("Got legacy jar, announcing...");
                    NodeUpdateManager.this.broadcastUOMAnnouncesOld();
                }
            }

            @Override
            public void onFailure(FetchException e, LegacyJarFetcher fetcher) {
                Logger.error(this, "Failed to fetch " + fetcher.saveTo + " : UPDATE OVER MANDATORY WILL NOT WORK WITH OLDER NODES THAN " + 1472 + " : " + e, (Throwable)e);
                System.err.println("Failed to fetch " + fetcher.saveTo + " : UPDATE OVER MANDATORY WILL NOT WORK WITH OLDER NODES THAN " + 1472 + " : " + e);
            }
        };
        this.transitionMainJarFile = new File(node.clientCore.getPersistentTempDir(), transitionMainJarFilename);
        this.transitionMainJarFetcher = new LegacyJarFetcher(transitionMainJarURI, this.transitionMainJarFile, node.clientCore, legacyFetcherCallback);
        updaterConfig.register("updateSeednodes", this.wasEnabledOnStartup, 6, true, true, "NodeUpdateManager.updateSeednodes", "NodeUpdateManager.updateSeednodesLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return NodeUpdateManager.this.updateSeednodes;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (NodeUpdateManager.this.updateSeednodes == val) {
                    return;
                }
                NodeUpdateManager.this.updateSeednodes = val;
                if (val.booleanValue()) {
                    throw new NodeNeedRestartException("Must restart to fetch the seednodes");
                }
                throw new NodeNeedRestartException("Must restart to stop the seednodes fetch if it is still running");
            }
        });
        this.updateSeednodes = updaterConfig.getBoolean("updateSeednodes");
        updaterConfig.register("updateInstallers", this.wasEnabledOnStartup, 6, true, true, "NodeUpdateManager.updateInstallers", "NodeUpdateManager.updateInstallersLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return NodeUpdateManager.this.updateInstallers;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (NodeUpdateManager.this.updateInstallers == val) {
                    return;
                }
                NodeUpdateManager.this.updateInstallers = val;
                if (val.booleanValue()) {
                    throw new NodeNeedRestartException("Must restart to fetch the installers");
                }
                throw new NodeNeedRestartException("Must restart to stop the installers fetches if they are still running");
            }
        });
        this.updateInstallers = updaterConfig.getBoolean("updateInstallers");
        updaterConfig.finishedInitialization();
        this.revocationChecker = new RevocationChecker(this, new File(node.clientCore.getPersistentTempDir(), "revocation-key.fblob"));
        this.uom = new UpdateOverMandatoryManager(this);
        this.uom.removeOldTempFiles();
    }

    public File getInstallerWindows() {
        File f = NodeFile.InstallerWindows.getFile(this.node);
        if (!f.exists() || !f.canRead() || f.length() <= 0L) {
            return null;
        }
        return f;
    }

    public File getInstallerNonWindows() {
        File f = NodeFile.InstallerNonWindows.getFile(this.node);
        if (!f.exists() || !f.canRead() || f.length() <= 0L) {
            return null;
        }
        return f;
    }

    public FreenetURI getSeednodesURI() {
        return this.updateURI.sskForUSK().setDocName("seednodes-" + Version.buildNumber());
    }

    public FreenetURI getInstallerNonWindowsURI() {
        return this.updateURI.sskForUSK().setDocName("installer-" + Version.buildNumber());
    }

    public FreenetURI getInstallerWindowsURI() {
        return this.updateURI.sskForUSK().setDocName("wininstaller-" + Version.buildNumber());
    }

    public FreenetURI getIPv4ToCountryURI() {
        return this.updateURI.sskForUSK().setDocName("iptocountryv4-" + Version.buildNumber());
    }

    public void start() throws InvalidConfigValueException {
        this.node.clientCore.alerts.register(this.alert);
        this.enable(this.wasEnabledOnStartup);
        if (this.updateSeednodes) {
            SimplePuller seedrefsGetter = new SimplePuller(this.getSeednodesURI(), NodeFile.Seednodes);
            seedrefsGetter.start((short)2, 0x100000L);
        }
        if (this.updateInstallers) {
            SimplePuller installerGetter = new SimplePuller(this.getInstallerNonWindowsURI(), NodeFile.InstallerNonWindows);
            SimplePuller wininstallerGetter = new SimplePuller(this.getInstallerWindowsURI(), NodeFile.InstallerWindows);
            installerGetter.start((short)3, 0x2000000L);
            wininstallerGetter.start((short)3, 0x2000000L);
        }
        if (this.updateIPToCountry) {
            SimplePuller ip4Getter = new SimplePuller(this.getIPv4ToCountryURI(), NodeFile.IPv4ToCountry);
            ip4Getter.start((short)3, 0x800000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void broadcastUOMAnnouncesOld() {
        Message msg;
        boolean mainJarAvailable;
        boolean bl = mainJarAvailable = this.transitionMainJarFetcher == null ? false : this.transitionMainJarFetcher.fetched();
        if (!mainJarAvailable) {
            return;
        }
        Object object = this.broadcastUOMAnnouncesSync;
        synchronized (object) {
            if (this.broadcastUOMAnnouncesOld && !this.hasBeenBlown) {
                return;
            }
            this.broadcastUOMAnnouncesOld = true;
            msg = this.getOldUOMAnnouncement();
        }
        this.node.peers.localBroadcast(msg, true, true, this.ctr, 0, 1471);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void broadcastUOMAnnouncesNew() {
        Message msg;
        long size;
        if (logMINOR) {
            Logger.minor(this, "Broadcast UOM announcements (new)");
        }
        if ((size = this.canAnnounceUOMNew()) <= 0L && !this.hasBeenBlown) {
            return;
        }
        Object object = this.broadcastUOMAnnouncesSync;
        synchronized (object) {
            if (this.broadcastUOMAnnouncesNew && !this.hasBeenBlown) {
                return;
            }
            this.broadcastUOMAnnouncesNew = true;
            msg = this.getNewUOMAnnouncement(size);
        }
        if (logMINOR) {
            Logger.minor(this, "Broadcasting UOM announcements (new)");
        }
        this.node.peers.localBroadcast(msg, true, true, this.ctr, 1472, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long canAnnounceUOMNew() {
        Bucket data;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (this.hasNewMainJar && this.armed) {
                if (logMINOR) {
                    Logger.minor(this, "Will update soon, not offering UOM.");
                }
                return -1L;
            }
            if (this.fetchedMainJarVersion <= 0) {
                if (logMINOR) {
                    Logger.minor(this, "Not fetched yet");
                }
                return -1L;
            }
            if (this.fetchedMainJarVersion != Version.buildNumber()) {
                if (logMINOR) {
                    Logger.minor(this, "Downloaded a different version than the one we are running, not offering UOM.");
                }
                return -1L;
            }
            data = this.fetchedMainJarData;
        }
        if (logMINOR) {
            Logger.minor(this, "Got data for UOM: " + data + " size " + data.size());
        }
        return data.size();
    }

    private Message getOldUOMAnnouncement() {
        boolean mainJarAvailable = this.transitionMainJarFetcher == null ? false : this.transitionMainJarFetcher.fetched();
        return DMT.createUOMAnnouncement(transitionMainJarURIAsUSK.toString(), this.revocationURI.toString(), this.revocationChecker.hasBlown(), mainJarAvailable ? 1472L : -1L, this.revocationChecker.lastSucceededDelta(), this.revocationChecker.getRevocationDNFCounter(), this.revocationChecker.getBlobSize(), mainJarAvailable ? this.transitionMainJarFetcher.getBlobSize() : -1L, (int)this.node.nodeStats.getNodeAveragePingTime(), (int)this.node.nodeStats.getBwlimitDelayTime());
    }

    private Message getNewUOMAnnouncement(long blobSize) {
        int fetchedVersion;
        int n = fetchedVersion = blobSize <= 0L ? -1 : Version.buildNumber();
        if (blobSize <= 0L) {
            fetchedVersion = -1;
        }
        return DMT.createUOMAnnouncement(this.updateURI.toString(), this.revocationURI.toString(), this.revocationChecker.hasBlown(), fetchedVersion, this.revocationChecker.lastSucceededDelta(), this.revocationChecker.getRevocationDNFCounter(), this.revocationChecker.getBlobSize(), blobSize, (int)this.node.nodeStats.getNodeAveragePingTime(), (int)this.node.nodeStats.getBwlimitDelayTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeSendUOMAnnounce(PeerNode peer) {
        boolean sendNew;
        boolean sendOld;
        Object object = this.broadcastUOMAnnouncesSync;
        synchronized (object) {
            if (!this.broadcastUOMAnnouncesOld && !this.broadcastUOMAnnouncesNew) {
                if (logMINOR) {
                    Logger.minor(this, "Not sending UOM (any) on connect: Nothing worth announcing yet");
                }
                return;
            }
            sendOld = this.broadcastUOMAnnouncesOld;
            sendNew = this.broadcastUOMAnnouncesNew;
        }
        if (this.hasBeenBlown && !this.revocationChecker.hasBlown()) {
            if (logMINOR) {
                Logger.minor(this, "Not sending UOM (any) on connect: Local problem causing blown key");
            }
            return;
        }
        long size = this.canAnnounceUOMNew();
        try {
            if (peer.getVersionNumber() < 1472) {
                if (sendOld || this.hasBeenBlown) {
                    peer.sendAsync(this.getOldUOMAnnouncement(), null, this.ctr);
                }
            } else if (sendNew || this.hasBeenBlown) {
                peer.sendAsync(this.getNewUOMAnnouncement(size), null, this.ctr);
            }
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
    }

    public synchronized boolean isEnabled() {
        return this.mainUpdater != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enable(boolean enable) throws InvalidConfigValueException {
        MainJarUpdater main = null;
        Map<String, PluginJarUpdater> oldPluginUpdaters = null;
        this.revocationChecker.start(false);
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            boolean enabled;
            boolean bl = enabled = this.mainUpdater != null;
            if (enabled == enable) {
                return;
            }
            if (!enable) {
                this.mainUpdater.preKill();
                main = this.mainUpdater;
                this.mainUpdater = null;
                oldPluginUpdaters = this.pluginUpdaters;
                this.pluginUpdaters = null;
                this.disabledNotBlown = false;
            } else {
                this.mainUpdater = new MainJarUpdater(this, this.updateURI, Version.buildNumber(), -1, Integer.MAX_VALUE, "main-jar-");
                this.pluginUpdaters = new HashMap<String, PluginJarUpdater>();
            }
        }
        if (!enable) {
            if (main != null) {
                main.kill();
            }
            this.stopPluginUpdaters(oldPluginUpdaters);
            this.transitionMainJarFetcher.stop();
        } else {
            try {
                this.mainUpdater.cleanupDependencies();
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t + " setting up Update Over Mandatory", t);
                System.err.println("Updater error: " + t);
                t.printStackTrace();
            }
            this.mainUpdater.start();
            this.startPluginUpdaters();
            this.transitionMainJarFetcher.start();
        }
    }

    private void startPluginUpdaters() {
        for (OfficialPlugins.OfficialPluginDescription plugin : this.node.getPluginManager().getOfficialPlugins()) {
            this.startPluginUpdater(plugin.name);
        }
    }

    public void startPluginUpdater(String plugName) {
        OfficialPlugins.OfficialPluginDescription plugin;
        if (logMINOR) {
            Logger.minor(this, "Starting plugin updater for " + plugName);
        }
        if ((plugin = this.node.getPluginManager().getOfficialPlugin(plugName)) != null) {
            this.startPluginUpdater(plugin);
        } else if (logMINOR) {
            Logger.minor(this, "No such plugin " + plugName + " in startPluginUpdater()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startPluginUpdater(OfficialPlugins.OfficialPluginDescription plugin) {
        String name = plugin.name;
        long minVer = plugin.essential ? plugin.minimumVersion : plugin.recommendedVersion;
        PluginInfoWrapper info = this.node.pluginManager.getPluginInfo(name);
        if (info == null && !this.node.pluginManager.isPluginLoadedOrLoadingOrWantLoad(name)) {
            if (logMINOR) {
                Logger.minor(this, "Plugin not loaded");
            }
            return;
        }
        if (info != null) {
            minVer = Math.max(minVer, info.getPluginLongVersion());
        }
        FreenetURI uri = this.updateURI.setDocName(name).setSuggestedEdition(minVer);
        PluginJarUpdater updater = new PluginJarUpdater(this, uri, (int)minVer, -1, plugin.essential ? (int)minVer : Integer.MAX_VALUE, name + "-", name, this.node.pluginManager, this.autoDeployPluginsOnRestart);
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (this.pluginUpdaters == null) {
                if (logMINOR) {
                    Logger.minor(this, "Updating not enabled");
                }
                return;
            }
            if (this.pluginUpdaters.containsKey(name)) {
                if (logMINOR) {
                    Logger.minor(this, "Already in updaters list");
                }
                return;
            }
            this.pluginUpdaters.put(name, updater);
        }
        updater.start();
        System.out.println("Started plugin update fetcher for " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPluginUpdater(String plugName) {
        OfficialPlugins.OfficialPluginDescription plugin = this.node.getPluginManager().getOfficialPlugin(plugName);
        if (plugin == null) {
            return;
        }
        PluginJarUpdater updater = null;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (this.pluginUpdaters == null) {
                if (logMINOR) {
                    Logger.minor(this, "Updating not enabled");
                }
                return;
            }
            updater = this.pluginUpdaters.remove(plugName);
        }
        if (updater != null) {
            updater.kill();
        }
    }

    private void stopPluginUpdaters(Map<String, PluginJarUpdater> oldPluginUpdaters) {
        for (PluginJarUpdater u : oldPluginUpdaters.values()) {
            u.kill();
        }
    }

    public static NodeUpdateManager maybeCreate(Node node, Config config) throws InvalidConfigValueException {
        return new NodeUpdateManager(node, config);
    }

    public synchronized FreenetURI getURI() {
        return this.updateURI;
    }

    public synchronized FreenetURI getChangelogURI() {
        return this.updateURI.setDocName("changelog");
    }

    public synchronized FreenetURI getDeveloperChangelogURI() {
        return this.updateURI.setDocName("fullchangelog");
    }

    public synchronized void addChangelogLinks(long version, HTMLNode node) {
        String changelogUri = this.getChangelogURI().setSuggestedEdition(version).sskForUSK().toASCIIString();
        String developerDetailsUri = this.getDeveloperChangelogURI().setSuggestedEdition(version).sskForUSK().toASCIIString();
        node.addChild("a", "href", '/' + changelogUri + "?type=text/plain", NodeL10n.getBase().getString("UpdatedVersionAvailableUserAlert.changelog"));
        node.addChild("br");
        node.addChild("a", "href", '/' + developerDetailsUri + "?type=text/plain", NodeL10n.getBase().getString("UpdatedVersionAvailableUserAlert.devchangelog"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURI(FreenetURI uri) {
        MainJarUpdater updater;
        Map<String, PluginJarUpdater> oldPluginUpdaters = null;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (this.updateURI.equals(uri)) {
                return;
            }
            this.updateURI = uri;
            this.updateURI = this.updateURI.setSuggestedEdition(Version.buildNumber());
            updater = this.mainUpdater;
            oldPluginUpdaters = this.pluginUpdaters;
            this.pluginUpdaters = new HashMap<String, PluginJarUpdater>();
            if (updater == null) {
                return;
            }
        }
        updater.onChangeURI(uri);
        this.stopPluginUpdaters(oldPluginUpdaters);
        this.startPluginUpdaters();
    }

    public synchronized FreenetURI getRevocationURI() {
        return this.revocationURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRevocationURI(FreenetURI uri) {
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (this.revocationURI.equals(uri)) {
                return;
            }
            this.revocationURI = uri;
        }
        this.revocationChecker.onChangeRevocationURI();
    }

    public boolean isAutoUpdateAllowed() {
        return this.isAutoUpdateAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoUpdateAllowed(boolean val) {
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (val == this.isAutoUpdateAllowed) {
                return;
            }
            this.isAutoUpdateAllowed = val;
            if (val) {
                if (!this.isReadyToDeployUpdate(false)) {
                    return;
                }
            } else {
                return;
            }
        }
        this.deployOffThread(0L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReadyToDeployUpdate(boolean ignoreRevocation) {
        long now = System.currentTimeMillis();
        int waitForNextJar = -1;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (this.mainUpdater == null) {
                return false;
            }
            if (!this.hasNewMainJar) {
                return false;
            }
            if (this.hasBeenBlown) {
                return false;
            }
            if (this.peersSayBlown) {
                if (logMINOR) {
                    Logger.minor(this, "Not deploying, peers say blown");
                }
                return false;
            }
            if (this.startedFetchingNextMainJar > 0L && (waitForNextJar = (int)(this.startedFetchingNextMainJar + WAIT_FOR_SECOND_FETCH_TO_COMPLETE - now)) > 0 && logMINOR) {
                Logger.minor(this, "Not ready: Still fetching");
            }
            if (this.latestMainJarDependencies == null) {
                if (logMINOR) {
                    Logger.minor(this, "Dependencies not available");
                }
                return false;
            }
            if (this.fetchedMainJarVersion != this.dependenciesValidForBuild) {
                if (logMINOR) {
                    Logger.minor(this, "Not deploying because dependencies are older version " + this.dependenciesValidForBuild + " - new version " + this.fetchedMainJarVersion + " may not start");
                }
                return false;
            }
            if (waitForNextJar <= 0 && !ignoreRevocation) {
                if (now - this.revocationChecker.lastSucceeded() < RECENT_REVOCATION_INTERVAL) {
                    if (logMINOR) {
                        Logger.minor(this, "Ready to deploy (revocation checker succeeded recently)");
                    }
                    return true;
                }
                if (this.gotJarTime > 0L && now - this.gotJarTime >= REVOCATION_FETCH_TIMEOUT) {
                    if (logMINOR) {
                        Logger.minor(this, "Ready to deploy (got jar before timeout)");
                    }
                    return true;
                }
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Still here in isReadyToDeployUpdate");
        }
        this.revocationChecker.start(true);
        if (ignoreRevocation) {
            if (logMINOR) {
                Logger.minor(this, "Returning true because of ignoreRevocation");
            }
            return true;
        }
        long waitTime = Math.max(REVOCATION_FETCH_TIMEOUT, (long)waitForNextJar);
        if (logMINOR) {
            Logger.minor(this, "Will deploy in " + waitTime + "ms");
        }
        this.deployOffThread(waitTime, false);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void deployUpdate() {
        Object object;
        boolean success;
        boolean started;
        block56: {
            block55: {
                block54: {
                    block53: {
                        block52: {
                            block51: {
                                Bucket toFree;
                                block50: {
                                    started = false;
                                    success = false;
                                    object = this;
                                    // MONITORENTER : object
                                    if (!this.disabledThisSession) break block50;
                                    String msg = "Not deploying update because disabled for this session (bad java version??)";
                                    Logger.error(this, msg);
                                    System.err.println(msg);
                                    // MONITOREXIT : object
                                    if (!started) return;
                                    if (success) return;
                                    Bucket toFree2 = null;
                                    NodeUpdateManager nodeUpdateManager = this;
                                    // MONITORENTER : nodeUpdateManager
                                    this.isDeployingUpdate = false;
                                    if (this.maybeNextMainJarVersion > this.fetchedMainJarVersion) {
                                        toFree2 = this.fetchedMainJarData;
                                        this.fetchedMainJarVersion = this.maybeNextMainJarVersion;
                                        this.fetchedMainJarData = this.maybeNextMainJarData;
                                        this.maybeNextMainJarVersion = -1;
                                        this.maybeNextMainJarData = null;
                                    }
                                    // MONITOREXIT : nodeUpdateManager
                                    if (toFree2 == null) return;
                                    toFree2.free();
                                    return;
                                }
                                try {
                                    if (!this.hasBeenBlown) break block51;
                                    String msg = "Trying to update but key has been blown! Not updating, message was " + this.revocationMessage;
                                    Logger.error(this, msg);
                                    System.err.println(msg);
                                    // MONITOREXIT : object
                                    if (!started) return;
                                    if (success) return;
                                    toFree = null;
                                    NodeUpdateManager nodeUpdateManager = this;
                                }
                                catch (Throwable t) {
                                    Logger.error(this, "DEPLOYING UPDATE FAILED: " + t, t);
                                    System.err.println("UPDATE FAILED: CAUGHT " + t);
                                    System.err.println("YOUR NODE DID NOT UPDATE. THIS IS PROBABLY A BUG OR SERIOUS PROBLEM SUCH AS OUT OF MEMORY.");
                                    System.err.println("Cause of the problem: " + t);
                                    t.printStackTrace();
                                    this.failUpdate(t.getMessage());
                                    String error = this.l10n("updateFailedInternalError", "reason", t.getMessage());
                                    this.node.clientCore.alerts.register(new SimpleUserAlert(false, error, error, error, 0));
                                    return;
                                }
                                this.isDeployingUpdate = false;
                                if (this.maybeNextMainJarVersion > this.fetchedMainJarVersion) {
                                    toFree = this.fetchedMainJarData;
                                    this.fetchedMainJarVersion = this.maybeNextMainJarVersion;
                                    this.fetchedMainJarData = this.maybeNextMainJarData;
                                    this.maybeNextMainJarVersion = -1;
                                    this.maybeNextMainJarData = null;
                                }
                                // MONITOREXIT : nodeUpdateManager
                                if (toFree == null) return;
                                toFree.free();
                                return;
                            }
                            if (!this.peersSayBlown) break block52;
                            String msg = "Trying to update but at least one peer says the key has been blown! Not updating.";
                            Logger.error(this, msg);
                            System.err.println(msg);
                            // MONITOREXIT : object
                            if (!started) return;
                            if (success) return;
                            Bucket toFree = null;
                            NodeUpdateManager nodeUpdateManager = this;
                            // MONITORENTER : nodeUpdateManager
                            this.isDeployingUpdate = false;
                            if (this.maybeNextMainJarVersion > this.fetchedMainJarVersion) {
                                toFree = this.fetchedMainJarData;
                                this.fetchedMainJarVersion = this.maybeNextMainJarVersion;
                                this.fetchedMainJarData = this.maybeNextMainJarData;
                                this.maybeNextMainJarVersion = -1;
                                this.maybeNextMainJarData = null;
                            }
                            // MONITOREXIT : nodeUpdateManager
                            if (toFree == null) return;
                            toFree.free();
                            return;
                        }
                        if (this.isEnabled()) break block53;
                        if (logMINOR) {
                            Logger.minor(this, "Not enabled");
                        }
                        // MONITOREXIT : object
                        if (!started) return;
                        if (success) return;
                        Bucket toFree = null;
                        NodeUpdateManager nodeUpdateManager = this;
                        // MONITORENTER : nodeUpdateManager
                        this.isDeployingUpdate = false;
                        if (this.maybeNextMainJarVersion > this.fetchedMainJarVersion) {
                            toFree = this.fetchedMainJarData;
                            this.fetchedMainJarVersion = this.maybeNextMainJarVersion;
                            this.fetchedMainJarData = this.maybeNextMainJarData;
                            this.maybeNextMainJarVersion = -1;
                            this.maybeNextMainJarData = null;
                        }
                        // MONITOREXIT : nodeUpdateManager
                        if (toFree == null) return;
                        toFree.free();
                        return;
                    }
                    if (this.isAutoUpdateAllowed || this.armed) break block54;
                    if (logMINOR) {
                        Logger.minor(this, "Not armed");
                    }
                    // MONITOREXIT : object
                    if (!started) return;
                    if (success) return;
                    Bucket toFree = null;
                    NodeUpdateManager nodeUpdateManager = this;
                    // MONITORENTER : nodeUpdateManager
                    this.isDeployingUpdate = false;
                    if (this.maybeNextMainJarVersion > this.fetchedMainJarVersion) {
                        toFree = this.fetchedMainJarData;
                        this.fetchedMainJarVersion = this.maybeNextMainJarVersion;
                        this.fetchedMainJarData = this.maybeNextMainJarData;
                        this.maybeNextMainJarVersion = -1;
                        this.maybeNextMainJarData = null;
                    }
                    // MONITOREXIT : nodeUpdateManager
                    if (toFree == null) return;
                    toFree.free();
                    return;
                }
                if (this.isReadyToDeployUpdate(false)) break block55;
                if (logMINOR) {
                    Logger.minor(this, "Not ready to deploy update");
                }
                // MONITOREXIT : object
                if (!started) return;
                if (success) return;
                Bucket toFree = null;
                NodeUpdateManager nodeUpdateManager = this;
                // MONITORENTER : nodeUpdateManager
                this.isDeployingUpdate = false;
                if (this.maybeNextMainJarVersion > this.fetchedMainJarVersion) {
                    toFree = this.fetchedMainJarData;
                    this.fetchedMainJarVersion = this.maybeNextMainJarVersion;
                    this.fetchedMainJarData = this.maybeNextMainJarData;
                    this.maybeNextMainJarVersion = -1;
                    this.maybeNextMainJarData = null;
                }
                // MONITOREXIT : nodeUpdateManager
                if (toFree == null) return;
                toFree.free();
                return;
            }
            if (!this.isDeployingUpdate) break block56;
            if (logMINOR) {
                Logger.minor(this, "Already deploying update");
            }
            // MONITOREXIT : object
            if (!started) return;
            if (success) return;
            Bucket toFree = null;
            NodeUpdateManager nodeUpdateManager = this;
            // MONITORENTER : nodeUpdateManager
            this.isDeployingUpdate = false;
            if (this.maybeNextMainJarVersion > this.fetchedMainJarVersion) {
                toFree = this.fetchedMainJarData;
                this.fetchedMainJarVersion = this.maybeNextMainJarVersion;
                this.fetchedMainJarData = this.maybeNextMainJarData;
                this.maybeNextMainJarVersion = -1;
                this.maybeNextMainJarData = null;
            }
            // MONITOREXIT : nodeUpdateManager
            if (toFree == null) return;
            toFree.free();
            return;
        }
        try {
            started = true;
            this.isDeployingUpdate = true;
            MainJarDependenciesChecker.MainJarDependencies deps = this.latestMainJarDependencies;
            // MONITOREXIT : object
            object = NodeUpdateManager.deployLock();
            // MONITORENTER : object
            success = this.innerDeployUpdate(deps);
            if (success) {
                NodeUpdateManager.waitForever();
            }
            // MONITOREXIT : object
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (started && !success) {
                Bucket toFree = null;
                object = this;
            }
        }
    }

    static final Object deployLock() {
        return deployLock;
    }

    static void waitForever() {
        while (true) {
            System.err.println("Waiting for shutdown after deployed update...");
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private boolean innerDeployUpdate(MainJarDependenciesChecker.MainJarDependencies deps) {
        UpdateDeployContext ctx;
        System.err.println("Deploying update " + deps.build + " with " + deps.dependencies.size() + " dependencies...");
        try {
            ctx = new UpdateDeployContext(deps);
        }
        catch (UpdaterParserException e) {
            this.failUpdate("Could not determine which jars are in use: " + e.getMessage());
            return false;
        }
        if (this.writeJars(ctx, deps)) {
            this.restart(ctx);
            return true;
        }
        if (logMINOR) {
            Logger.minor(this, "Did not write jars");
        }
        return false;
    }

    private boolean writeJars(UpdateDeployContext ctx, MainJarDependenciesChecker.MainJarDependencies deps) {
        boolean tryEasyWay;
        boolean writtenNewJar = false;
        boolean bl = tryEasyWay = File.pathSeparatorChar == ':' && !deps.mustRewriteWrapperConf;
        if (this.hasNewMainJar) {
            File mainJar = ctx.getMainJar();
            File newMainJar = ctx.getNewMainJar();
            File backupJar = ctx.getBackupJar();
            try {
                if (this.writeJar(mainJar, newMainJar, backupJar, this.mainUpdater, "main", tryEasyWay)) {
                    writtenNewJar = true;
                }
            }
            catch (UpdateFailedException e) {
                this.failUpdate(e.getMessage());
                return false;
            }
        }
        if (!writtenNewJar && !deps.mustRewriteWrapperConf) {
            return true;
        }
        try {
            ctx.rewriteWrapperConf(writtenNewJar);
        }
        catch (IOException e) {
            this.failUpdate("Cannot rewrite wrapper.conf: " + e);
            return false;
        }
        catch (UpdateDeployContext.UpdateCatastropheException e) {
            this.failUpdate(e.getMessage());
            this.node.clientCore.alerts.register(new SimpleUserAlert(false, this.l10n("updateCatastropheTitle"), e.getMessage(), this.l10n("updateCatastropheTitle"), 0));
            return false;
        }
        catch (UpdaterParserException e) {
            this.node.clientCore.alerts.register(new SimpleUserAlert(false, this.l10n("updateFailedTitle"), e.getMessage(), this.l10n("updateFailedShort", "reason", e.getMessage()), 0));
            return false;
        }
        return true;
    }

    private boolean writeJar(File mainJar, File newMainJar, File backupMainJar, NodeUpdater mainUpdater, String name, boolean tryEasyWay) throws UpdateFailedException {
        boolean writtenToTempFile = false;
        try {
            if (newMainJar.exists()) {
                if (!newMainJar.delete()) {
                    if (newMainJar.exists()) {
                        System.err.println("Cannot write to preferred new jar location " + newMainJar);
                        if (tryEasyWay) {
                            try {
                                newMainJar = File.createTempFile("freenet", ".jar", mainJar.getParentFile());
                            }
                            catch (IOException e) {
                                throw new UpdateFailedException("Cannot write to any other location either - disk full? " + e);
                            }
                            try {
                                this.writeJarTo(newMainJar);
                                writtenToTempFile = true;
                            }
                            catch (IOException e) {
                                newMainJar.delete();
                                throw new UpdateFailedException("Cannot write new jar - disk full? " + e);
                            }
                        }
                        this.writeJarTo(newMainJar);
                    } else {
                        this.writeJarTo(newMainJar);
                    }
                } else {
                    if (logMINOR) {
                        Logger.minor(NodeUpdateManager.class, "Deleted old jar " + newMainJar);
                    }
                    this.writeJarTo(newMainJar);
                }
            } else {
                this.writeJarTo(newMainJar);
            }
            System.out.println("Written new main jar to " + newMainJar);
        }
        catch (IOException e) {
            throw new UpdateFailedException("Cannot update: Cannot write to " + (tryEasyWay ? " temp file " : "new jar ") + newMainJar);
        }
        if (tryEasyWay) {
            backupMainJar.delete();
            if (FileUtil.copyFile(mainJar, backupMainJar)) {
                System.err.println("Written backup of current main jar to " + backupMainJar + " (if freenet fails to start up try renaming " + backupMainJar + " over " + mainJar);
            }
            if (!newMainJar.renameTo(mainJar)) {
                Logger.error(NodeUpdateManager.class, "Cannot rename temp file " + newMainJar + " over original jar " + mainJar);
                if (writtenToTempFile) {
                    newMainJar.delete();
                    throw new UpdateFailedException("Cannot write to preferred new jar location and cannot rename temp file over old jar, update failed");
                }
            } else {
                System.err.println("Completed writing new Freenet jar to " + mainJar + ".");
                return false;
            }
        }
        System.err.println("Rewriting wrapper.conf to point to " + newMainJar + " rather than " + mainJar + " (if Freenet fails to start after the update you could try changing wrapper.conf to use the old jar)");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJarTo(File fNew) throws IOException {
        if (!fNew.delete() && fNew.exists()) {
            System.err.println("Can't delete " + fNew + "!");
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fNew);
            BucketTools.copyTo(this.fetchedMainJarData, fos, -1L);
            fos.flush();
        }
        catch (Throwable throwable) {
            Closer.close(fos);
            throw throwable;
        }
        Closer.close(fos);
    }

    private void restart(UpdateDeployContext ctx) {
        if (logMINOR) {
            Logger.minor(this, "Restarting...");
        }
        this.node.getNodeStarter().restart();
        try {
            Thread.sleep(TimeUnit.MINUTES.toMillis(5L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.err.println("Failed to restart. Exiting, please restart the node.");
        System.exit(24);
    }

    private void failUpdate(String reason) {
        Logger.error(this, "Update failed: " + reason);
        System.err.println("Update failed: " + reason);
        this.killUpdateAlerts();
        this.node.clientCore.alerts.register(new SimpleUserAlert(true, this.l10n("updateFailedTitle"), this.l10n("updateFailed", "reason", reason), this.l10n("updateFailedShort", "reason", reason), 0));
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("NodeUpdateManager." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("NodeUpdateManager." + key, pattern, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDownloadedNewJar(Bucket result, int fetched, File savedBlob) {
        Bucket delete1 = null;
        Bucket delete2 = null;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (fetched > Version.buildNumber()) {
                this.hasNewMainJar = true;
                this.startedFetchingNextMainJar = -1L;
                this.gotJarTime = System.currentTimeMillis();
                if (logMINOR) {
                    Logger.minor(this, "Got main jar: " + fetched);
                }
            }
            if (!this.isDeployingUpdate) {
                delete1 = this.fetchedMainJarData;
                this.fetchedMainJarVersion = fetched;
                this.fetchedMainJarData = result;
                if (fetched == Version.buildNumber()) {
                    if (savedBlob != null) {
                        this.currentVersionBlobFile = savedBlob;
                    } else {
                        Logger.error(this, "No blob file for latest version?!", (Throwable)new Exception("error"));
                    }
                }
            } else {
                delete2 = this.maybeNextMainJarData;
                this.maybeNextMainJarVersion = fetched;
                this.maybeNextMainJarData = result;
                System.out.println("Already deploying update, not using new main jar #" + fetched);
            }
        }
        if (delete1 != null) {
            delete1.free();
        }
        if (delete2 != null) {
            delete2.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStartFetching() {
        long now = System.currentTimeMillis();
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            this.startedFetchingNextMainJar = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blow(String msg, boolean disabledNotBlown) {
        MainJarUpdater main;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (this.hasBeenBlown) {
                if (this.disabledNotBlown && !disabledNotBlown) {
                    disabledNotBlown = true;
                }
                Logger.error(this, "The key has ALREADY been marked as blown! Message was " + this.revocationMessage + " new message " + msg);
                return;
            }
            this.revocationMessage = msg;
            this.hasBeenBlown = true;
            this.disabledNotBlown = disabledNotBlown;
            try {
                if (disabledNotBlown) {
                    System.err.println("THE AUTO-UPDATING SYSTEM HAS BEEN DISABLED!");
                    System.err.println("We do not know whether this is a local problem or the auto-update system has in fact been compromised. What we do know:\n" + this.revocationMessage);
                } else {
                    System.err.println("THE AUTO-UPDATING SYSTEM HAS BEEN COMPROMISED!");
                    System.err.println("The auto-updating system revocation key has been inserted. It says: " + this.revocationMessage);
                }
            }
            catch (Throwable t) {
                try {
                    Logger.error(this, "Caught " + t, t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            main = this.mainUpdater;
            if (main != null) {
                main.preKill();
            }
            this.mainUpdater = null;
        }
        if (main != null) {
            main.kill();
        }
        if (this.revocationAlert == null) {
            this.revocationAlert = new RevocationKeyFoundUserAlert(msg, disabledNotBlown);
            this.node.clientCore.alerts.register(this.revocationAlert);
            this.killUpdateAlerts();
        }
        this.uom.killAlert();
        this.broadcastUOMAnnouncesOld();
        this.broadcastUOMAnnouncesNew();
    }

    private void killUpdateAlerts() {
        this.node.clientCore.alerts.unregister(this.alert);
    }

    public void noRevocationFound() {
        this.deployUpdate();
        this.deployPluginUpdates();
        this.broadcastUOMAnnouncesNew();
        this.node.ticker.queueTimedJob(new Runnable(){

            @Override
            public void run() {
                NodeUpdateManager.this.revocationChecker.start(false);
            }
        }, this.node.random.nextInt((int)TimeUnit.DAYS.toMillis(1L)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployPluginUpdates() {
        PluginJarUpdater[] updaters = null;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (this.pluginUpdaters != null) {
                updaters = this.pluginUpdaters.values().toArray(new PluginJarUpdater[this.pluginUpdaters.size()]);
            }
        }
        boolean restartRevocationFetcher = false;
        if (updaters != null) {
            for (PluginJarUpdater u : updaters) {
                if (!u.onNoRevocation()) continue;
                restartRevocationFetcher = true;
            }
        }
        if (restartRevocationFetcher) {
            this.revocationChecker.start(true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void arm() {
        this.armed = true;
        OpennetManager om = this.node.getOpennet();
        if (om != null && om.waitingForUpdater()) {
            NodeUpdateManager nodeUpdateManager = this;
            synchronized (nodeUpdateManager) {
                if (this.gotJarTime > 0L) {
                    this.gotJarTime = System.currentTimeMillis();
                }
            }
            om.reannounce();
        }
        this.deployOffThread(0L, false);
    }

    void deployOffThread(long delay, final boolean announce) {
        this.node.ticker.queueTimedJob(new Runnable(){

            @Override
            public void run() {
                if (announce) {
                    NodeUpdateManager.this.maybeBroadcastUOMAnnouncesNew();
                }
                if (logMINOR) {
                    Logger.minor(this, "Running deployOffThread");
                }
                NodeUpdateManager.this.deployUpdate();
                if (logMINOR) {
                    Logger.minor(this, "Run deployOffThread");
                }
            }
        }, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeBroadcastUOMAnnouncesNew() {
        if (logMINOR) {
            Logger.minor(this, "Maybe broadcast UOM announces new");
        }
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (this.hasBeenBlown) {
                return;
            }
            if (this.peersSayBlown) {
                return;
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Maybe broadcast UOM announces new (2)");
        }
        this.broadcastUOMAnnouncesNew();
    }

    public boolean isBlown() {
        return this.hasBeenBlown;
    }

    public boolean hasNewMainJar() {
        return this.hasNewMainJar;
    }

    public int newMainJarVersion() {
        if (this.mainUpdater == null) {
            return -1;
        }
        return this.mainUpdater.getFetchedVersion();
    }

    public boolean fetchingNewMainJar() {
        return this.mainUpdater != null && this.mainUpdater.isFetching();
    }

    public int fetchingNewMainJarVersion() {
        if (this.mainUpdater == null) {
            return -1;
        }
        return this.mainUpdater.fetchingVersion();
    }

    public boolean inFinalCheck() {
        return this.isReadyToDeployUpdate(true) && !this.isReadyToDeployUpdate(false);
    }

    public int getRevocationDNFCounter() {
        return this.revocationChecker.getRevocationDNFCounter();
    }

    public int getMainVersion() {
        return Version.buildNumber();
    }

    public int getExtVersion() {
        return NodeStarter.extBuildNumber;
    }

    public boolean isArmed() {
        return this.armed || this.isAutoUpdateAllowed;
    }

    public boolean canUpdateNow() {
        return this.isReadyToDeployUpdate(true);
    }

    public boolean canUpdateImmediately() {
        return this.isReadyToDeployUpdate(false);
    }

    void peerClaimsKeyBlown() {
        this.peersSayBlown = true;
    }

    public void notPeerClaimsKeyBlown() {
        this.peersSayBlown = false;
        this.node.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (NodeUpdateManager.this.isReadyToDeployUpdate(false)) {
                    NodeUpdateManager.this.deployUpdate();
                }
            }
        }, "Check for updates");
        this.node.getTicker().queueTimedJob(new Runnable(){

            @Override
            public void run() {
                NodeUpdateManager.this.maybeBroadcastUOMAnnouncesNew();
            }
        }, REVOCATION_FETCH_TIMEOUT);
    }

    boolean peersSayBlown() {
        return this.peersSayBlown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getMainBlob(int version) {
        MainJarUpdater updater;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (this.hasBeenBlown) {
                return null;
            }
            updater = this.mainUpdater;
            if (updater == null) {
                return null;
            }
        }
        return updater.getBlobFile(version);
    }

    public synchronized long timeRemainingOnCheck() {
        long now = System.currentTimeMillis();
        return Math.max(0L, REVOCATION_FETCH_TIMEOUT - (now - this.gotJarTime));
    }

    public void disableThisSession() {
        this.disabledThisSession = true;
    }

    protected long getStartedFetchingNextMainJarTimestamp() {
        return this.startedFetchingNextMainJar;
    }

    public void disconnected(PeerNode pn) {
        this.uom.disconnected(pn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployPlugin(String fn) throws IOException {
        PluginJarUpdater updater;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (this.hasBeenBlown) {
                Logger.error(this, "Not deploying update for " + fn + " because revocation key has been blown!");
                return;
            }
            updater = this.pluginUpdaters.get(fn);
        }
        updater.writeJar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployPluginWhenReady(String fn) throws IOException {
        PluginJarUpdater updater;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (this.hasBeenBlown) {
                Logger.error(this, "Not deploying update for " + fn + " because revocation key has been blown!");
                return;
            }
            updater = this.pluginUpdaters.get(fn);
        }
        boolean wasRunning = this.revocationChecker.start(true, true);
        updater.arm(wasRunning);
    }

    public boolean dontAllowUOM() {
        if (this.node.isOpennetEnabled() && this.node.wantAnonAuth(true)) {
            return this.node.getUptime() <= TimeUnit.MINUTES.toMillis(5L) || this.node.peers.countCompatibleRealPeers() != 0;
        }
        return false;
    }

    public boolean fetchingFromUOM() {
        return this.uom.isFetchingMain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDependenciesReady(MainJarDependenciesChecker.MainJarDependencies deps) {
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            this.latestMainJarDependencies = deps;
            this.dependenciesValidForBuild = deps.build;
        }
        this.revocationChecker.start(true);
        this.deployOffThread(0L, true);
    }

    public File getTransitionMainBlob() {
        return this.transitionMainJarFetcher.getBlobFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderProgress(HTMLNode alertNode) {
        MainJarUpdater m;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            if (this.fetchedMainJarData == null) {
                return;
            }
            m = this.mainUpdater;
            if (m == null) {
                return;
            }
        }
        m.renderProperties(alertNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean brokenDependencies() {
        MainJarUpdater m;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            m = this.mainUpdater;
            if (m == null) {
                return false;
            }
        }
        return m.brokenDependencies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStartFetchingUOM() {
        MainJarUpdater m;
        NodeUpdateManager nodeUpdateManager = this;
        synchronized (nodeUpdateManager) {
            m = this.mainUpdater;
            if (m == null) {
                return;
            }
        }
        m.onStartFetchingUOM();
    }

    public synchronized File getCurrentVersionBlobFile() {
        if (this.hasNewMainJar) {
            return null;
        }
        if (this.isDeployingUpdate) {
            return null;
        }
        if (this.fetchedMainJarVersion != Version.buildNumber()) {
            return null;
        }
        return this.currentVersionBlobFile;
    }

    MainJarUpdater getMainUpdater() {
        return this.mainUpdater;
    }

    static {
        try {
            transitionMainJarURI = new FreenetURI(LEGACY_UPDATE_URI);
            transitionMainJarURIAsUSK = transitionMainJarURI.uskForSSK();
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
        deployLock = new Object();
        Logger.registerClass(NodeUpdateManager.class);
        WAIT_FOR_SECOND_FETCH_TO_COMPLETE = TimeUnit.MINUTES.toMillis(4L);
        RECENT_REVOCATION_INTERVAL = TimeUnit.MINUTES.toMillis(2L);
        REVOCATION_FETCH_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    }

    public class UpdateRevocationURICallback
    extends StringCallback {
        @Override
        public String get() {
            return NodeUpdateManager.this.getRevocationURI().toString(false, false);
        }

        @Override
        public void set(String val) throws InvalidConfigValueException {
            FreenetURI uri;
            try {
                uri = new FreenetURI(val);
            }
            catch (MalformedURLException e) {
                throw new InvalidConfigValueException(NodeUpdateManager.this.l10n("invalidRevocationURI", "error", e.getLocalizedMessage()));
            }
            NodeUpdateManager.this.setRevocationURI(uri);
        }
    }

    class UpdateURICallback
    extends StringCallback {
        UpdateURICallback() {
        }

        @Override
        public String get() {
            return NodeUpdateManager.this.getURI().toString(false, false);
        }

        @Override
        public void set(String val) throws InvalidConfigValueException {
            FreenetURI uri;
            try {
                uri = new FreenetURI(val);
            }
            catch (MalformedURLException e) {
                throw new InvalidConfigValueException(NodeUpdateManager.this.l10n("invalidUpdateURI", "error", e.getLocalizedMessage()));
            }
            if (NodeUpdateManager.this.updateURI.hasMetaStrings()) {
                throw new InvalidConfigValueException(NodeUpdateManager.this.l10n("updateURIMustHaveNoMetaStrings"));
            }
            if (!NodeUpdateManager.this.updateURI.isUSK()) {
                throw new InvalidConfigValueException(NodeUpdateManager.this.l10n("updateURIMustBeAUSK"));
            }
            NodeUpdateManager.this.setURI(uri);
        }
    }

    class AutoUpdateAllowedCallback
    extends BooleanCallback {
        AutoUpdateAllowedCallback() {
        }

        @Override
        public Boolean get() {
            return NodeUpdateManager.this.isAutoUpdateAllowed();
        }

        @Override
        public void set(Boolean val) throws InvalidConfigValueException {
            NodeUpdateManager.this.setAutoUpdateAllowed(val);
        }
    }

    class UpdaterEnabledCallback
    extends BooleanCallback {
        UpdaterEnabledCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean get() {
            if (NodeUpdateManager.this.isEnabled()) {
                return true;
            }
            NodeUpdateManager nodeUpdateManager = NodeUpdateManager.this;
            synchronized (nodeUpdateManager) {
                if (NodeUpdateManager.this.disabledNotBlown) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void set(Boolean val) throws InvalidConfigValueException {
            NodeUpdateManager.this.enable(val);
        }
    }

    private static class UpdateFailedException
    extends Exception {
        public UpdateFailedException(String message) {
            super(message);
        }
    }

    class SimplePuller
    implements ClientGetCallback {
        final FreenetURI freenetURI;
        final String filename;
        final ProgramDirectory directory;

        public SimplePuller(FreenetURI freenetURI, NodeFile file) {
            this(freenetURI, file.getFilename(), file.getProgramDirectory(nodeUpdateManager.node));
        }

        private SimplePuller(FreenetURI freenetURI, String filename, ProgramDirectory directory) {
            this.freenetURI = freenetURI;
            this.filename = filename;
            this.directory = directory;
        }

        public void start(short priority, long maxSize) {
            HighLevelSimpleClient hlsc = NodeUpdateManager.this.node.clientCore.makeClient(priority, false, false);
            FetchContext context = hlsc.getFetchContext();
            context.maxNonSplitfileRetries = -1;
            context.maxSplitfileBlockRetries = -1;
            context.maxTempLength = maxSize;
            context.maxOutputLength = maxSize;
            ClientGetter get = new ClientGetter(this, this.freenetURI, context, priority, null, null, null);
            try {
                NodeUpdateManager.this.node.clientCore.clientContext.start(get);
            }
            catch (PersistenceDisabledException persistenceDisabledException) {
            }
            catch (FetchException e) {
                this.onFailure(e, null);
            }
        }

        @Override
        public void onFailure(FetchException e, ClientGetter state) {
            System.err.println("Failed to fetch " + this.filename + " : " + e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(FetchResult result, ClientGetter state) {
            FileOutputStream fos = null;
            try {
                File temp = File.createTempFile(this.filename, ".tmp", this.directory.dir());
                temp.deleteOnExit();
                fos = new FileOutputStream(temp);
                BucketTools.copyTo(result.asBucket(), fos, -1L);
                fos.close();
                fos = null;
                for (int i = 0; i < 10; ++i) {
                    if (FileUtil.renameTo(temp, this.directory.file(this.filename))) {
                        System.out.println("Successfully fetched " + this.filename + " for version " + Version.buildNumber());
                        break;
                    }
                    System.out.println("Failed to rename " + temp + " to " + this.filename + " after fetching it from Freenet.");
                    try {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(1L) + (long)NodeUpdateManager.this.node.fastWeakRandom.nextInt((int)TimeUnit.SECONDS.toMillis((long)Math.min(Math.pow(2.0, i), (double)TimeUnit.MINUTES.toSeconds(15L)))));
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                temp.delete();
            }
            catch (IOException e) {
                try {
                    System.err.println("Fetched but failed to write out " + this.filename + " - please check that the node has permissions to write in " + this.directory.dir() + " and particularly the file " + this.filename);
                    System.err.println("The error was: " + e);
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Closer.close(fos);
                    Closer.close(result.asBucket());
                    throw throwable;
                }
                Closer.close(fos);
                Closer.close(result.asBucket());
            }
            Closer.close(fos);
            Closer.close(result.asBucket());
        }

        @Override
        public void onResume(ClientContext context) {
        }

        @Override
        public RequestClient getRequestClient() {
            return NodeUpdateManager.this.node.nonPersistentClientBulk;
        }
    }
}

