/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.BloomFilter;
import freenet.support.io.Closer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class BinaryBloomFilter
extends BloomFilter {
    protected BinaryBloomFilter(int length, int k) {
        super(length, k);
        this.filter = ByteBuffer.allocate(this.length / 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BinaryBloomFilter(File file, int length, int k) throws IOException {
        super(length, k);
        if (!file.exists() || file.length() != (long)(length / 8)) {
            this.needRebuild = true;
        }
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        FileChannel channel = null;
        try {
            raf.setLength(length / 8);
            channel = raf.getChannel();
            this.filter = channel.map(FileChannel.MapMode.READ_WRITE, 0L, length / 8).load();
        }
        catch (Throwable throwable) {
            Closer.close(raf);
            Closer.close(channel);
            throw throwable;
        }
        Closer.close(raf);
        Closer.close(channel);
    }

    public BinaryBloomFilter(ByteBuffer slice, int length, int k) {
        super(length, k);
        this.filter = slice;
    }

    @Override
    public void removeKey(byte[] key) {
    }

    @Override
    protected boolean getBit(int offset) {
        return (this.filter.get(offset / 8) & 1 << offset % 8) != 0;
    }

    @Override
    protected void setBit(int offset) {
        byte b = this.filter.get(offset / 8);
        b = (byte)(b | 1 << offset % 8);
        this.filter.put(offset / 8, b);
    }

    @Override
    protected void unsetBit(int offset) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fork(int k) {
        this.lock.writeLock().lock();
        try {
            File tempFile = File.createTempFile("bloom-", ".tmp");
            tempFile.deleteOnExit();
            this.forkedFilter = new BinaryBloomFilter(tempFile, this.length, k);
        }
        catch (IOException e) {
            this.forkedFilter = new BinaryBloomFilter(this.length, k);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

