/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.math.RunningAverage;
import freenet.support.math.TrivialRunningAverage;

public class Histogram2 {
    private final double MAX;
    private final RunningAverage[] bars;

    public Histogram2(int numBars, double maxValue) {
        this.MAX = maxValue;
        this.bars = new RunningAverage[numBars];
        for (int i = 0; i < numBars; ++i) {
            this.bars[i] = new TrivialRunningAverage();
        }
    }

    public void report(double key, double value) {
        if (key < 0.0 || key >= this.MAX) {
            return;
        }
        int n = (int)((double)this.bars.length * key / this.MAX);
        this.bars[n].report(value);
    }

    public int[] getPercentageArray(int localMax) {
        int[] retval = new int[this.bars.length];
        for (int i = 0; i < retval.length; ++i) {
            int val;
            retval[i] = val = (int)(this.bars[i].currentValue() * (double)localMax / this.MAX);
        }
        return retval;
    }
}

