/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.builder;

import java.util.logging.Logger;
import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.DocumentBuilder;

public class EventLoggingDocumentBuilder
extends DocumentBuilder {
    private Logger logger = Logger.getLogger(EventLoggingDocumentBuilder.class.getName());
    private int blockDepth = 0;

    @Override
    public void acronym(String text, String definition) {
        this.logger.info("ACRONYM:" + text + "," + definition);
    }

    @Override
    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        ++this.blockDepth;
        this.logger.info("BLOCK START[" + this.blockDepth + "]:" + (Object)((Object)type));
    }

    @Override
    public void beginDocument() {
        this.logger.info("DOCUMENT START");
    }

    @Override
    public void beginHeading(int level, Attributes attributes) {
        this.logger.info("HEADING START:" + level);
    }

    @Override
    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        this.logger.info("SPAN START:" + (Object)((Object)type));
    }

    @Override
    public void characters(String text) {
        this.logger.info("CHARACTERS:" + text);
    }

    @Override
    public void charactersUnescaped(String text) {
        this.logger.info("HTML LITERAL:" + text);
    }

    @Override
    public void endBlock() {
        this.logger.info("END BLOCK[" + this.blockDepth + "]");
        --this.blockDepth;
    }

    @Override
    public void endDocument() {
        this.logger.info("END DOCUMENT");
    }

    @Override
    public void endHeading() {
        this.logger.info("END HEADING");
    }

    @Override
    public void endSpan() {
        this.logger.info("END SPAN");
    }

    @Override
    public void entityReference(String entity) {
        this.logger.info("ENTITY: " + entity);
    }

    @Override
    public void image(Attributes attributes, String url) {
        this.logger.info("IMAGE: " + url);
    }

    @Override
    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.logger.info("IMAGE LINK: " + href + ", " + imageUrl);
    }

    @Override
    public void lineBreak() {
        this.logger.info("LINE BREAK");
    }

    @Override
    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.logger.info("LINK: " + hrefOrHashName + ", " + text);
    }
}

