/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.mediawiki.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.markup.Block;

public class HeadingBlock
extends Block {
    private static final Pattern pattern = Pattern.compile("\\s*(\\={1,6})\\s*(.+?)\\s*\\1");
    private int blockLineCount = 0;
    private Matcher matcher;

    @Override
    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        if (lineOffset == 0) {
            this.matcher = pattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    @Override
    public int processLineContent(String line, int offset) {
        if (this.blockLineCount > 0) {
            throw new IllegalStateException();
        }
        ++this.blockLineCount;
        int level = this.matcher.group(1).length();
        String text = this.matcher.group(2);
        Attributes attributes = new Attributes();
        if (attributes.getId() == null) {
            attributes.setId(this.state.getIdGenerator().newId("h" + level, line.substring(offset)));
        }
        this.builder.beginHeading(level, attributes);
        this.builder.characters(text);
        this.builder.endHeading();
        this.setClosed(true);
        return -1;
    }
}

