/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.textile.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.markup.Block;
import net.java.textilej.parser.markup.textile.TextileDialect;
import net.java.textilej.parser.outline.OutlineItem;
import net.java.textilej.parser.outline.OutlineParser;

public class TableOfContentsBlock
extends Block {
    static final Pattern startPattern = Pattern.compile("\\s*\\{toc(?::([^\\}]+))?\\}\\s*");
    private int blockLineNumber = 0;
    private String style = "none";
    private int maxLevel = Integer.MAX_VALUE;
    private Matcher matcher;

    @Override
    public int processLineContent(String line, int offset) {
        if (this.blockLineNumber++ > 0) {
            this.setClosed(true);
            return 0;
        }
        if (!this.getDialect().isFilterGenerativeContents()) {
            String options = this.matcher.group(1);
            if (options != null) {
                String[] optionPairs;
                for (String optionPair : optionPairs = options.split("\\s*\\|\\s*")) {
                    String[] keyValue = optionPair.split("\\s*=\\s*");
                    if (keyValue.length != 2) continue;
                    String key = keyValue[0].trim();
                    String value = keyValue[1].trim();
                    if (key.equals("style")) {
                        this.setStyle(value);
                        continue;
                    }
                    if (!key.equals("maxLevel")) continue;
                    try {
                        this.maxLevel = Integer.parseInt(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            OutlineParser outlineParser = new OutlineParser(new TextileDialect());
            OutlineItem rootItem = outlineParser.parse(this.state.getMarkupContent());
            this.emitToc(rootItem);
        }
        return -1;
    }

    private void emitToc(OutlineItem item) {
        if (item.getChildren().isEmpty()) {
            return;
        }
        if (item.getLevel() + 1 > this.maxLevel) {
            return;
        }
        Attributes nullAttributes = new Attributes();
        this.builder.beginBlock(DocumentBuilder.BlockType.NUMERIC_LIST, new Attributes(null, null, "list-style: " + this.style + ";", null));
        for (OutlineItem child : item.getChildren()) {
            this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, nullAttributes);
            this.builder.link('#' + child.getId(), child.getLabel());
            this.emitToc(child);
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    @Override
    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }
}

