/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.outline;

import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.IdGenerator;
import net.java.textilej.parser.MarkupParser;
import net.java.textilej.parser.markup.Dialect;
import net.java.textilej.parser.outline.OutlineItem;

public class OutlineParser {
    private int labelMaxLength = 0;
    private Dialect dialect;

    public OutlineParser(Dialect dialect) {
        this.dialect = dialect;
    }

    public OutlineParser() {
    }

    public int getLabelMaxLength() {
        return this.labelMaxLength;
    }

    public void setLabelMaxLength(int labelMaxLength) {
        this.labelMaxLength = labelMaxLength;
    }

    public OutlineItem parse(String markup) {
        OutlineItem root = this.createRootItem();
        return this.parse(root, markup);
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public OutlineItem createRootItem() {
        return OutlineParser.createOutlineItem(null, 0, "<root>", -1, 0, "<root>");
    }

    public OutlineItem parse(OutlineItem root, String markup) {
        if (markup == null || markup.length() == 0 || this.dialect == null) {
            return root;
        }
        this.dialect.setFilterGenerativeContents(true);
        this.dialect.setBlocksOnly(true);
        OutlineBuilder outlineBuilder = new OutlineBuilder(root, this.labelMaxLength);
        MarkupParser markupParser = new MarkupParser();
        markupParser.setBuilder(outlineBuilder);
        markupParser.setDialect(this.dialect);
        markupParser.parse(markup);
        return root;
    }

    protected static OutlineItem createOutlineItem(OutlineItem current, int level, String id, int offset, int length, String label) {
        return new OutlineItem(current, level, id, offset, length, label);
    }

    public DocumentBuilder createOutlineUpdater(OutlineItem rootItem) {
        return new OutlineBuilder(rootItem, this.labelMaxLength);
    }

    private static class OutlineBuilder
    extends DocumentBuilder {
        private OutlineItem currentItem;
        private int level;
        private StringBuilder buf;
        private IdGenerator idGenerator = new IdGenerator();
        private int offset;
        private int length;
        private OutlineItem rootItem;
        private final int labelMaxLength;

        public OutlineBuilder(OutlineItem root, int labelMaxLength) {
            this.currentItem = root;
            this.rootItem = root;
            this.labelMaxLength = labelMaxLength;
        }

        @Override
        public void acronym(String text, String definition) {
        }

        @Override
        public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        }

        @Override
        public void beginDocument() {
            this.rootItem.clear();
            this.currentItem = this.rootItem;
        }

        @Override
        public void beginHeading(int level, Attributes attributes) {
            this.level = level;
            this.buf = new StringBuilder();
            this.offset = this.getLocator().getDocumentOffset();
            this.length = this.getLocator().getLineLength();
        }

        @Override
        public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        }

        @Override
        public void characters(String text) {
            if (this.buf != null) {
                this.buf.append(text);
            }
        }

        @Override
        public void charactersUnescaped(String literal) {
            if (this.buf != null) {
                this.buf.append(literal);
            }
        }

        @Override
        public void endBlock() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void endHeading() {
            String label;
            String fullLabelText = label = this.buf.toString();
            if (label == null) {
                label = "";
            } else if (this.labelMaxLength > 0 && label.length() > this.labelMaxLength) {
                label = label.substring(0, this.labelMaxLength) + "...";
            }
            String kind = "h" + this.level;
            while (this.level <= this.currentItem.getLevel()) {
                this.currentItem = this.currentItem.getParent();
            }
            this.currentItem = OutlineParser.createOutlineItem(this.currentItem, this.level, this.idGenerator.newId(kind, fullLabelText), this.offset, this.length, label);
            this.currentItem.setTooltip(fullLabelText);
            this.currentItem.setKind(kind);
            this.buf = null;
            this.offset = 0;
            this.length = 0;
        }

        @Override
        public void endSpan() {
        }

        @Override
        public void entityReference(String entity) {
        }

        @Override
        public void image(Attributes attributes, String url) {
        }

        @Override
        public void imageLink(Attributes linkAttributes, Attributes ImageAttributes2, String href, String imageUrl) {
        }

        @Override
        public void lineBreak() {
        }

        @Override
        public void link(Attributes attributes, String hrefOrHashName, String text) {
            if (this.buf != null) {
                this.buf.append(text);
            }
        }
    }
}

