/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.onionnetworks.util.FileUtil;
import freenet.client.async.BinaryBlobFormatException;
import freenet.client.async.BlockSet;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.KeyVerifyException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public abstract class BinaryBlob {
    public static final long BINARY_BLOB_MAGIC = 7879087815329742553L;
    public static final short BINARY_BLOB_OVERALL_VERSION = 0;
    static final short BLOB_BLOCK = 1;
    static final short BLOB_BLOCK_VERSION = 0;
    static final short BLOB_END = 2;
    static final short BLOB_END_VERSION = 0;
    public static final String MIME_TYPE = "application/x-freenet-binary-blob";

    public static void writeBinaryBlobHeader(DataOutputStream binaryBlobStream) throws IOException {
        binaryBlobStream.writeLong(7879087815329742553L);
        binaryBlobStream.writeShort(0);
    }

    public static void writeKey(DataOutputStream binaryBlobStream, KeyBlock block, Key key) throws IOException {
        byte[] keyData = key.getKeyBytes();
        byte[] headers = block.getRawHeaders();
        byte[] data = block.getRawData();
        byte[] pubkey = block.getPubkeyBytes();
        BinaryBlob.writeBlobHeader(binaryBlobStream, (short)1, (short)0, 9 + keyData.length + headers.length + data.length + (pubkey == null ? 0 : pubkey.length));
        binaryBlobStream.writeShort(block.getKey().getType());
        binaryBlobStream.writeByte(keyData.length);
        binaryBlobStream.writeShort(headers.length);
        binaryBlobStream.writeShort(data.length);
        binaryBlobStream.writeShort(pubkey == null ? 0 : pubkey.length);
        binaryBlobStream.write(keyData);
        binaryBlobStream.write(headers);
        binaryBlobStream.write(data);
        if (pubkey != null) {
            binaryBlobStream.write(pubkey);
        }
    }

    static void writeBlobHeader(DataOutputStream binaryBlobStream, short type, short version, int length) throws IOException {
        binaryBlobStream.writeInt(length);
        binaryBlobStream.writeShort(type);
        binaryBlobStream.writeShort(version);
    }

    public static void writeEndBlob(DataOutputStream binaryBlobStream) throws IOException {
        BinaryBlob.writeBlobHeader(binaryBlobStream, (short)2, (short)0, 0);
    }

    public static void readBinaryBlob(DataInputStream dis, BlockSet blocks, boolean tolerant) throws IOException, BinaryBlobFormatException {
        block12: {
            short blobType;
            long magic = dis.readLong();
            if (magic != 7879087815329742553L) {
                throw new BinaryBlobFormatException("Bad magic");
            }
            short version = dis.readShort();
            if (version != 0) {
                throw new BinaryBlobFormatException("Unknown overall version");
            }
            while (true) {
                long blobLength;
                try {
                    blobLength = (long)dis.readInt() & 0xFFFFFFFFL;
                }
                catch (EOFException e) {
                    dis.close();
                    break block12;
                }
                blobType = dis.readShort();
                short blobVer = dis.readShort();
                if (blobType == 2) {
                    dis.close();
                    break block12;
                }
                if (blobType == 1) {
                    KeyBlock block;
                    int pubkeyLen;
                    int dataLen;
                    int headersLen;
                    if (blobVer != 0) {
                        throw new BinaryBlobFormatException("Unknown block blob version");
                    }
                    if (blobLength < 9L) {
                        throw new BinaryBlobFormatException("Block blob too short");
                    }
                    short keyType = dis.readShort();
                    int keyLen = dis.readUnsignedByte();
                    int total = 9 + keyLen + (headersLen = dis.readUnsignedShort()) + (dataLen = dis.readUnsignedShort()) + (pubkeyLen = dis.readUnsignedShort());
                    if (blobLength != (long)total) {
                        throw new BinaryBlobFormatException("Binary blob not same length as data: blobLength=" + blobLength + " total=" + total);
                    }
                    byte[] keyBytes = new byte[keyLen];
                    byte[] headersBytes = new byte[headersLen];
                    byte[] dataBytes = new byte[dataLen];
                    byte[] pubkeyBytes = new byte[pubkeyLen];
                    dis.readFully(keyBytes);
                    dis.readFully(headersBytes);
                    dis.readFully(dataBytes);
                    dis.readFully(pubkeyBytes);
                    try {
                        block = Key.createBlock(keyType, keyBytes, headersBytes, dataBytes, pubkeyBytes);
                    }
                    catch (KeyVerifyException e) {
                        throw new BinaryBlobFormatException("Invalid key: " + e.getMessage(), e);
                    }
                    blocks.add(block);
                    continue;
                }
                if (!tolerant) break;
                FileUtil.skipFully((InputStream)dis, (long)blobLength);
            }
            throw new BinaryBlobFormatException("Unknown blob type: " + blobType);
        }
    }
}

