/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.MultiPutCompletionCallback;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SingleBlockInserter;
import freenet.client.async.USKDateHint;
import freenet.client.async.USKFetcherCallback;
import freenet.client.async.USKFetcherTag;
import freenet.keys.BaseClientKey;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableUSK;
import freenet.keys.USK;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.ResumeFailedException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.Arrays;

public class USKInserter
implements ClientPutState,
USKFetcherCallback,
PutCompletionCallback,
Serializable {
    private static final long serialVersionUID = 1L;
    private static volatile boolean logMINOR;
    final BaseClientPutter parent;
    Bucket data;
    final short compressionCodec;
    final InsertContext ctx;
    final PutCompletionCallback cb;
    final boolean isMetadata;
    final int sourceLength;
    final int token;
    public final Object tokenObject;
    final boolean persistent;
    final boolean realTimeFlag;
    final InsertableUSK privUSK;
    final USK pubUSK;
    private USKFetcherTag fetcher;
    private SingleBlockInserter sbi;
    private long edition;
    private int consecutiveCollisions;
    private boolean finished;
    private static final long MAX_TRIED_SLOTS = 10L;
    private boolean freeData;
    final int hashCode;
    private final int extraInserts;
    final byte cryptoAlgorithm;
    final byte[] forceCryptoKey;
    private transient boolean resumed = false;

    @Override
    public void schedule(ClientContext context) throws InsertException {
        this.scheduleFetcher(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFetcher(ClientContext context) {
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            if (logMINOR) {
                Logger.minor(this, "scheduling fetcher for " + this.pubUSK.getURI());
            }
            if (this.finished) {
                return;
            }
            this.fetcher = context.uskManager.getFetcherForInsertDontSchedule(this.persistent ? this.pubUSK.copy() : this.pubUSK, this.parent.priorityClass, this, this.parent.getClient(), context, this.persistent, this.ctx.ignoreUSKDatehints);
            if (logMINOR) {
                Logger.minor(this, "scheduled: " + this.fetcher);
            }
        }
        this.fetcher.schedule(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFoundEdition(long l, USK key, ClientContext context, boolean lastContentWasMetadata, short codec, byte[] hisData, boolean newKnownGood, boolean newSlotToo) {
        boolean alreadyInserted = false;
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            this.edition = Math.max(l, this.edition);
            this.consecutiveCollisions = 0;
            if (lastContentWasMetadata == this.isMetadata && hisData != null && codec == this.compressionCodec) {
                try {
                    byte[] myData = BucketTools.toByteArray(this.data);
                    if (Arrays.equals(myData, hisData)) {
                        alreadyInserted = true;
                        this.finished = true;
                        this.sbi = null;
                    }
                }
                catch (IOException e) {
                    Logger.error(this, "Could not decode: " + e, (Throwable)e);
                }
            }
            if (this.persistent) {
                this.fetcher = null;
            }
        }
        if (alreadyInserted) {
            this.parent.completedBlock(true, context);
            this.cb.onEncode(this.pubUSK.copy(this.edition), this, context);
            this.insertSucceeded(context, l);
            if (this.freeData) {
                this.data.free();
            }
        } else {
            this.scheduleInsert(context);
        }
    }

    private void insertSucceeded(ClientContext context, long edition) {
        byte[] hintData;
        if (this.ctx.ignoreUSKDatehints) {
            if (logMINOR) {
                Logger.minor(this, "Inserted to edition " + edition);
            }
            this.cb.onSuccess(this, context);
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Inserted to edition " + edition + " - inserting USK date hints...");
        }
        USKDateHint hint = USKDateHint.now();
        MultiPutCompletionCallback m = new MultiPutCompletionCallback(this.cb, this.parent, this.tokenObject, this.persistent, true);
        try {
            hintData = hint.getData(edition).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        FreenetURI[] hintURIs = hint.getInsertURIs(this.privUSK);
        boolean added = false;
        for (FreenetURI uri : hintURIs) {
            try {
                RandomAccessBucket bucket = BucketTools.makeImmutableBucket(context.getBucketFactory(this.persistent), hintData);
                SingleBlockInserter sb = new SingleBlockInserter(this.parent, bucket, -1, uri, this.ctx, this.realTimeFlag, m, false, this.sourceLength, this.token, true, true, null, context, this.persistent, true, this.extraInserts, this.cryptoAlgorithm, this.forceCryptoKey);
                Logger.normal(this, "Inserting " + uri + " with " + sb + " for insert of " + this.pubUSK);
                m.add(sb);
                sb.schedule(context);
                added = true;
            }
            catch (IOException e) {
                Logger.error(this, "Unable to insert USK date hints due to disk I/O error: " + e, (Throwable)e);
                if (added) continue;
                this.cb.onFailure(new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e, this.pubUSK.getSSK(edition).getURI()), this, context);
                return;
            }
            catch (InsertException e) {
                Logger.error(this, "Unable to insert USK date hints due to error: " + e, (Throwable)e);
                if (added) continue;
                this.cb.onFailure(e, this, context);
                return;
            }
        }
        this.cb.onTransition(this, m, context);
        m.arm(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleInsert(ClientContext context) {
        long edNo = Math.max(this.edition, context.uskManager.lookupLatestSlot(this.pubUSK) + 1L);
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            if (this.finished) {
                return;
            }
            this.edition = edNo;
            if (logMINOR) {
                Logger.minor(this, "scheduling insert for " + this.pubUSK.getURI() + ' ' + this.edition);
            }
            this.sbi = new SingleBlockInserter(this.parent, this.data, this.compressionCodec, this.privUSK.getInsertableSSK(this.edition).getInsertURI(), this.ctx, this.realTimeFlag, this, this.isMetadata, this.sourceLength, this.token, false, true, this.tokenObject, context, this.persistent, false, this.extraInserts, this.cryptoAlgorithm, this.forceCryptoKey);
        }
        try {
            this.sbi.schedule(context);
        }
        catch (InsertException e) {
            USKInserter uSKInserter2 = this;
            synchronized (uSKInserter2) {
                this.finished = true;
            }
            if (this.freeData) {
                this.data.free();
                uSKInserter2 = this;
                synchronized (uSKInserter2) {
                    this.data = null;
                }
            }
            this.cb.onFailure(e, this, context);
        }
    }

    @Override
    public synchronized void onSuccess(ClientPutState state, ClientContext context) {
        FreenetURI realURI;
        USK newEdition = this.pubUSK.copy(this.edition);
        this.finished = true;
        this.sbi = null;
        FreenetURI targetURI = this.pubUSK.getSSK(this.edition).getURI();
        if (!targetURI.equals(realURI = ((SingleBlockInserter)state).getURI(context))) {
            Logger.error(this, "URI should be " + targetURI + " actually is " + realURI);
        } else {
            if (logMINOR) {
                Logger.minor(this, "URI should be " + targetURI + " actually is " + realURI);
            }
            context.uskManager.updateKnownGood(this.pubUSK, this.edition, context);
        }
        if (this.freeData) {
            this.data.free();
            this.data = null;
        }
        this.cb.onEncode(newEdition, this, context);
        this.insertSucceeded(context, this.edition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(InsertException e, ClientPutState state, ClientContext context) {
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            this.sbi = null;
            if (e.getMode() == InsertException.InsertExceptionMode.COLLISION) {
                ++this.edition;
                ++this.consecutiveCollisions;
                if ((long)this.consecutiveCollisions > 10L) {
                    this.scheduleFetcher(context);
                } else {
                    this.scheduleInsert(context);
                }
            } else {
                Bucket d = null;
                USKInserter uSKInserter2 = this;
                synchronized (uSKInserter2) {
                    this.finished = true;
                    if (this.freeData) {
                        d = this.data;
                        this.data = null;
                    }
                }
                if (this.freeData) {
                    d.free();
                }
                this.cb.onFailure(e, state, context);
            }
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public USKInserter(BaseClientPutter parent, Bucket data, short compressionCodec, FreenetURI uri, InsertContext ctx, PutCompletionCallback cb, boolean isMetadata, int sourceLength, int token, boolean addToParent, Object tokenObject, ClientContext context, boolean freeData, boolean persistent, boolean realTimeFlag, int extraInserts, byte cryptoAlgorithm, byte[] forceCryptoKey) throws MalformedURLException {
        this.hashCode = super.hashCode();
        this.tokenObject = tokenObject;
        this.persistent = persistent;
        this.parent = parent;
        this.data = data;
        this.compressionCodec = compressionCodec;
        this.ctx = ctx;
        this.cb = cb;
        this.isMetadata = isMetadata;
        this.sourceLength = sourceLength;
        this.token = token;
        if (addToParent) {
            parent.addMustSucceedBlocks(1);
            parent.notifyClients(context);
        }
        this.privUSK = InsertableUSK.createInsertable(uri, persistent);
        this.pubUSK = this.privUSK.getUSK();
        this.edition = this.pubUSK.suggestedEdition;
        this.freeData = freeData;
        this.extraInserts = extraInserts;
        this.cryptoAlgorithm = cryptoAlgorithm;
        this.forceCryptoKey = forceCryptoKey;
        this.realTimeFlag = realTimeFlag;
    }

    protected USKInserter() {
        this.hashCode = 0;
        this.tokenObject = null;
        this.persistent = false;
        this.parent = null;
        this.data = null;
        this.compressionCodec = 0;
        this.ctx = null;
        this.cb = null;
        this.isMetadata = false;
        this.sourceLength = 0;
        this.token = 0;
        this.privUSK = null;
        this.pubUSK = null;
        this.edition = 0L;
        this.freeData = false;
        this.extraInserts = 0;
        this.cryptoAlgorithm = 0;
        this.forceCryptoKey = null;
        this.realTimeFlag = false;
    }

    @Override
    public BaseClientPutter getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ClientContext context) {
        USKFetcherTag tag;
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
            tag = this.fetcher;
            this.fetcher = null;
        }
        if (tag != null) {
            tag.cancel(context);
        }
        if (this.sbi != null) {
            this.sbi.cancel(context);
        }
        if (this.freeData) {
            if (this.data == null) {
                Logger.error(this, "data == null in cancel() on " + this, (Throwable)new Exception("error"));
            } else {
                this.data.free();
                uSKInserter = this;
                synchronized (uSKInserter) {
                    this.data = null;
                }
            }
        }
        this.cb.onFailure(new InsertException(InsertException.InsertExceptionMode.CANCELLED), this, context);
    }

    @Override
    public void onFailure(ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Fetcher failed to find the given edition or any later edition on " + this);
        }
        this.scheduleInsert(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCancelled(ClientContext context) {
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            this.fetcher = null;
            if (this.finished) {
                return;
            }
        }
        Logger.error(this, "Unexpected onCancelled()", (Throwable)new Exception("error"));
        this.cancel(context);
    }

    @Override
    public void onEncode(BaseClientKey key, ClientPutState state, ClientContext context) {
    }

    @Override
    public void onTransition(ClientPutState oldState, ClientPutState newState, ClientContext context) {
        Logger.error(this, "Got onTransition(" + oldState + ',' + newState + ')');
    }

    @Override
    public void onMetadata(Metadata m, ClientPutState state, ClientContext context) {
        Logger.error(this, "Got onMetadata(" + m + ',' + state + ')');
    }

    @Override
    public void onBlockSetFinished(ClientPutState state, ClientContext context) {
    }

    @Override
    public Object getToken() {
        return this.tokenObject;
    }

    @Override
    public void onFetchable(ClientPutState state) {
    }

    @Override
    public short getPollingPriorityNormal() {
        return this.parent.getPriorityClass();
    }

    @Override
    public short getPollingPriorityProgress() {
        return this.parent.getPriorityClass();
    }

    @Override
    public void onMetadata(Bucket meta, ClientPutState state, ClientContext context) {
        Logger.error(this, "onMetadata on " + this + " from " + state, (Throwable)new Exception("error"));
        meta.free();
    }

    @Override
    public void onResume(ClientContext context) throws InsertException, ResumeFailedException {
        if (this.resumed) {
            return;
        }
        this.resumed = true;
        if (this.data != null) {
            this.data.onResume(context);
        }
        if (this.cb != null && this.cb != this.parent) {
            this.cb.onResume(context);
        }
        if (this.fetcher != null) {
            this.fetcher.onResume(context);
        }
        if (this.sbi != null) {
            this.sbi.onResume(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onShutdown(ClientContext context) {
        SingleBlockInserter sbi;
        USKInserter uSKInserter = this;
        synchronized (uSKInserter) {
            sbi = this.sbi;
        }
        if (sbi != null) {
            sbi.onShutdown(context);
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

