/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.clients.http.ExternalLinkToadlet;
import freenet.io.AddressTracker;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.Peer;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.node.NodeIPDetector;
import freenet.node.OpennetManager;
import freenet.node.PeerNode;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.node.useralerts.ProxyUserAlert;
import freenet.node.useralerts.SimpleUserAlert;
import freenet.pluginmanager.DetectedIP;
import freenet.pluginmanager.ForwardPort;
import freenet.pluginmanager.ForwardPortCallback;
import freenet.pluginmanager.ForwardPortStatus;
import freenet.pluginmanager.FredPlugin;
import freenet.pluginmanager.FredPluginIPDetector;
import freenet.pluginmanager.FredPluginPortForward;
import freenet.support.HTMLEncoder;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.transport.ip.IPUtil;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class IPDetectorPluginManager
implements ForwardPortCallback {
    private static boolean logMINOR;
    private static boolean logDEBUG;
    private final NodeIPDetector detector;
    private final Node node;
    FredPluginIPDetector[] plugins;
    FredPluginPortForward[] portForwardPlugins;
    private final MyUserAlert noConnectionAlert;
    private final MyUserAlert symmetricAlert;
    private final MyUserAlert portRestrictedAlert;
    private final MyUserAlert restrictedAlert;
    private short connectionType;
    private ProxyUserAlert proxyAlert;
    private final PortForwardAlert portForwardAlert;
    private boolean started;
    private HashMap<FredPluginIPDetector, DetectorRunner> runners = new HashMap();
    private HashSet<FredPluginIPDetector> failedRunners = new HashSet();
    private long lastDetectAttemptEndedTime;
    private long firstTimeUrgent;
    private SimpleUserAlert noConnectivityAlert;

    IPDetectorPluginManager(Node node, NodeIPDetector detector) {
        this.plugins = new FredPluginIPDetector[0];
        this.portForwardPlugins = new FredPluginPortForward[0];
        this.node = node;
        this.detector = detector;
        this.noConnectionAlert = new MyUserAlert(this.l10n("noConnectivityTitle"), this.l10n("noConnectivity"), true, 1);
        this.symmetricAlert = new MyUserAlert(this.l10n("symmetricTitle"), this.l10n("symmetric"), true, 1);
        this.portRestrictedAlert = new MyUserAlert(this.l10n("portRestrictedTitle"), this.l10n("portRestricted"), true, 2);
        this.restrictedAlert = new MyUserAlert(this.l10n("restrictedTitle"), this.l10n("restricted"), false, 3);
        this.portForwardAlert = new PortForwardAlert();
    }

    public int[] getUDPPortsNotForwarded() {
        AddressTracker.Status opennetStatus;
        OpennetManager om = this.node.getOpennet();
        AddressTracker.Status darknetStatus = this.node.peers.anyDarknetPeers() ? this.node.darknetCrypto.getDetectedConnectivityStatus() : AddressTracker.Status.DONT_KNOW;
        AddressTracker.Status status = opennetStatus = om == null ? AddressTracker.Status.DONT_KNOW : om.crypto.getDetectedConnectivityStatus();
        if (om == null || opennetStatus.ordinal() >= AddressTracker.Status.DONT_KNOW.ordinal()) {
            if (darknetStatus.ordinal() >= AddressTracker.Status.DONT_KNOW.ordinal()) {
                return new int[0];
            }
            return new int[]{(darknetStatus.ordinal() < AddressTracker.Status.MAYBE_NATED.ordinal() ? -1 : 1) * this.node.getDarknetPortNumber()};
        }
        if (darknetStatus.ordinal() >= AddressTracker.Status.DONT_KNOW.ordinal()) {
            return new int[]{(opennetStatus.ordinal() < AddressTracker.Status.MAYBE_NATED.ordinal() ? -1 : 1) * om.crypto.portNumber};
        }
        return new int[]{(darknetStatus.ordinal() < AddressTracker.Status.MAYBE_NATED.ordinal() ? -1 : 1) * this.node.getDarknetPortNumber(), (opennetStatus.ordinal() < AddressTracker.Status.MAYBE_NATED.ordinal() ? -1 : 1) * om.crypto.portNumber};
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("IPDetectorPluginManager." + key);
    }

    public String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("IPDetectorPluginManager." + key, new String[]{pattern}, new String[]{value});
    }

    public String l10n(String key, String[] patterns, String[] values) {
        return NodeL10n.getBase().getString("IPDetectorPluginManager." + key, patterns, values);
    }

    void start() {
        this.proxyAlert = new ProxyUserAlert(this.node.clientCore.alerts, false);
        this.node.clientCore.alerts.register(this.portForwardAlert);
        this.started = true;
        this.tryMaybeRun();
    }

    private void tryMaybeRun() {
        try {
            this.maybeRun();
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
        }
        this.node.getTicker().queueTimedJob(new Runnable(){

            @Override
            public void run() {
                Logger.OSThread.logPID(this);
                IPDetectorPluginManager.this.tryMaybeRun();
            }
        }, TimeUnit.MINUTES.toMillis(1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDetectorPlugin(FredPluginIPDetector d) {
        if (d == null) {
            throw new NullPointerException();
        }
        IPDetectorPluginManager iPDetectorPluginManager = this;
        synchronized (iPDetectorPluginManager) {
            this.lastDetectAttemptEndedTime = -1L;
            this.plugins = Arrays.copyOf(this.plugins, this.plugins.length + 1);
            this.plugins[this.plugins.length - 1] = d;
        }
        if (logMINOR) {
            Logger.minor(this, "Registering a new plugin : " + d);
        }
        this.maybeRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDetectorPlugin(FredPluginIPDetector d) {
        DetectorRunner runningDetector;
        IPDetectorPluginManager iPDetectorPluginManager = this;
        synchronized (iPDetectorPluginManager) {
            int count = 0;
            for (FredPluginIPDetector plugin : this.plugins) {
                if (plugin != d) continue;
                ++count;
            }
            if (count == 0) {
                return;
            }
            FredPluginIPDetector[] newPlugins = new FredPluginIPDetector[this.plugins.length - count];
            int x = 0;
            for (FredPluginIPDetector plugin : this.plugins) {
                if (plugin == d) continue;
                newPlugins[x++] = plugin;
            }
            this.plugins = newPlugins;
            runningDetector = this.runners.get(d);
        }
        if (runningDetector != null) {
            runningDetector.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeRun() {
        if (!this.started) {
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Maybe running IP detection plugins", (Throwable)new Exception("debug"));
        }
        PeerNode[] peers = this.node.getPeerNodes();
        PeerNode[] conns = this.node.getConnectedPeers();
        int peerCount = this.node.peers.countValidPeers();
        FreenetInetAddress[] nodeAddrs = this.detector.getPrimaryIPAddress(true);
        long now = System.currentTimeMillis();
        IPDetectorPluginManager iPDetectorPluginManager = this;
        synchronized (iPDetectorPluginManager) {
            if (this.plugins.length == 0) {
                if (logMINOR) {
                    Logger.minor(this, "No IP detection plugins");
                }
                this.detector.hasDetectedPM();
                return;
            }
            if (this.runners.size() == this.plugins.length) {
                if (logMINOR) {
                    Logger.minor(this, "Already running all IP detection plugins");
                }
                return;
            }
            if (this.failedRunners.size() == this.plugins.length) {
                if (now - this.lastDetectAttemptEndedTime < TimeUnit.MINUTES.toMillis(5L)) {
                    if (logMINOR) {
                        Logger.minor(this, "Last detect failed less than 5 minutes ago");
                    }
                    return;
                }
                if (logMINOR) {
                    Logger.minor(this, "Last detect failed, redetecting");
                }
                this.startDetect();
                return;
            }
            if (this.detector.hasDirectlyDetectedIP() && !this.shouldDetectDespiteRealIP(now, conns, nodeAddrs)) {
                return;
            }
            if (peerCount == 0) {
                if (this.shouldDetectNoPeers(now)) {
                    this.startDetect();
                }
            } else if (this.shouldDetectWithPeers(now, peers, conns, nodeAddrs)) {
                this.startDetect();
            }
        }
    }

    private boolean shouldDetectNoPeers(long now) {
        if (now - this.lastDetectAttemptEndedTime < TimeUnit.HOURS.toMillis(6L)) {
            if (logMINOR) {
                Logger.minor(this, "No peers but detected less than 6 hours ago");
            }
            return false;
        }
        return true;
    }

    private boolean shouldDetectWithPeers(long now, PeerNode[] peers, PeerNode[] conns, FreenetInetAddress[] nodeAddrs) {
        boolean detect = false;
        int realConnections = 0;
        int realDisconnected = 0;
        int recentlyConnected = 0;
        if (logMINOR) {
            Logger.minor(this, "Checking whether should detect with " + peers.length + " peers and " + conns.length + " conns, counting peers...");
        }
        for (PeerNode p : peers) {
            InetAddress addr;
            FreenetInetAddress a;
            Peer peer;
            if (p.isDisabled() || (peer = p.getPeer()) == null || (a = peer.getFreenetAddress()) == null || (addr = a.getAddress(false)) != null && !IPUtil.isValidAddress(addr, false)) continue;
            boolean skip = false;
            for (FreenetInetAddress nodeAddr : nodeAddrs) {
                if (!a.equals(nodeAddr)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            if (p.isConnected()) {
                ++realConnections;
                continue;
            }
            ++realDisconnected;
            if (now - p.lastReceivedPacketTime() >= TimeUnit.MINUTES.toMillis(5L)) continue;
            ++recentlyConnected;
        }
        if (logMINOR) {
            Logger.minor(this, "Real connections: " + realConnections + " disconnected " + realDisconnected);
        }
        if (realConnections == 0 && realDisconnected > 0) {
            if (this.firstTimeUrgent <= 0L) {
                this.firstTimeUrgent = now;
            }
            if (this.detector.oldIPAddress != null && this.detector.oldIPAddress.isRealInternetAddress(false, false, false)) {
                if (logDEBUG) {
                    Logger.debug(this, "Detecting in 2 minutes as have oldIPAddress");
                }
                if (now - this.firstTimeUrgent > TimeUnit.MINUTES.toMillis(2L)) {
                    detect = true;
                    this.firstTimeUrgent = now;
                    if (logMINOR) {
                        Logger.minor(this, "Detecting now as 2 minutes are up (have oldIPAddress)");
                    }
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Detecting now (no oldIPAddress)");
                }
                detect = true;
            }
        } else {
            if (realConnections == 0 && realDisconnected == 0) {
                return this.shouldDetectNoPeers(now);
            }
            if (logDEBUG) {
                Logger.minor(this, "Not urgent; conns=" + conns.length + ", peers=" + peers.length);
            }
            this.firstTimeUrgent = 0L;
        }
        if (realConnections == 0 && realDisconnected > 0 && recentlyConnected > 2 && now - this.lastDetectAttemptEndedTime > TimeUnit.MINUTES.toMillis(6L)) {
            return true;
        }
        if (this.detector.maybeSymmetric && this.lastDetectAttemptEndedTime <= 0L) {
            return true;
        }
        if (detect) {
            if (now - this.lastDetectAttemptEndedTime < TimeUnit.HOURS.toMillis(1L)) {
                if (logMINOR) {
                    Logger.minor(this, "Only trying once per hour");
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean shouldDetectDespiteRealIP(long now, PeerNode[] peers, FreenetInetAddress[] nodeAddrs) {
        if (now - this.lastDetectAttemptEndedTime < TimeUnit.HOURS.toMillis(12L)) {
            if (logMINOR) {
                Logger.minor(this, "Node has directly detected IP and we have checked less than 12 hours ago");
            }
            return false;
        }
        if (logMINOR) {
            Logger.minor(this, "Checking whether should detect despite real IP...");
        }
        HashSet<InetAddress> addressesConnected = null;
        boolean hasOldPeers = false;
        for (PeerNode p : peers) {
            long l;
            if (!p.isConnected() && now - p.lastReceivedPacketTime() >= TimeUnit.HOURS.toMillis(24L)) continue;
            Peer peer = p.getPeer();
            if (peer != null) {
                InetAddress addr = peer.getAddress(false);
                if (p.isConnected() && addr != null && IPUtil.isValidAddress(peer.getAddress(), false)) {
                    boolean internal = false;
                    for (FreenetInetAddress nodeAddr : nodeAddrs) {
                        if (!addr.equals(nodeAddr.getAddress(false))) continue;
                        internal = true;
                        break;
                    }
                    if (!internal) {
                        if (addressesConnected == null) {
                            addressesConnected = new HashSet<InetAddress>();
                        }
                        addressesConnected.add(addr);
                        if (addressesConnected.size() > 2) {
                            if (logMINOR) {
                                Logger.minor(this, "Node has directly detected IP and has connected to 3 real IPs");
                            }
                            return false;
                        }
                    }
                }
            }
            if ((l = p.getPeerAddedTime()) > 0L && now - l <= TimeUnit.MINUTES.toMillis(30L)) continue;
            hasOldPeers = true;
        }
        if (!hasOldPeers) {
            if (logMINOR) {
                Logger.minor(this, "Not detecting as less than 30 minutes old");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDetect() {
        if (logMINOR) {
            Logger.minor(this, "Detecting...");
        }
        IPDetectorPluginManager iPDetectorPluginManager = this;
        synchronized (iPDetectorPluginManager) {
            this.failedRunners.clear();
            for (FredPluginIPDetector plugin : this.plugins) {
                if (this.runners.containsKey(plugin)) continue;
                DetectorRunner d = new DetectorRunner(plugin);
                this.runners.put(plugin, d);
                this.node.executor.execute(d, "Plugin detector runner for " + plugin.getClass());
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.plugins.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPortForwardPlugin(FredPluginPortForward forward) {
        if (forward == null) {
            throw new NullPointerException();
        }
        IPDetectorPluginManager iPDetectorPluginManager = this;
        synchronized (iPDetectorPluginManager) {
            this.portForwardPlugins = Arrays.copyOf(this.portForwardPlugins, this.portForwardPlugins.length + 1);
            this.portForwardPlugins[this.portForwardPlugins.length - 1] = forward;
        }
        if (logMINOR) {
            Logger.minor(this, "Registering a new port forward plugin : " + forward);
        }
        forward.onChangePublicPorts(this.node.getPublicInterfacePorts(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPortForwardPlugin(FredPluginPortForward forward) {
        IPDetectorPluginManager iPDetectorPluginManager = this;
        synchronized (iPDetectorPluginManager) {
            int count = 0;
            for (FredPluginPortForward portForwardPlugin : this.portForwardPlugins) {
                if (portForwardPlugin != forward) continue;
                ++count;
            }
            if (count == 0) {
                return;
            }
            FredPluginPortForward[] newPlugins = new FredPluginPortForward[this.portForwardPlugins.length - count];
            int x = 0;
            for (FredPluginPortForward portForwardPlugin : this.portForwardPlugins) {
                if (portForwardPlugin == forward) continue;
                newPlugins[x++] = portForwardPlugin;
            }
            this.portForwardPlugins = newPlugins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPortChange(final Set<ForwardPort> newPorts) {
        FredPluginPortForward[] fredPluginPortForwardArray = this;
        synchronized (this) {
            FredPluginPortForward[] plugins = this.portForwardPlugins;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (final FredPluginPortForward plugin : plugins) {
                this.node.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            plugin.onChangePublicPorts(newPorts, IPDetectorPluginManager.this);
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Changing public ports list on " + plugin + " threw: " + t, t);
                        }
                    }
                }, "Notify " + plugin + " of ports list change");
            }
            return;
        }
    }

    @Override
    public void portForwardStatus(Map<ForwardPort, ForwardPortStatus> statuses) {
        Set<ForwardPort> currentPorts = this.node.getPublicInterfacePorts();
        for (ForwardPort p : currentPorts) {
            ForwardPortStatus status = statuses.get(p);
            if (status == null) continue;
            if (status.status == 3) {
                Logger.normal(this, "Succeeded forwarding " + p.name + " port " + p.portNumber + " for " + p.protocol + " - port forward definitely succeeded " + status.reasonString);
                continue;
            }
            if (status.status == 2) {
                Logger.normal(this, "Probably succeeded forwarding " + p.name + " port " + p.portNumber + " for " + p.protocol + " - port forward probably succeeded " + status.reasonString);
                continue;
            }
            if (status.status == 1) {
                Logger.normal(this, "Maybe succeeded forwarding " + p.name + " port " + p.portNumber + " for " + p.protocol + " - port forward may have succeeded but strongly recommend out of band verification " + status.reasonString);
                continue;
            }
            if (status.status == -2) {
                Logger.error(this, "Failed forwarding " + p.name + " port " + p.portNumber + " for " + p.protocol + " - port forward definitely failed " + status.reasonString);
                continue;
            }
            if (status.status != -1) continue;
            Logger.error(this, "Probably failed forwarding " + p.name + " port " + p.portNumber + " for " + p.protocol + " - port forward probably failed " + status.reasonString);
        }
        this.node.executor.execute(new Runnable(){

            @Override
            public void run() {
                IPDetectorPluginManager.this.maybeRun();
            }
        }, "Redetect IP after port forward changed");
    }

    public synchronized boolean hasDetectors() {
        return this.plugins.length > 0;
    }

    public void addConnectionTypeBox(HTMLNode contentNode) {
        if (this.node.clientCore == null) {
            return;
        }
        if (this.node.clientCore.alerts == null) {
            return;
        }
        if (this.proxyAlert == null) {
            Logger.error(this, "start() not called yet?", (Throwable)new Exception("debug"));
            return;
        }
        if (this.proxyAlert.isValid()) {
            contentNode.addChild(this.node.clientCore.alerts.renderAlert(this.proxyAlert));
        }
    }

    public boolean hasJSTUN() {
        return this.node.pluginManager.isPluginLoadedOrLoadingOrWantLoad("JSTUN");
    }

    static /* synthetic */ HashMap access$1400(IPDetectorPluginManager x0) {
        return x0.runners;
    }

    static {
        Logger.registerClass(IPDetectorPluginManager.class);
    }

    public class DetectorRunner
    implements Runnable {
        final FredPluginIPDetector plugin;

        public DetectorRunner(FredPluginIPDetector detector) {
            this.plugin = detector;
        }

        public void kill() {
            ((IPDetectorPluginManager)IPDetectorPluginManager.this).node.pluginManager.killPlugin((FredPlugin)((Object)this.plugin), 0L);
        }

        @Override
        public void run() {
            Logger.OSThread.logPID(this);
            try {
                this.realRun();
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void realRun() {
            if (logMINOR) {
                Logger.minor(this, "Running plugin detection");
            }
            try {
                void var6_17;
                ArrayList<DetectedIP> v = new ArrayList<DetectedIP>();
                DetectedIP[] detected = null;
                try {
                    detected = this.plugin.getAddress();
                }
                catch (Throwable throwable) {
                    Logger.error(this, "Caught " + throwable, throwable);
                }
                if (detected != null) {
                    for (DetectedIP detectedIP : detected) {
                        v.add(detectedIP);
                    }
                }
                IPDetectorPluginManager iPDetectorPluginManager = IPDetectorPluginManager.this;
                // MONITORENTER : iPDetectorPluginManager
                IPDetectorPluginManager.this.lastDetectAttemptEndedTime = System.currentTimeMillis();
                boolean failed = false;
                if (v.isEmpty()) {
                    if (logMINOR) {
                        Logger.minor(this, "No IPs found");
                    }
                    failed = true;
                } else {
                    failed = true;
                    for (DetectedIP detectedIP : v) {
                        if (logMINOR) {
                            Logger.minor(this, "Detected IP: " + detectedIP + " for " + this.plugin);
                        }
                        if (detectedIP.publicAddress == null || !IPUtil.isValidAddress(detectedIP.publicAddress, false)) continue;
                        if (logMINOR) {
                            Logger.minor(this, "Address checked out");
                        }
                        failed = false;
                    }
                }
                if (failed) {
                    if (logMINOR) {
                        Logger.minor(this, "Failed");
                    }
                    IPDetectorPluginManager.this.failedRunners.add(this.plugin);
                    // MONITOREXIT : iPDetectorPluginManager
                    return;
                }
                // MONITOREXIT : iPDetectorPluginManager
                DetectedIP[] detectedIPArray = v.toArray(new DetectedIP[v.size()]);
                int countOpen = 0;
                int countFullCone = 0;
                boolean bl = false;
                int countPortRestricted = 0;
                int countSymmetric = 0;
                int countClosed = 0;
                block30: for (DetectedIP d : detectedIPArray) {
                    Logger.normal(this, "Detected IP: " + d.publicAddress + " : type " + d.natType);
                    System.out.println("Detected IP: " + d.publicAddress + " : type " + d.natType);
                    switch (d.natType) {
                        case 3: {
                            ++countFullCone;
                            continue block30;
                        }
                        case 2: {
                            ++countOpen;
                            continue block30;
                        }
                        case 8: {
                            ++countClosed;
                            continue block30;
                        }
                        case 1: {
                            continue block30;
                        }
                        case 4: {
                            ++var6_17;
                            continue block30;
                        }
                        case 5: {
                            ++countPortRestricted;
                            continue block30;
                        }
                        case 6: 
                        case 7: {
                            ++countSymmetric;
                            continue block30;
                        }
                    }
                }
                if (countClosed > 0 && countOpen + countFullCone + var6_17 + countPortRestricted + countSymmetric == 0) {
                    IPDetectorPluginManager.this.proxyAlert.setAlert(IPDetectorPluginManager.this.noConnectionAlert);
                    IPDetectorPluginManager.this.proxyAlert.isValid(true);
                    IPDetectorPluginManager.this.connectionType = (short)8;
                } else if (countSymmetric > 0 && countOpen + countFullCone + var6_17 + countPortRestricted == 0) {
                    IPDetectorPluginManager.this.proxyAlert.setAlert(IPDetectorPluginManager.this.symmetricAlert);
                    IPDetectorPluginManager.this.proxyAlert.isValid(true);
                    IPDetectorPluginManager.this.connectionType = (short)6;
                } else if (countPortRestricted > 0 && countOpen + countFullCone + var6_17 == 0) {
                    IPDetectorPluginManager.this.proxyAlert.setAlert(IPDetectorPluginManager.this.portRestrictedAlert);
                    IPDetectorPluginManager.this.proxyAlert.isValid(true);
                    IPDetectorPluginManager.this.connectionType = (short)5;
                } else if (var6_17 > 0 && countOpen + countFullCone == 0) {
                    IPDetectorPluginManager.this.proxyAlert.setAlert(IPDetectorPluginManager.this.restrictedAlert);
                    IPDetectorPluginManager.this.proxyAlert.isValid(true);
                    IPDetectorPluginManager.this.connectionType = (short)4;
                } else if (countFullCone > 0 && countOpen == 0) {
                    IPDetectorPluginManager.this.proxyAlert.isValid(false);
                    IPDetectorPluginManager.this.connectionType = (short)3;
                } else if (countOpen > 0) {
                    IPDetectorPluginManager.this.proxyAlert.isValid(false);
                }
                IPDetectorPluginManager.this.detector.processDetectedIPs(detectedIPArray);
                if (IPDetectorPluginManager.this.connectionType == 8) {
                    SimpleUserAlert toRegister = null;
                    DetectorRunner detectorRunner = this;
                    // MONITORENTER : detectorRunner
                    if (IPDetectorPluginManager.this.noConnectivityAlert == null) {
                        toRegister = new SimpleUserAlert(false, IPDetectorPluginManager.this.l10n("noConnectivityTitle"), IPDetectorPluginManager.this.l10n("noConnectivity"), IPDetectorPluginManager.this.l10n("noConnectivityShort"), 1);
                        IPDetectorPluginManager.this.noConnectivityAlert = toRegister;
                    }
                    // MONITOREXIT : detectorRunner
                    if (toRegister == null) return;
                    ((IPDetectorPluginManager)IPDetectorPluginManager.this).node.clientCore.alerts.register(toRegister);
                    return;
                }
                DetectorRunner detectorRunner = this;
                // MONITORENTER : detectorRunner
                SimpleUserAlert toKill = IPDetectorPluginManager.this.noConnectivityAlert;
                IPDetectorPluginManager.this.noConnectivityAlert = null;
                // MONITOREXIT : detectorRunner
                if (toKill == null) return;
                ((IPDetectorPluginManager)IPDetectorPluginManager.this).node.clientCore.alerts.unregister(toKill);
                return;
            }
            finally {
                IPDetectorPluginManager iPDetectorPluginManager = IPDetectorPluginManager.this;
            }
        }
    }

    public class MyUserAlert
    extends AbstractUserAlert {
        final boolean suggestPortForward;
        private int[] portsNotForwarded;

        public MyUserAlert(String title, String text, boolean suggestPortForward, short code) {
            super(false, title, text, title, null, code, true, NodeL10n.getBase().getString("UserAlert.hide"), false, null);
            this.suggestPortForward = suggestPortForward;
            this.portsNotForwarded = new int[0];
        }

        @Override
        public HTMLNode getHTMLText() {
            HTMLNode div = new HTMLNode("div");
            div.addChild("#", super.getText());
            if (this.suggestPortForward) {
                if (this.portsNotForwarded.length == 1) {
                    NodeL10n.getBase().addL10nSubstitution(div, "IPDetectorPluginManager.suggestForwardPortWithLink", new String[]{"link", "port"}, new HTMLNode[]{HTMLNode.link(ExternalLinkToadlet.escape("http://wiki.freenetproject.org/FirewallAndRouterIssues")), HTMLNode.text(this.portsNotForwarded[0])});
                } else {
                    NodeL10n.getBase().addL10nSubstitution(div, "IPDetectorPluginManager.suggestForwardTwoPortsWithLink", new String[]{"link", "port1", "port2"}, new HTMLNode[]{HTMLNode.link(ExternalLinkToadlet.escape("http://wiki.freenetproject.org/FirewallAndRouterIssues")), HTMLNode.text(this.portsNotForwarded[0]), HTMLNode.text(this.portsNotForwarded[1])});
                }
            }
            return div;
        }

        @Override
        public String getText() {
            if (!this.suggestPortForward) {
                return super.getText();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(super.getText());
            if (this.portsNotForwarded.length == 1) {
                sb.append(IPDetectorPluginManager.this.l10n("suggestForwardPort", "port", Integer.toString(Math.abs(this.portsNotForwarded[0]))));
            } else if (this.portsNotForwarded.length >= 2) {
                sb.append(IPDetectorPluginManager.this.l10n("suggestForwardTwoPorts", new String[]{"port1", "port2"}, new String[]{Integer.toString(Math.abs(this.portsNotForwarded[0])), Integer.toString(Math.abs(this.portsNotForwarded[1]))}));
                if (this.portsNotForwarded.length > 2) {
                    Logger.error(this, "Not able to tell user about more than 2 ports to forward! (" + this.portsNotForwarded.length + ")");
                }
            }
            return sb.toString();
        }

        @Override
        public void isValid(boolean validity) {
            this.valid = validity;
        }

        @Override
        public boolean isValid() {
            this.portsNotForwarded = IPDetectorPluginManager.this.getUDPPortsNotForwarded();
            return this.valid && this.portsNotForwarded.length > 0;
        }

        @Override
        public void onDismiss() {
            this.valid = false;
        }

        @Override
        public boolean userCanDismiss() {
            return false;
        }
    }

    public class PortForwardAlert
    extends AbstractUserAlert {
        private int[] portsNotForwarded;
        private short maxPriorityShown;
        private int maxPortsLength;
        private boolean valid;

        @Override
        public String anchor() {
            return "port-forward:" + super.hashCode();
        }

        @Override
        public String dismissButtonText() {
            return NodeL10n.getBase().getString("UserAlert.hide");
        }

        @Override
        public HTMLNode getHTMLText() {
            String keySuffix;
            HTMLNode div = new HTMLNode("div");
            String url = ExternalLinkToadlet.escape(HTMLEncoder.encode(IPDetectorPluginManager.this.l10n("portForwardHelpURL")));
            boolean maybeForwarded = true;
            for (int portNotForwarded : this.portsNotForwarded) {
                if (portNotForwarded >= 0) continue;
                maybeForwarded = false;
            }
            String string = keySuffix = maybeForwarded ? "MaybeForwarded" : "NotForwarded";
            if (this.portsNotForwarded.length == 1) {
                NodeL10n.getBase().addL10nSubstitution(div, "IPDetectorPluginManager.forwardPort" + keySuffix, new String[]{"port", "link"}, new HTMLNode[]{HTMLNode.text(Math.abs(this.portsNotForwarded[0])), HTMLNode.link(url)});
            } else if (this.portsNotForwarded.length == 2) {
                NodeL10n.getBase().addL10nSubstitution(div, "IPDetectorPluginManager.forwardTwoPorts" + keySuffix, new String[]{"port1", "port2", "link", "connectivity"}, new HTMLNode[]{HTMLNode.text(Math.abs(this.portsNotForwarded[0])), HTMLNode.text(Math.abs(this.portsNotForwarded[1])), HTMLNode.link(url), HTMLNode.link("/connectivity/")});
            } else {
                Logger.error(this, "Unknown number of ports to forward: " + this.portsNotForwarded.length);
            }
            if (this.innerGetPriorityClass() == 1) {
                div.addChild("#", " " + IPDetectorPluginManager.this.l10n("symmetricPS"));
            }
            return div;
        }

        @Override
        public short getPriorityClass() {
            return this.innerGetPriorityClass();
        }

        public short innerGetPriorityClass() {
            if (IPDetectorPluginManager.this.connectionType == 6 || IPDetectorPluginManager.this.connectionType == 7) {
                return 1;
            }
            if (this.portsNotForwarded != null) {
                for (int portNotForwarded : this.portsNotForwarded) {
                    if (portNotForwarded >= 0) continue;
                    return 1;
                }
            }
            return 3;
        }

        @Override
        public String getShortText() {
            String keySuffix;
            String prefix = this.innerGetPriorityClass() == 1 ? IPDetectorPluginManager.this.l10n("seriousConnectionProblems") : IPDetectorPluginManager.this.l10n("connectionProblems");
            prefix = prefix + " ";
            boolean maybeForwarded = true;
            for (int portNotForwarded : this.portsNotForwarded) {
                if (portNotForwarded >= 0) continue;
                maybeForwarded = false;
            }
            String string = keySuffix = maybeForwarded ? "MaybeForwarded" : "NotForwarded";
            if (this.portsNotForwarded.length == 1) {
                return prefix + IPDetectorPluginManager.this.l10n("forwardPortShort" + keySuffix, "port", Integer.toString(Math.abs(this.portsNotForwarded[0])));
            }
            if (this.portsNotForwarded.length == 2) {
                return prefix + IPDetectorPluginManager.this.l10n("forwardTwoPortsShort" + keySuffix, new String[]{"port1", "port2"}, new String[]{Integer.toString(Math.abs(this.portsNotForwarded[0])), Integer.toString(Math.abs(this.portsNotForwarded[1]))});
            }
            Logger.error(this, "Unknown number of ports to forward: " + this.portsNotForwarded.length);
            return "";
        }

        @Override
        public String getText() {
            String keySuffix;
            String url = IPDetectorPluginManager.this.l10n("portForwardHelpURL");
            boolean maybeForwarded = true;
            for (int portNotForwarded : this.portsNotForwarded) {
                if (portNotForwarded >= 0) continue;
                maybeForwarded = false;
            }
            String string = keySuffix = maybeForwarded ? "MaybeForwarded" : "NotForwarded";
            if (this.portsNotForwarded.length == 1) {
                return IPDetectorPluginManager.this.l10n("forwardPort" + keySuffix, new String[]{"port", "link", "/link"}, new String[]{Integer.toString(Math.abs(this.portsNotForwarded[0])), "", " (" + url + ")"});
            }
            if (this.portsNotForwarded.length == 2) {
                return IPDetectorPluginManager.this.l10n("forwardTwoPorts" + keySuffix, new String[]{"port1", "port2", "link", "/link"}, new String[]{Integer.toString(Math.abs(this.portsNotForwarded[0])), Integer.toString(Math.abs(this.portsNotForwarded[1])), "", " (" + url + ")"});
            }
            Logger.error(this, "Unknown number of ports to forward: " + this.portsNotForwarded.length);
            return "";
        }

        @Override
        public String getTitle() {
            return this.getShortText();
        }

        @Override
        public boolean isValid() {
            short prio;
            this.portsNotForwarded = IPDetectorPluginManager.this.getUDPPortsNotForwarded();
            if (this.portsNotForwarded.length > this.maxPortsLength) {
                this.valid = true;
                this.maxPortsLength = this.portsNotForwarded.length;
            }
            if ((prio = this.innerGetPriorityClass()) < this.maxPriorityShown) {
                this.valid = true;
                this.maxPriorityShown = prio;
            }
            if (this.portsNotForwarded.length == 0) {
                return false;
            }
            return this.valid;
        }

        @Override
        public void isValid(boolean validity) {
            this.valid = validity;
        }

        @Override
        public void onDismiss() {
            this.valid = false;
        }

        @Override
        public boolean shouldUnregisterOnDismiss() {
            return false;
        }

        @Override
        public boolean userCanDismiss() {
            return true;
        }

        @Override
        public boolean isEventNotification() {
            return false;
        }
    }
}

