/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.ClientMetadata;
import freenet.client.MetadataUnresolvedException;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutter;
import freenet.client.events.FinishedCompressionEvent;
import freenet.clients.fcp.ClientPutBase;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.IdentifierCollisionException;
import freenet.clients.fcp.NotAllowedException;
import freenet.clients.fcp.PersistentRequestClient;
import freenet.keys.FreenetURI;
import freenet.node.NodeClientCore;
import freenet.node.fcp.ClientPutBase;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.ResumeFailedException;
import java.io.File;
import java.io.IOException;

public class ClientPut
extends ClientPutBase {
    ClientPutter putter;
    private final short uploadFrom;
    private final File origFilename;
    private final FreenetURI targetURI;
    private Bucket data;
    private final ClientMetadata clientMetadata;
    private long finishedSize;
    private final String targetFilename;
    private final boolean binaryBlob;
    private transient boolean compressing;
    public static final short UPLOAD_FROM_DIRECT = 0;
    public static final short UPLOAD_FROM_DISK = 1;
    public static final short UPLOAD_FROM_REDIRECT = 2;

    protected ClientPut() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getTypeName() {
        return "PUT";
    }

    public FreenetURI getFinalURI(ObjectContainer container) {
        container.activate((Object)this.generatedURI, 5);
        return this.generatedURI;
    }

    public boolean isDirect() {
        return this.uploadFrom == 0;
    }

    public File getOrigFilename(ObjectContainer container) {
        if (this.uploadFrom != 1) {
            return null;
        }
        container.activate((Object)this.origFilename, 5);
        return this.origFilename;
    }

    public long getDataSize(ObjectContainer container) {
        if (this.data == null) {
            return this.finishedSize;
        }
        container.activate((Object)this.data, 1);
        return this.data.size();
    }

    public String getMIMEType() {
        return this.clientMetadata.getMIMEType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public COMPRESS_STATE isCompressing(ObjectContainer container) {
        container.activate((Object)this.ctx, 1);
        if (this.ctx.dontCompress) {
            return COMPRESS_STATE.WORKING;
        }
        ClientPut clientPut = this;
        synchronized (clientPut) {
            if (this.progressMessage == null) {
                return COMPRESS_STATE.WAITING;
            }
            if (this.compressing) {
                return COMPRESS_STATE.COMPRESSING;
            }
            return COMPRESS_STATE.WORKING;
        }
    }

    @Override
    public ClientRequest migrate(PersistentRequestClient newClient, ObjectContainer container, NodeClientCore core) throws IdentifierCollisionException, NotAllowedException, IOException, MetadataUnresolvedException, ResumeFailedException {
        ClientContext context = core.clientContext;
        if (this.targetURI != null) {
            container.activate((Object)this.targetURI, Integer.MAX_VALUE);
        }
        if (this.uri != null) {
            container.activate((Object)this.uri, Integer.MAX_VALUE);
        }
        container.activate((Object)this.ctx, Integer.MAX_VALUE);
        this.ctx.onResume();
        File f = this.origFilename;
        if (f != null) {
            container.activate((Object)f, Integer.MAX_VALUE);
            f = new File(f.toString());
            if (!f.exists()) {
                Logger.error(this, "Not migrating insert as data has been deleted");
                return null;
            }
        }
        container.activate((Object)this.clientMetadata, Integer.MAX_VALUE);
        if (this.data != null) {
            container.activate((Object)this.data, Integer.MAX_VALUE);
            if (this.data.size() == 0L) {
                Logger.error(this, "No data migrating insert: " + this.data);
                return null;
            }
        } else {
            Logger.error(this, "Not migrating insert as data has been deleted (or very old download?)");
            return null;
        }
        this.data.onResume(context);
        RandomAccessBucket data = BucketTools.toRandomAccessBucket(this.data, context.getBucketFactory(true));
        byte[] overrideSplitfileKey = null;
        if (this.putter != null) {
            container.activate((Object)this.putter, 1);
            overrideSplitfileKey = this.putter.getSplitfileCryptoKey();
        }
        freenet.clients.fcp.ClientPut put = new freenet.clients.fcp.ClientPut(newClient, this.uri, this.identifier, this.verbosity, this.charset, this.priorityClass, ClientRequest.Persistence.FOREVER, this.clientToken, this.getCHKOnly, this.ctx.dontCompress, this.ctx.maxInsertRetries, ClientPutBase.UploadFrom.getByCode(this.uploadFrom), f, this.clientMetadata.getMIMEType(), data, this.targetURI, this.targetFilename, this.earlyEncode, this.ctx.canWriteClientCache, this.ctx.forkOnCacheable, this.ctx.extraInsertsSingleBlock, this.ctx.extraInsertsSplitfileHeaderBlock, this.isRealTime(container), this.ctx.getCompatibilityMode(), overrideSplitfileKey, this.binaryBlob, core);
        if (this.finished) {
            if (this.putFailedMessage != null) {
                container.activate((Object)this.putFailedMessage, Integer.MAX_VALUE);
                if (this.generatedURI == null) {
                    this.generatedURI = this.putFailedMessage.expectedURI;
                }
            }
            if (this.generatedURI != null) {
                container.activate((Object)this.generatedURI, Integer.MAX_VALUE);
                put.onGeneratedURI(this.generatedURI, null);
            }
            if (this.generatedMetadata != null) {
                container.activate((Object)this.generatedMetadata, Integer.MAX_VALUE);
                this.generatedMetadata.onResume(context);
                put.onGeneratedMetadata(this.generatedMetadata, null);
            }
            if (this.putFailedMessage != null) {
                put.receive(new FinishedCompressionEvent(-1, 0L, 0L), context);
                put.onFailure(this.putFailedMessage.getException(), null);
            } else if (this.succeeded) {
                put.onSuccess(null);
            }
        }
        return put;
    }

    public static enum COMPRESS_STATE {
        WAITING,
        COMPRESSING,
        WORKING;

    }
}

