/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.util.List;
import java.util.Random;

public class ListUtils {
    public static <E> boolean removeBySwapLast(List<E> a, Object o) {
        int idx = a.indexOf(o);
        if (idx == -1) {
            return false;
        }
        ListUtils.removeBySwapLast(a, idx);
        return true;
    }

    public static <E> E removeBySwapLast(List<E> a, int idx) {
        int size = a.size();
        if (idx < 0 || idx >= size) {
            throw new IndexOutOfBoundsException(idx + " out of range [0;" + size + ")");
        }
        E moved = a.remove(size - 1);
        if (idx != size - 1) {
            a.set(idx, moved);
        }
        return moved;
    }

    public static <E> RandomRemoveResult<E> removeRandomBySwapLast(Random random, List<E> a) {
        int size = a.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            E removed = a.remove(0);
            return new RandomRemoveResult<E>(removed, removed);
        }
        int idx = random.nextInt(size);
        E removed = a.get(idx);
        return new RandomRemoveResult<E>(removed, ListUtils.removeBySwapLast(a, idx));
    }

    public static <E> E removeRandomBySwapLastSimple(Random random, List<E> a) {
        int size = a.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return a.remove(0);
        }
        int idx = random.nextInt(size);
        E removed = a.get(idx);
        ListUtils.removeBySwapLast(a, idx);
        return removed;
    }

    public static class RandomRemoveResult<E> {
        public final E removed;
        public final E moved;

        RandomRemoveResult(E removed, E moved) {
            this.removed = removed;
            this.moved = moved;
        }
    }
}

