/*
 * Decompiled with CFR 0.152.
 */
package plugins.Sharesite.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import plugins.Sharesite.common.SmartMap;

public class MapToData {
    private static byte[] intToByteArray(int value) {
        byte[] ret = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return ret;
    }

    private static int byteArrayToInt(byte[] bytes) {
        int ret = (bytes[0] & 0xFF) << 24;
        ret |= (bytes[1] & 0xFF) << 16;
        ret |= (bytes[2] & 0xFF) << 8;
        return ret |= bytes[3] & 0xFF;
    }

    private static byte[] readBytes(ByteArrayInputStream in, int num) throws IOException {
        if (num < 0) {
            throw new IOException();
        }
        if (num > 0x6400000) {
            throw new IOException();
        }
        byte[] ret = new byte[num];
        int got = in.read(ret);
        if (got != num) {
            throw new IOException();
        }
        return ret;
    }

    public static SmartMap dataToMap(byte[] data) {
        if (data == null) {
            return new SmartMap();
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            SmartMap map = new SmartMap();
            String header = new String(MapToData.readBytes(in, 17), "UTF-8");
            if (!header.equals("ShareWiki-db-ver1")) {
                throw new IOException();
            }
            int count = MapToData.byteArrayToInt(MapToData.readBytes(in, 4));
            for (int i = 0; i < count; ++i) {
                int keylen = MapToData.byteArrayToInt(MapToData.readBytes(in, 4));
                String key = new String(MapToData.readBytes(in, keylen), "UTF-8");
                int vallen = MapToData.byteArrayToInt(MapToData.readBytes(in, 4));
                String value = new String(MapToData.readBytes(in, vallen), "UTF-8");
                map.putstr(key, value);
            }
            if (in.read() >= 0) {
                throw new IOException();
            }
            return map;
        }
        catch (Exception e) {
            return new SmartMap();
        }
    }

    public static byte[] mapToData(SmartMap map) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write("ShareWiki-db-ver1".getBytes("UTF-8"));
            out.write(MapToData.intToByteArray(map.size()));
            for (Map.Entry<String, String> entry : map.entrySet()) {
                byte[] key = entry.getKey().getBytes("UTF-8");
                byte[] value = entry.getValue().getBytes("UTF-8");
                out.write(MapToData.intToByteArray(key.length));
                out.write(key);
                out.write(MapToData.intToByteArray(value.length));
                out.write(value);
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            return new byte[0];
        }
    }
}

