/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util.exec;

import java.util.Formatter;
import plugins.Library.util.exec.Progress;
import plugins.Library.util.exec.TaskAbortException;

public class ProgressParts {
    public static final int ESTIMATE_UNKNOWN = -2;
    public static final int TOTAL_FINALIZED = -1;
    public final int done;
    public final int started;
    public final int known;
    public final int totalest;

    public static ProgressParts normalise(int d, int s, int k, int t) {
        if (t >= 0 && k > t) {
            k = t;
        }
        if (s > k) {
            s = k;
        }
        if (d > s) {
            d = s;
        }
        return new ProgressParts(d, s, k, t);
    }

    public static ProgressParts normalise(int d, int k) {
        return ProgressParts.normalise(d, d, k, -2);
    }

    public ProgressParts(int d, int s, int k, int t) {
        if (0 > d || d > s || s > k || t >= 0 && k > t || t < 0 && t != -2 && t != -1) {
            throw new IllegalArgumentException("ProgressParts (" + d + "/" + s + "/" + k + "/" + t + ") must obey the contract 0 <= done <= started <= known <= totalest or totalest == ESTIMATE_UNKNOWN or TOTAL_FINALIZED");
        }
        this.done = d;
        this.started = s;
        this.known = k;
        this.totalest = t;
    }

    public ProgressParts(int d, int s, int k) {
        this(d, s, k, -2);
    }

    public ProgressParts(int d, int k) {
        this(d, d, k, -2);
    }

    public final boolean finalizedTotal() {
        return this.totalest == -1;
    }

    public final boolean hasEstimate() {
        return this.totalest != -2;
    }

    public final boolean isDone() {
        return this.done == this.started && this.started == this.known && this.totalest == -1;
    }

    public final float getKnownFractionDone() {
        return this.known == 0 ? 0.0f : (float)this.done / (float)this.known;
    }

    public final float getKnownFractionStarted() {
        return this.known == 0 ? 0.0f : (float)this.started / (float)this.known;
    }

    public final float getEstimatedFractionDone() {
        return this.totalest == 0 ? 0.0f : (this.totalest == -1 ? this.getKnownFractionDone() : (float)this.done / (float)this.totalest);
    }

    public final float getEstimatedFractionStarted() {
        return this.totalest == 0 ? 0.0f : (this.totalest == -1 ? this.getKnownFractionStarted() : (float)this.started / (float)this.totalest);
    }

    public final float getEstimatedFractionKnown() {
        return this.totalest == 0 ? 0.0f : (this.totalest == -1 ? 1.0f : (float)this.known / (float)this.totalest);
    }

    public final String toString() {
        String s = this.done + "/";
        if (this.done != this.started) {
            s = s + this.started + "/";
        }
        s = s + this.known;
        if (!this.finalizedTotal()) {
            s = s + (this.hasEstimate() ? "/" + this.totalest + "??" : "/??");
        }
        return s;
    }

    public final String toFractionString() {
        Formatter f = new Formatter();
        if (this.finalizedTotal()) {
            f.format("%.4f", Float.valueOf(this.getKnownFractionDone()));
        } else if (!this.hasEstimate()) {
            f.format("%.4f (??)", Float.valueOf(this.getKnownFractionDone()));
        } else {
            f.format("%.4f (%.4f??)", Float.valueOf(this.getKnownFractionDone()), Float.valueOf(this.getEstimatedFractionDone()));
        }
        return f.toString();
    }

    public final String toPercentageString() {
        Formatter f = new Formatter();
        if (this.finalizedTotal()) {
            f.format("%.2f", Float.valueOf(this.getKnownFractionDone() * 100.0f));
        } else if (!this.hasEstimate()) {
            f.format("%.2f (??)", Float.valueOf(this.getKnownFractionDone() * 100.0f));
        } else {
            f.format("%.2f (%.2f??)", Float.valueOf(this.getKnownFractionDone() * 100.0f), Float.valueOf(this.getEstimatedFractionDone() * 100.0f));
        }
        return f.toString();
    }

    public static ProgressParts getSubParts(Iterable<? extends Progress> subprogress, boolean try_to_be_smart) throws TaskAbortException {
        int d = 0;
        int s = 0;
        int k = 0;
        int t = 0;
        int num = 0;
        int unknown = 0;
        boolean totalfinalized = true;
        block4: for (Progress progress : subprogress) {
            ++num;
            if (progress == null) {
                ++unknown;
                continue;
            }
            ProgressParts parts = progress.getParts();
            d += parts.done;
            s += parts.started;
            k += parts.known;
            switch (parts.totalest) {
                case -2: {
                    ++unknown;
                    totalfinalized = false;
                    continue block4;
                }
                case -1: {
                    t += parts.known;
                    continue block4;
                }
            }
            totalfinalized = false;
            t += parts.totalest;
        }
        if (num == unknown) {
            t = -2;
        } else if (unknown > 0) {
            t = try_to_be_smart ? Math.round((float)(t * num) / (float)(num - unknown)) : -2;
        }
        return new ProgressParts(d, s, k, totalfinalized ? -1 : t);
    }

    public static ProgressParts getParts(Iterable<? extends Progress> subprogress, int estimate) throws TaskAbortException {
        int d = 0;
        int s = 0;
        int k = 0;
        for (Progress progress : subprogress) {
            ++k;
            if (progress == null) continue;
            ++s;
            if (!progress.isDone()) continue;
            ++d;
        }
        return new ProgressParts(d, s, k, estimate);
    }
}

