/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.internal.UnicodeStringIO;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.WriteBuffer;

public class LatinStringIO {
    public int bytesPerChar() {
        return 1;
    }

    public byte encodingByte() {
        return 1;
    }

    static LatinStringIO forEncoding(byte encodingByte) {
        switch (encodingByte) {
            case 1: {
                return new LatinStringIO();
            }
        }
        return new UnicodeStringIO();
    }

    public int length(String str) {
        return str.length() + 0 + 4;
    }

    public String read(ReadBuffer buffer, int length) {
        char[] chars = new char[length];
        for (int ii = 0; ii < length; ++ii) {
            chars[ii] = (char)(buffer.readByte() & 0xFF);
        }
        return new String(chars, 0, length);
    }

    public String read(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[i] = (char)(bytes[i] & 0xFF);
        }
        return new String(chars, 0, bytes.length);
    }

    public int shortLength(String str) {
        return str.length() + 4;
    }

    public void write(WriteBuffer buffer, String str) {
        int length = str.length();
        char[] chars = new char[length];
        str.getChars(0, length, chars, 0);
        for (int i = 0; i < length; ++i) {
            buffer.writeByte((byte)(chars[i] & 0xFF));
        }
    }

    public byte[] write(String str) {
        int length = str.length();
        char[] chars = new char[length];
        str.getChars(0, length, chars, 0);
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)(chars[i] & 0xFF);
        }
        return bytes;
    }
}

