/*
 * Decompiled with CFR 0.152.
 */
package plugins.UPnP.org.cybergarage.upnp;

import plugins.UPnP.org.cybergarage.upnp.Argument;
import plugins.UPnP.org.cybergarage.upnp.ArgumentList;
import plugins.UPnP.org.cybergarage.upnp.Service;
import plugins.UPnP.org.cybergarage.upnp.UPnPStatus;
import plugins.UPnP.org.cybergarage.upnp.control.ActionListener;
import plugins.UPnP.org.cybergarage.upnp.control.ActionRequest;
import plugins.UPnP.org.cybergarage.upnp.control.ActionResponse;
import plugins.UPnP.org.cybergarage.upnp.control.ControlResponse;
import plugins.UPnP.org.cybergarage.upnp.xml.ActionData;
import plugins.UPnP.org.cybergarage.util.Debug;
import plugins.UPnP.org.cybergarage.util.Mutex;
import plugins.UPnP.org.cybergarage.xml.Node;

public class Action {
    public static final String ELEM_NAME = "action";
    private Node serviceNode;
    private Node actionNode;
    private Mutex mutex = new Mutex();
    private static final String NAME = "name";
    private UPnPStatus upnpStatus = new UPnPStatus();

    private Node getServiceNode() {
        return this.serviceNode;
    }

    public Service getService() {
        return new Service(this.getServiceNode());
    }

    public Node getActionNode() {
        return this.actionNode;
    }

    public Action(Node serviceNode, Node actionNode) {
        this.serviceNode = serviceNode;
        this.actionNode = actionNode;
    }

    public Action(Action action) {
        this.serviceNode = action.getServiceNode();
        this.actionNode = action.getActionNode();
    }

    public void lock() {
        this.mutex.lock();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public static boolean isActionNode(Node node) {
        return ELEM_NAME.equals(node.getName());
    }

    public void setName(String value) {
        this.getActionNode().setNode(NAME, value);
    }

    public String getName() {
        return this.getActionNode().getNodeValue(NAME);
    }

    public ArgumentList getArgumentList() {
        ArgumentList argumentList = new ArgumentList();
        Node argumentListNode = this.getActionNode().getNode("argumentList");
        if (argumentListNode == null) {
            return argumentList;
        }
        int nodeCnt = argumentListNode.getNNodes();
        for (int n = 0; n < nodeCnt; ++n) {
            Node node = argumentListNode.getNode(n);
            if (!Argument.isArgumentNode(node)) continue;
            Argument argument = new Argument(this.getServiceNode(), node);
            argumentList.add(argument);
        }
        return argumentList;
    }

    public ArgumentList getInputArgumentList() {
        ArgumentList allArgList = this.getArgumentList();
        int allArgCnt = allArgList.size();
        ArgumentList argList = new ArgumentList();
        for (int n = 0; n < allArgCnt; ++n) {
            Argument arg = allArgList.getArgument(n);
            if (!arg.isInDirection()) continue;
            argList.add(arg);
        }
        return argList;
    }

    public ArgumentList getOutputArgumentList() {
        ArgumentList allArgList = this.getArgumentList();
        int allArgCnt = allArgList.size();
        ArgumentList argList = new ArgumentList();
        for (int n = 0; n < allArgCnt; ++n) {
            Argument arg = allArgList.getArgument(n);
            if (!arg.isOutDirection()) continue;
            argList.add(arg);
        }
        return argList;
    }

    public Argument getArgument(String name) {
        ArgumentList argList = this.getArgumentList();
        int nArgs = argList.size();
        for (int n = 0; n < nArgs; ++n) {
            Argument arg = argList.getArgument(n);
            String argName = arg.getName();
            if (argName == null || !name.equals(argName)) continue;
            return arg;
        }
        return null;
    }

    public void setArgumentValues(ArgumentList argList) {
        this.getArgumentList().set(argList);
    }

    public void setArgumentValue(String name, String value) {
        Argument arg = this.getArgument(name);
        if (arg == null) {
            return;
        }
        arg.setValue(value);
    }

    public void setArgumentValue(String name, int value) {
        this.setArgumentValue(name, Integer.toString(value));
    }

    private void clearOutputAgumentValues() {
        ArgumentList allArgList = this.getArgumentList();
        int allArgCnt = allArgList.size();
        for (int n = 0; n < allArgCnt; ++n) {
            Argument arg = allArgList.getArgument(n);
            if (!arg.isOutDirection()) continue;
            arg.setValue("");
        }
    }

    public String getArgumentValue(String name) {
        Argument arg = this.getArgument(name);
        if (arg == null) {
            return "";
        }
        return arg.getValue();
    }

    public int getArgumentIntegerValue(String name) {
        Argument arg = this.getArgument(name);
        if (arg == null) {
            return 0;
        }
        return arg.getIntegerValue();
    }

    private ActionData getActionData() {
        Node node = this.getActionNode();
        ActionData userData = (ActionData)node.getUserData();
        if (userData == null) {
            userData = new ActionData();
            node.setUserData(userData);
            userData.setNode(node);
        }
        return userData;
    }

    public ActionListener getActionListener() {
        return this.getActionData().getActionListener();
    }

    public void setActionListener(ActionListener listener) {
        this.getActionData().setActionListener(listener);
    }

    public boolean performActionListener(ActionRequest actionReq) {
        ActionListener listener = this.getActionListener();
        if (listener == null) {
            return false;
        }
        ActionResponse actionRes = new ActionResponse();
        this.setStatus(401);
        this.clearOutputAgumentValues();
        if (listener.actionControlReceived(this)) {
            actionRes.setResponse(this);
        } else {
            UPnPStatus upnpStatus = this.getStatus();
            actionRes.setFaultResponse(upnpStatus.getCode(), upnpStatus.getDescription());
        }
        if (Debug.isOn()) {
            actionRes.print();
        }
        actionReq.post(actionRes);
        return true;
    }

    private ControlResponse getControlResponse() {
        return this.getActionData().getControlResponse();
    }

    private void setControlResponse(ControlResponse res) {
        this.getActionData().setControlResponse(res);
    }

    public UPnPStatus getControlStatus() {
        return this.getControlResponse().getUPnPError();
    }

    public boolean postControlAction() {
        ArgumentList actionArgList = this.getArgumentList();
        ArgumentList actionInputArgList = this.getInputArgumentList();
        ActionRequest ctrlReq = new ActionRequest();
        ctrlReq.setRequest(this, actionInputArgList);
        if (Debug.isOn()) {
            ctrlReq.print();
        }
        ActionResponse ctrlRes = ctrlReq.post();
        if (Debug.isOn()) {
            ctrlRes.print();
        }
        this.setControlResponse(ctrlRes);
        int statCode = ctrlRes.getStatusCode();
        this.setStatus(statCode);
        if (!ctrlRes.isSuccessful()) {
            return false;
        }
        ArgumentList outArgList = ctrlRes.getResponse();
        actionArgList.set(outArgList);
        return true;
    }

    public void print() {
        System.out.println("Action : " + this.getName());
        ArgumentList argList = this.getArgumentList();
        int nArgs = argList.size();
        for (int n = 0; n < nArgs; ++n) {
            Argument arg = argList.getArgument(n);
            String name = arg.getName();
            String value = arg.getValue();
            String dir = arg.getDirection();
            System.out.println(" [" + n + "] = " + dir + ", " + name + ", " + value);
        }
    }

    public void setStatus(int code, String descr) {
        this.upnpStatus.setCode(code);
        this.upnpStatus.setDescription(descr);
    }

    public void setStatus(int code) {
        this.setStatus(code, UPnPStatus.code2String(code));
    }

    public UPnPStatus getStatus() {
        return this.upnpStatus;
    }
}

