/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.FailureCodeTracker;
import freenet.client.async.TooManyFilesInsertException;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.node.LowLevelPutException;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.HashMap;

public class InsertException
extends Exception
implements Cloneable {
    private static final long serialVersionUID = -1106716067841151962L;
    public final InsertExceptionMode mode;
    public FailureCodeTracker errorCodes;
    public FreenetURI uri;
    public final String extra;
    private static volatile boolean logMINOR;
    private static final HashMap<Integer, InsertExceptionMode> modes;
    public static final int UPPER_LIMIT_ERROR_CODE = 1024;

    public InsertExceptionMode getMode() {
        return this.mode;
    }

    private InsertException() {
        this.mode = null;
        this.extra = null;
    }

    public InsertException(InsertExceptionMode m, String msg, FreenetURI expectedURI) {
        super(InsertException.getMessage(m) + ": " + msg);
        this.extra = msg;
        this.mode = m;
        this.errorCodes = null;
        this.uri = expectedURI;
        if (this.mode == InsertExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "Creating InsertException: " + InsertException.getMessage(this.mode) + ": " + msg, (Throwable)this);
        }
    }

    public InsertException(InsertExceptionMode m, FreenetURI expectedURI) {
        super(InsertException.getMessage(m));
        this.extra = null;
        this.mode = m;
        this.errorCodes = null;
        this.uri = expectedURI;
        if (this.mode == InsertExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "Creating InsertException: " + InsertException.getMessage(this.mode), (Throwable)this);
        }
    }

    public InsertException(InsertExceptionMode mode, Throwable e, FreenetURI expectedURI) {
        super(InsertException.getMessage(mode) + ": " + e.getMessage());
        this.extra = e.getMessage();
        this.mode = mode;
        this.errorCodes = null;
        this.initCause(e);
        this.uri = expectedURI;
        if (mode == InsertExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "Creating InsertException: " + InsertException.getMessage(mode) + ": " + e, (Throwable)this);
        }
    }

    public InsertException(InsertExceptionMode mode, String message, Throwable e, FreenetURI expectedURI) {
        super(InsertException.getMessage(mode) + ": " + message + ": " + e.getMessage());
        this.extra = e.getMessage();
        this.mode = mode;
        this.errorCodes = null;
        this.initCause(e);
        this.uri = expectedURI;
        if (mode == InsertExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "Creating InsertException: " + InsertException.getMessage(mode) + ": " + e, (Throwable)this);
        }
    }

    public InsertException(InsertExceptionMode mode, FailureCodeTracker errorCodes, FreenetURI expectedURI) {
        super(InsertException.getMessage(mode));
        this.extra = null;
        this.mode = mode;
        this.errorCodes = errorCodes;
        this.uri = expectedURI;
        if (mode == InsertExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "Creating InsertException: " + InsertException.getMessage(mode), (Throwable)this);
        }
    }

    public InsertException(InsertExceptionMode mode, String message, FailureCodeTracker errorCodes, FreenetURI expectedURI) {
        super(message == null ? InsertException.getMessage(mode) : InsertException.getMessage(mode) + ": " + message);
        this.extra = message;
        this.mode = mode;
        this.errorCodes = errorCodes;
        this.uri = expectedURI;
        if (mode == InsertExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "Creating InsertException: " + InsertException.getMessage(mode), (Throwable)this);
        }
    }

    public InsertException(InsertExceptionMode mode) {
        super(InsertException.getMessage(mode));
        this.extra = null;
        this.mode = mode;
        this.errorCodes = null;
        this.uri = null;
        if (mode == InsertExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Internal error: " + this);
        } else if (logMINOR) {
            Logger.minor(this, "Creating InsertException: " + InsertException.getMessage(mode), (Throwable)this);
        }
    }

    public InsertException(InsertException e) {
        super(e.getMessage());
        this.extra = e.extra;
        this.mode = e.mode;
        this.errorCodes = e.errorCodes == null ? null : e.errorCodes.clone();
        this.uri = e.uri;
    }

    public InsertException(TooManyFilesInsertException e) {
        this(InsertExceptionMode.TOO_MANY_FILES, (String)null, null);
    }

    public static InsertException constructFrom(LowLevelPutException e) {
        switch (e.code) {
            case 5: {
                return new InsertException(InsertExceptionMode.COLLISION);
            }
            case 1: {
                return new InsertException(InsertExceptionMode.INTERNAL_ERROR);
            }
            case 3: {
                return new InsertException(InsertExceptionMode.REJECTED_OVERLOAD);
            }
            case 2: {
                return new InsertException(InsertExceptionMode.ROUTE_NOT_FOUND);
            }
            case 4: {
                return new InsertException(InsertExceptionMode.ROUTE_REALLY_NOT_FOUND);
            }
        }
        Logger.error(InsertException.class, "Unknown LowLevelPutException: " + e + " code " + e.code, (Throwable)new Exception("error"));
        return new InsertException(InsertExceptionMode.INTERNAL_ERROR, "Unknown error " + e.code, null);
    }

    public static String getMessage(InsertExceptionMode mode) {
        String ret = NodeL10n.getBase().getString("InsertException.longError." + mode.code);
        if (ret == null) {
            return "Unknown error " + (Object)((Object)mode);
        }
        return ret;
    }

    public static String getShortMessage(InsertExceptionMode mode) {
        String ret = NodeL10n.getBase().getString("InsertException.shortError." + mode.code);
        if (ret == null) {
            return "Unknown error " + (Object)((Object)mode);
        }
        return ret;
    }

    public boolean isFatal() {
        return InsertException.isFatal(this.mode);
    }

    public static boolean isFatal(InsertExceptionMode mode) {
        switch (mode) {
            case INVALID_URI: 
            case FATAL_ERRORS_IN_BLOCKS: 
            case COLLISION: 
            case CANCELLED: 
            case META_STRINGS_NOT_SUPPORTED: 
            case BINARY_BLOB_FORMAT_ERROR: 
            case TOO_BIG: 
            case BUCKET_ERROR: 
            case INTERNAL_ERROR: {
                return true;
            }
            case REJECTED_OVERLOAD: 
            case TOO_MANY_RETRIES_IN_BLOCKS: 
            case ROUTE_NOT_FOUND: 
            case ROUTE_REALLY_NOT_FOUND: {
                return false;
            }
        }
        Logger.error(InsertException.class, "Error unknown to isFatal(): " + InsertException.getMessage(mode));
        return false;
    }

    public static InsertException construct(FailureCodeTracker errors) {
        if (errors == null) {
            return null;
        }
        if (errors.isEmpty()) {
            return null;
        }
        if (errors.isOneCodeOnly()) {
            return new InsertException(errors.getFirstCodeInsert());
        }
        InsertExceptionMode mode = errors.isFatal(true) ? InsertExceptionMode.FATAL_ERRORS_IN_BLOCKS : InsertExceptionMode.TOO_MANY_RETRIES_IN_BLOCKS;
        return new InsertException(mode, errors, null);
    }

    public InsertException clone() {
        return new InsertException(this);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        modes = new HashMap();
    }

    public static enum InsertExceptionMode {
        INVALID_URI(1),
        BUCKET_ERROR(2),
        INTERNAL_ERROR(3),
        REJECTED_OVERLOAD(4),
        ROUTE_NOT_FOUND(5),
        FATAL_ERRORS_IN_BLOCKS(6),
        TOO_MANY_RETRIES_IN_BLOCKS(7),
        ROUTE_REALLY_NOT_FOUND(8),
        COLLISION(9),
        CANCELLED(10),
        META_STRINGS_NOT_SUPPORTED(11),
        BINARY_BLOB_FORMAT_ERROR(12),
        TOO_MANY_FILES(13),
        TOO_BIG(14);

        public final int code;

        private InsertExceptionMode(int code) {
            this.code = code;
            if (code < 0 || code >= 1024) {
                throw new IllegalArgumentException();
            }
            if (modes.containsKey(code)) {
                throw new IllegalArgumentException();
            }
            modes.put(code, this);
        }

        public static InsertExceptionMode getByCode(int code) {
            if (modes.get(code) == null) {
                throw new IllegalArgumentException();
            }
            return (InsertExceptionMode)((Object)modes.get(code));
        }
    }
}

