/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptFormatException;
import freenet.crypt.CryptoElement;
import freenet.crypt.Util;
import freenet.support.HexUtil;
import freenet.support.Logger;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class CryptoKey
implements CryptoElement,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final MessageDigest shactx;

    CryptoKey() {
    }

    public static CryptoKey read(InputStream i) throws IOException, CryptFormatException {
        DataInputStream dis = new DataInputStream(i);
        String type = dis.readUTF();
        try {
            Class<?> keyClass = Class.forName(type);
            Method m = keyClass.getMethod("read", InputStream.class);
            return (CryptoKey)m.invoke(null, dis);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof CryptFormatException) {
                throw (CryptFormatException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            Logger.error(CryptoKey.class, "Unknown exception while reading CryptoKey", (Throwable)e);
            return null;
        }
    }

    public abstract String keyType();

    public abstract byte[] fingerprint();

    public abstract byte[] asBytes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] fingerprint(BigInteger[] quantities) {
        MessageDigest messageDigest = shactx;
        synchronized (messageDigest) {
            for (BigInteger quantity : quantities) {
                byte[] mpi = Util.MPIbytes(quantity);
                shactx.update(mpi, 0, mpi.length);
            }
            return shactx.digest();
        }
    }

    public String verboseToString() {
        StringBuilder b = new StringBuilder();
        b.append(this.toString()).append('\t').append(this.fingerprintToString());
        return b.toString();
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.keyType().length() + 1 + 4);
        b.append(this.keyType()).append('/');
        HexUtil.bytesToHexAppend(this.fingerprint(), 16, 4, b);
        return b.toString();
    }

    public String fingerprintToString() {
        String fphex = HexUtil.bytesToHex(this.fingerprint());
        StringBuilder b = new StringBuilder(50);
        b.append(fphex.substring(0, 4)).append(' ').append(fphex.substring(4, 8)).append(' ').append(fphex.substring(8, 12)).append(' ').append(fphex.substring(12, 16)).append(' ').append(fphex.substring(16, 20)).append("  ").append(fphex.substring(20, 24)).append(' ').append(fphex.substring(24, 28)).append(' ').append(fphex.substring(28, 32)).append(' ').append(fphex.substring(32, 36)).append(' ').append(fphex.substring(36, 40));
        return b.toString();
    }

    public static void main(String[] args) throws Exception {
        while (true) {
            CryptoKey kp = CryptoKey.read(System.in);
            System.err.println("-+ " + kp.verboseToString());
        }
    }

    static {
        try {
            shactx = MessageDigest.getInstance("SHA1", Util.mdProviders.get("SHA1"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }
}

