/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.updater;

import freenet.l10n.NodeL10n;
import freenet.node.NodeStarter;
import freenet.node.updater.MainJarDependenciesChecker;
import freenet.node.updater.UpdaterParserException;
import freenet.support.Logger;
import freenet.support.io.Closer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import org.tanukisoftware.wrapper.WrapperManager;

public class UpdateDeployContext {
    File mainJar;
    int mainClasspathNo;
    File newMainJar;
    File backupMainJar;
    boolean mainJarAbsolute;
    final MainJarDependenciesChecker.MainJarDependencies deps;

    UpdateDeployContext(MainJarDependenciesChecker.MainJarDependencies deps) throws UpdaterParserException {
        String prop;
        Properties p = WrapperManager.getProperties();
        this.deps = deps;
        int propNo = 1;
        while ((prop = p.getProperty("wrapper.java.classpath." + propNo)) != null) {
            File f = new File(prop);
            boolean isAbsolute = f.isAbsolute();
            String name = f.getName().toLowerCase();
            if (!(this.mainJar != null || name.equals("freenet-ext.jar") || name.equals("freenet-ext.jar.new") || name.startsWith("freenet-ext") && name.endsWith(".jar"))) {
                if (name.startsWith("freenet") && name.endsWith(".jar")) {
                    this.mainJar = f;
                    this.newMainJar = new File(this.mainJar.getParent(), "freenet.jar.new");
                    this.mainJarAbsolute = isAbsolute;
                    this.mainClasspathNo = propNo;
                } else if (name.startsWith("freenet") && name.endsWith(".jar.new")) {
                    this.mainJar = f;
                    this.newMainJar = new File(this.mainJar.getParent(), "freenet.jar");
                    this.mainJarAbsolute = isAbsolute;
                    this.mainClasspathNo = propNo;
                }
            }
            ++propNo;
        }
        if (this.mainJar == null) {
            throw new UpdaterParserException(this.l10n("cannotUpdateNoMainJar"));
        }
        this.backupMainJar = new File(this.mainJar.getParent(), "freenet.jar.bak");
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("UpdateDeployContext." + key);
    }

    public static String l10n(String key, String[] patterns, String[] values) {
        return NodeL10n.getBase().getString("UpdateDeployContext." + key, patterns, values);
    }

    public static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("UpdateDeployContext." + key, pattern, value);
    }

    File getMainJar() {
        return this.mainJar;
    }

    File getNewMainJar() {
        return this.newMainJar;
    }

    void rewriteWrapperConf(boolean writtenNewJar) throws IOException, UpdateCatastropheException, UpdaterParserException {
        String line;
        File o;
        File wrapperDir;
        File oldConfig = new File("wrapper.conf");
        File newConfig = new File("wrapper.conf.new");
        if (!oldConfig.exists() && (wrapperDir = new File("wrapper")).exists() && wrapperDir.isDirectory() && (o = new File(wrapperDir, "wrapper.conf")).exists()) {
            oldConfig = o;
            newConfig = new File(wrapperDir, "wrapper.conf.new");
        }
        FileInputStream fis = new FileInputStream(oldConfig);
        BufferedInputStream bis = new BufferedInputStream(fis);
        InputStreamReader isr = new InputStreamReader(bis);
        BufferedReader br = new BufferedReader(isr);
        FileOutputStream fos = new FileOutputStream(newConfig);
        OutputStreamWriter osw = new OutputStreamWriter(fos);
        BufferedWriter bw = new BufferedWriter(osw);
        boolean writtenReload = false;
        boolean writtenAnchor = false;
        boolean writtenAnchorInterval = false;
        String newMain = this.mainJarAbsolute ? this.newMainJar.getAbsolutePath() : this.newMainJar.getPath();
        String mainRHS = null;
        ArrayList<String> otherLines = new ArrayList<String>();
        ArrayList<String> classpath = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            String lowcaseLine = line.toLowerCase();
            boolean dontWrite = false;
            if (lowcaseLine.startsWith("wrapper.java.classpath.")) {
                int idx = (line = line.substring("wrapper.java.classpath.".length())).indexOf(61);
                if (idx != -1) {
                    String rhs = line.substring(idx + 1);
                    dontWrite = true;
                    if (rhs.equals("freenet.jar") || rhs.equals("freenet.jar.new") || rhs.equals("freenet-stable-latest.jar") || rhs.equals("freenet-stable-latest.jar.new") || rhs.equals("freenet-testing-latest.jar") || rhs.equals("freenet-testing-latest.jar.new")) {
                        mainRHS = writtenNewJar ? newMain : rhs;
                    } else {
                        MainJarDependenciesChecker.Dependency dep = this.findDependencyByRHSFilename(new File(rhs));
                        if (dep != null) {
                            if (dep.oldFilename() != null) {
                                System.out.println("Found old dependency " + dep.oldFilename());
                            } else {
                                System.out.println("Found new dependency " + dep.newFilename());
                            }
                        } else {
                            System.out.println("Found unknown jar in classpath, will keep: " + rhs);
                            classpath.add(rhs);
                        }
                    }
                }
            } else if (lowcaseLine.equals("wrapper.restart.reload_configuration=true")) {
                writtenReload = true;
            } else if (lowcaseLine.startsWith("wrapper.anchorfile=")) {
                writtenAnchor = true;
            } else if (lowcaseLine.startsWith("wrapper.anchor.poll_interval=")) {
                writtenAnchorInterval = true;
            }
            if (dontWrite) continue;
            otherLines.add(line);
        }
        br.close();
        if (mainRHS == null) {
            throw new UpdaterParserException(UpdateDeployContext.l10n("updateFailedNonStandardConfig", new String[]{"main"}, new String[]{Boolean.toString(mainRHS != null)}));
        }
        int count = 1;
        for (MainJarDependenciesChecker.Dependency d : this.deps.dependencies) {
            System.out.println("Writing dependency " + d.newFilename() + " priority " + d.order());
            bw.write("wrapper.java.classpath." + count + "=" + d.newFilename() + '\n');
            ++count;
        }
        bw.write("wrapper.java.classpath." + count + "=" + mainRHS + '\n');
        ++count;
        for (String s : classpath) {
            bw.write("wrapper.java.classpath." + count + "=" + s + '\n');
            ++count;
        }
        for (String s : otherLines) {
            bw.write(s + '\n');
        }
        if (!writtenReload) {
            bw.write("wrapper.restart.reload_configuration=TRUE\n");
        }
        if (!writtenAnchor) {
            bw.write("wrapper.anchorfile=Freenet.anchor\n");
        }
        if (!writtenAnchorInterval) {
            bw.write("wrapper.anchor.poll_interval=1\n");
        }
        bw.close();
        if (!newConfig.renameTo(oldConfig)) {
            if (!oldConfig.delete()) {
                throw new UpdaterParserException(UpdateDeployContext.l10n("updateFailedCannotDeleteOldConfig", "old", oldConfig.toString()));
            }
            if (!newConfig.renameTo(oldConfig)) {
                throw new UpdateCatastropheException(oldConfig, newConfig);
            }
        }
        System.err.println("Rewritten wrapper.conf for build " + this.deps.build + " and " + this.deps.dependencies.size() + " dependencies.");
    }

    private MainJarDependenciesChecker.Dependency findDependencyByRHSFilename(File rhs) {
        File f;
        String rhsName = rhs.getName().toLowerCase();
        for (MainJarDependenciesChecker.Dependency dep : this.deps.dependencies) {
            f = dep.oldFilename();
            if (f == null) continue;
            if (rhs.equals(f)) {
                return dep;
            }
            if (!rhsName.equals(f.getName().toLowerCase())) continue;
            return dep;
        }
        for (MainJarDependenciesChecker.Dependency dep : this.deps.dependencies) {
            f = dep.newFilename();
            if (rhs.equals(f)) {
                return dep;
            }
            if (!rhsName.equals(f.getName().toLowerCase())) continue;
            return dep;
        }
        for (MainJarDependenciesChecker.Dependency dep : this.deps.dependencies) {
            Pattern p = dep.regex();
            if (p == null || !p.matcher(rhs.getName().toLowerCase()).matches()) continue;
            return dep;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CHANGED tryIncreaseMemoryLimit(int extraMemoryMB, String markerComment) {
        CHANGED cHANGED;
        BufferedWriter bw;
        OutputStreamWriter osw;
        FileOutputStream fos;
        BufferedReader br;
        InputStreamReader isr;
        BufferedInputStream bis;
        FileInputStream fis;
        block16: {
            File o;
            File wrapperDir;
            File oldConfig = new File("wrapper.conf");
            File newConfig = new File("wrapper.conf.new");
            if (!oldConfig.exists() && (wrapperDir = new File("wrapper")).exists() && wrapperDir.isDirectory() && (o = new File(wrapperDir, "wrapper.conf")).exists()) {
                oldConfig = o;
                newConfig = new File(wrapperDir, "wrapper.conf.new");
            }
            fis = null;
            bis = null;
            isr = null;
            br = null;
            fos = null;
            osw = null;
            bw = null;
            boolean success = false;
            try {
                String line;
                fis = new FileInputStream(oldConfig);
                bis = new BufferedInputStream(fis);
                isr = new InputStreamReader(bis);
                br = new BufferedReader(isr);
                fos = new FileOutputStream(newConfig);
                osw = new OutputStreamWriter(fos);
                bw = new BufferedWriter(osw);
                while ((line = br.readLine()) != null) {
                    if (line.equals("#" + markerComment)) {
                        cHANGED = CHANGED.ALREADY;
                        break block16;
                    }
                    if (line.startsWith("wrapper.java.maxmemory=")) {
                        try {
                            int memoryLimit = Integer.parseInt(line.substring("wrapper.java.maxmemory=".length()));
                            int newMemoryLimit = memoryLimit + extraMemoryMB;
                            if (NodeStarter.isSomething32bits() && newMemoryLimit > 1408) {
                                Logger.error(UpdateDeployContext.class, "We've detected a 32bit JVM so we're refusing to set maxmemory to " + newMemoryLimit);
                                newMemoryLimit = 1408;
                            }
                            bw.write('#' + markerComment + '\n');
                            bw.write("wrapper.java.maxmemory=" + newMemoryLimit + '\n');
                            success = true;
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    bw.write(line + '\n');
                }
                br.close();
            }
            catch (IOException e) {
                CHANGED cHANGED2;
                try {
                    newConfig.delete();
                    System.err.println("Unable to rewrite wrapper.conf with new memory limit.");
                    cHANGED2 = CHANGED.FAIL;
                }
                catch (Throwable throwable) {
                    Closer.close(br);
                    Closer.close(isr);
                    Closer.close(bis);
                    Closer.close(fis);
                    Closer.close(bw);
                    Closer.close(osw);
                    Closer.close(fos);
                    throw throwable;
                }
                Closer.close(br);
                Closer.close(isr);
                Closer.close(bis);
                Closer.close(fis);
                Closer.close(bw);
                Closer.close(osw);
                Closer.close(fos);
                return cHANGED2;
            }
            Closer.close(br);
            Closer.close(isr);
            Closer.close(bis);
            Closer.close(fis);
            Closer.close(bw);
            Closer.close(osw);
            Closer.close(fos);
            if (!success) {
                newConfig.delete();
                return CHANGED.FAIL;
            }
            if (!newConfig.renameTo(oldConfig)) {
                if (!oldConfig.delete()) {
                    System.err.println("Unable to move rewritten wrapper.conf with new memory limit " + newConfig + " over old config " + oldConfig + " : unable to delete old config");
                    return CHANGED.FAIL;
                }
                if (!newConfig.renameTo(oldConfig)) {
                    System.err.println("Old wrapper.conf deleted but new wrapper.conf cannot be renamed!");
                    System.err.println("FREENET WILL NOT START UNTIL YOU RENAME " + newConfig + " to " + oldConfig);
                    System.exit(28);
                }
            }
            System.err.println("Rewritten wrapper.conf for new memory limit");
            return CHANGED.SUCCESS;
        }
        Closer.close(br);
        Closer.close(isr);
        Closer.close(bis);
        Closer.close(fis);
        Closer.close(bw);
        Closer.close(osw);
        Closer.close(fos);
        return cHANGED;
    }

    public File getBackupJar() {
        return this.backupMainJar;
    }

    public static enum CHANGED {
        ALREADY,
        SUCCESS,
        FAIL;

    }

    public static class UpdateCatastropheException
    extends Exception {
        private static final long serialVersionUID = 1L;
        File oldConfig;
        File newConfig;

        UpdateCatastropheException(File oldConfig, File newConfig) {
            super(UpdateDeployContext.l10n("updateCatastrophe", new String[]{"old", "new"}, new String[]{oldConfig.toString(), newConfig.toString()}));
            this.oldConfig = oldConfig;
            this.newConfig = newConfig;
        }
    }
}

