/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.client.async.ClientContext;
import freenet.client.async.PersistentJob;
import freenet.client.async.PersistentJobRunner;
import freenet.node.PrioRunnable;
import freenet.support.Executor;
import freenet.support.Logger;
import freenet.support.io.NativeThread;

public class DummyJobRunner
implements PersistentJobRunner {
    private static volatile boolean logMINOR;
    final Executor executor;
    final ClientContext context;

    public DummyJobRunner(Executor executor, ClientContext context) {
        this.executor = executor;
        this.context = context;
    }

    @Override
    public void queue(final PersistentJob job, final int priority) {
        if (logMINOR) {
            Logger.minor(this, "Running job off thread: " + job);
        }
        this.executor.execute(new PrioRunnable(){

            @Override
            public void run() {
                if (logMINOR) {
                    Logger.minor(this, "Starting job " + job);
                }
                job.run(DummyJobRunner.this.context);
            }

            @Override
            public int getPriority() {
                return priority;
            }
        });
    }

    @Override
    public void queueNormalOrDrop(PersistentJob job) {
        this.queue(job, NativeThread.NORM_PRIORITY);
    }

    @Override
    public void setCheckpointASAP() {
    }

    @Override
    public boolean hasLoaded() {
        return true;
    }

    @Override
    public void queueInternal(PersistentJob job, int threadPriority) {
        this.queue(job, threadPriority);
    }

    @Override
    public void queueInternal(PersistentJob job) {
        this.queueInternal(job, NativeThread.NORM_PRIORITY);
    }

    @Override
    public PersistentJobRunner.CheckpointLock lock() {
        return new PersistentJobRunner.CheckpointLock(){

            @Override
            public void unlock(boolean forceWrite, int threadPriority) {
            }
        };
    }

    @Override
    public boolean newSalt() {
        return false;
    }

    @Override
    public boolean shuttingDown() {
        return false;
    }

    static {
        Logger.registerClass(DummyJobRunner.class);
    }
}

