/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.bookmark;

import freenet.client.async.ClientGetter;
import freenet.clients.http.bookmark.Bookmark;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.l10n.NodeL10n;
import freenet.node.FSParseException;
import freenet.node.NodeClientCore;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.node.useralerts.UserAlertManager;
import freenet.support.Fields;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import java.net.MalformedURLException;

public class BookmarkItem
extends Bookmark {
    public static final String NAME = "Bookmark";
    private FreenetURI key;
    private boolean updated;
    private boolean hasAnActivelink = false;
    private final BookmarkUpdatedUserAlert alert;
    private final UserAlertManager alerts;
    protected String desc;
    protected String shortDescription;
    private static volatile boolean logMINOR;

    public BookmarkItem(FreenetURI k, String n, String d, String s, boolean hasAnActivelink, UserAlertManager uam) throws MalformedURLException {
        this.key = k;
        this.name = n;
        this.desc = d;
        this.shortDescription = s;
        this.hasAnActivelink = hasAnActivelink;
        this.alerts = uam;
        this.alert = new BookmarkUpdatedUserAlert();
        assert (this.name != null);
        assert (this.key != null);
    }

    public BookmarkItem(String line, UserAlertManager uam) throws MalformedURLException {
        String[] result = line.split("###");
        this.name = result[0];
        this.desc = result[1];
        this.hasAnActivelink = Fields.stringToBool(result[2], false);
        this.key = new FreenetURI(result[3]);
        this.alerts = uam;
        this.alert = new BookmarkUpdatedUserAlert();
        assert (this.name != null);
        assert (this.key != null);
    }

    public BookmarkItem(SimpleFieldSet sfs, UserAlertManager uam) throws FSParseException, MalformedURLException {
        this.name = sfs.get("Name");
        if (this.name == null || this.name.isEmpty()) {
            this.name = this.l10n("unnamedBookmark");
        }
        this.desc = sfs.get("Description");
        if (this.desc == null) {
            this.desc = "";
        }
        this.shortDescription = sfs.get("ShortDescription");
        if (this.shortDescription == null) {
            this.shortDescription = "";
        }
        this.hasAnActivelink = sfs.getBoolean("hasAnActivelink");
        this.key = new FreenetURI(sfs.get("URI"));
        this.alerts = uam;
        this.alert = new BookmarkUpdatedUserAlert();
    }

    private synchronized void disableBookmark() {
        this.updated = false;
        this.alerts.unregister(this.alert);
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("BookmarkItem." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("BookmarkItem." + key, new String[]{pattern}, new String[]{value});
    }

    private String l10n(String key, String[] patterns, String[] values) {
        return NodeL10n.getBase().getString("BookmarkItem." + key, patterns, values);
    }

    private synchronized void enableBookmark() {
        if (this.updated) {
            return;
        }
        assert (this.key.isUSK());
        this.updated = true;
        this.alerts.register(this.alert);
    }

    public String getKey() {
        return this.key.toString();
    }

    public synchronized FreenetURI getURI() {
        return this.key;
    }

    public synchronized void update(FreenetURI uri, boolean hasAnActivelink, String description, String shortDescription) {
        this.key = uri;
        this.desc = description;
        this.shortDescription = shortDescription;
        this.hasAnActivelink = hasAnActivelink;
        if (!this.key.isUSK()) {
            this.disableBookmark();
        }
    }

    public synchronized String getKeyType() {
        return this.key.getKeyType();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + "###" + (this.desc != null ? this.desc : "") + "###" + this.hasAnActivelink + "###" + this.key.toString();
    }

    public synchronized boolean setEdition(long ed, NodeClientCore node) {
        if (this.key.getSuggestedEdition() >= ed) {
            if (logMINOR) {
                Logger.minor(this, "Edition " + ed + " is too old, not updating " + this.key);
            }
            return false;
        }
        this.key = this.key.setSuggestedEdition(ed);
        this.enableBookmark();
        return true;
    }

    public USK getUSK() throws MalformedURLException {
        return USK.create(this.key);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.key.setSuggestedEdition(0L).hashCode();
        hash = 31 * hash + (this.hasAnActivelink ? 1 : 0);
        hash = 31 * hash + (this.desc != null ? this.desc.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BookmarkItem) {
            BookmarkItem b = (BookmarkItem)o;
            if (!super.equals(o)) {
                return false;
            }
            if (!b.key.equals(this.key)) {
                if ("USK".equals(b.key.getKeyType())) {
                    if (!b.key.setSuggestedEdition(this.key.getSuggestedEdition()).equals(this.key)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (b.alerts != this.alerts) {
                return false;
            }
            if (b.hasAnActivelink != this.hasAnActivelink) {
                return false;
            }
            if (b.desc.equals(this.desc)) {
                return true;
            }
            if (b.desc == null || this.desc == null) {
                return false;
            }
            return b.desc.equals(this.desc);
        }
        return false;
    }

    public boolean hasUpdated() {
        return this.updated;
    }

    public void clearUpdated() {
        this.updated = false;
    }

    public boolean hasAnActivelink() {
        return this.hasAnActivelink;
    }

    public String getDescription() {
        if (this.desc == null) {
            return "";
        }
        if (this.desc.toLowerCase().startsWith("l10n:")) {
            return NodeL10n.getBase().getString("Bookmarks.Defaults.Description." + this.desc.substring("l10n:".length()));
        }
        return this.desc;
    }

    public String getShortDescription() {
        if (this.shortDescription == null) {
            return "";
        }
        if (this.shortDescription.toLowerCase().startsWith("l10n:")) {
            return NodeL10n.getBase().getString("Bookmarks.Defaults.ShortDescription." + this.shortDescription.substring("l10n:".length()));
        }
        return this.shortDescription;
    }

    @Override
    public SimpleFieldSet getSimpleFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.putSingle("Name", this.name);
        sfs.putSingle("Description", this.desc);
        sfs.putSingle("ShortDescription", this.shortDescription);
        sfs.put("hasAnActivelink", this.hasAnActivelink);
        sfs.putSingle("URI", this.key.toString());
        return sfs;
    }

    static {
        Logger.registerClass(ClientGetter.class);
    }

    private class BookmarkUpdatedUserAlert
    extends AbstractUserAlert {
        public BookmarkUpdatedUserAlert() {
            super(true, null, null, null, null, (short)3, false, null, true, null);
        }

        @Override
        public String getTitle() {
            return BookmarkItem.this.l10n("bookmarkUpdatedTitle", "name", BookmarkItem.this.name);
        }

        @Override
        public String getText() {
            return BookmarkItem.this.l10n("bookmarkUpdated", new String[]{"name", "edition"}, new String[]{BookmarkItem.this.name, Long.toString(BookmarkItem.this.key.getSuggestedEdition())});
        }

        @Override
        public HTMLNode getHTMLText() {
            HTMLNode n = new HTMLNode("div");
            NodeL10n.getBase().addL10nSubstitution(n, "BookmarkItem.bookmarkUpdatedWithLink", new String[]{"link", "name", "edition"}, new HTMLNode[]{HTMLNode.link("/" + BookmarkItem.this.key), HTMLNode.text(BookmarkItem.this.name), HTMLNode.text(BookmarkItem.this.key.getSuggestedEdition())});
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isValid() {
            BookmarkItem bookmarkItem = BookmarkItem.this;
            synchronized (bookmarkItem) {
                return BookmarkItem.this.updated;
            }
        }

        @Override
        public void isValid(boolean validity) {
            if (validity) {
                return;
            }
            BookmarkItem.this.disableBookmark();
        }

        @Override
        public String dismissButtonText() {
            return BookmarkItem.this.l10n("deleteBookmarkUpdateNotification");
        }

        @Override
        public void onDismiss() {
            BookmarkItem.this.disableBookmark();
        }

        @Override
        public String getShortText() {
            return BookmarkItem.this.l10n("bookmarkUpdatedShort", "name", BookmarkItem.this.name);
        }

        @Override
        public boolean isEventNotification() {
            return true;
        }
    }
}

