/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.client.async.ChosenBlock;
import freenet.client.async.ChosenBlockImpl;
import freenet.client.async.ClientContext;
import freenet.keys.Key;
import freenet.node.BaseRequestThrottle;
import freenet.node.BaseSendableGet;
import freenet.node.NodeClientCore;
import freenet.node.NodeStats;
import freenet.node.OpennetManager;
import freenet.node.RequestScheduler;
import freenet.node.SendableInsert;
import freenet.node.SendableRequest;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.RandomGrabArrayItem;
import freenet.support.RandomGrabArrayItemExclusionList;
import freenet.support.math.RunningAverage;
import java.util.concurrent.TimeUnit;

public class RequestStarter
implements Runnable,
RandomGrabArrayItemExclusionList {
    private static volatile boolean logMINOR;
    public static final short MAXIMUM_PRIORITY_CLASS = 0;
    public static final short INTERACTIVE_PRIORITY_CLASS = 1;
    public static final short IMMEDIATE_SPLITFILE_PRIORITY_CLASS = 2;
    public static final short UPDATE_PRIORITY_CLASS = 3;
    public static final short BULK_SPLITFILE_PRIORITY_CLASS = 4;
    public static final short PREFETCH_PRIORITY_CLASS = 5;
    public static final short PAUSED_PRIORITY_CLASS = 6;
    public static final short NUMBER_OF_PRIORITY_CLASSES = 7;
    public static final short MINIMUM_FETCHABLE_PRIORITY_CLASS = 5;
    final BaseRequestThrottle throttle;
    final RunningAverage averageInputBytesPerRequest;
    final RunningAverage averageOutputBytesPerRequest;
    RequestScheduler sched;
    final NodeClientCore core;
    final NodeStats stats;
    private final boolean isInsert;
    private final boolean isSSK;
    final boolean realTime;
    static final int MAX_WAITING_FOR_SLOTS = 50;
    final String name;

    public static boolean isValidPriorityClass(int prio) {
        return prio >= 0 && prio <= 6;
    }

    public RequestStarter(NodeClientCore node, BaseRequestThrottle throttle, String name, RunningAverage averageOutputBytesPerRequest, RunningAverage averageInputBytesPerRequest, boolean isInsert, boolean isSSK, boolean realTime) {
        this.core = node;
        this.stats = this.core.nodeStats;
        this.throttle = throttle;
        this.name = name + (realTime ? " (realtime)" : " (bulk)");
        this.averageOutputBytesPerRequest = averageOutputBytesPerRequest;
        this.averageInputBytesPerRequest = averageInputBytesPerRequest;
        this.isInsert = isInsert;
        this.isSSK = isSSK;
        this.realTime = realTime;
    }

    void setScheduler(RequestScheduler sched) {
        this.sched = sched;
    }

    void start() {
        this.core.getExecutor().execute(this, this.name);
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void realRun() {
        ChosenBlock req = null;
        long cycleTime = System.currentTimeMillis();
        while (true) {
            OpennetManager om;
            if (this.core.node.peers.countConnectedPeers() < 3 && (om = this.core.node.getOpennet()) != null && System.currentTimeMillis() - om.getCreationTime() < TimeUnit.MINUTES.toMillis(5L)) {
                try {
                    RequestStarter requestStarter = this;
                    synchronized (requestStarter) {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (req == null) {
                req = this.sched.grabRequest();
            }
            if (req != null) {
                if (logMINOR) {
                    Logger.minor(this, "Running " + req + " priority " + req.getPriority());
                }
                if (!req.localRequestOnly) {
                    long now;
                    long delay = this.throttle.getDelay();
                    if (logMINOR) {
                        Logger.minor(this, "Delay=" + delay + " from " + this.throttle);
                    }
                    long sleepUntil = cycleTime + delay;
                    do {
                        if ((now = System.currentTimeMillis()) >= sleepUntil) continue;
                        try {
                            Thread.sleep(sleepUntil - now);
                            if (!logMINOR) continue;
                            Logger.minor(this, "Slept: " + (sleepUntil - now) + "ms");
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    } while (now < sleepUntil);
                }
                assert (req.realTimeFlag == this.realTime);
                if (!req.localRequestOnly) {
                    NodeStats.RejectReason reason = this.stats.shouldRejectRequest(true, this.isInsert, this.isSSK, true, false, null, false, false, req.realTimeFlag, null);
                    if (reason != null) {
                        if (logMINOR) {
                            Logger.minor(this, "Not sending local request: " + reason);
                        }
                        cycleTime = System.currentTimeMillis();
                        continue;
                    }
                } else {
                    this.stats.waitUntilNotOverloaded(this.isInsert);
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Waiting...");
                }
                RequestStarter requestStarter = this;
                synchronized (requestStarter) {
                    req = this.sched.grabRequest();
                    if (req == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
            }
            if (req == null) continue;
            if (!(this.startRequest(req, logMINOR) || !req.isPersistent() && req.isCancelled())) {
                Logger.normal(this, "No requests to start on " + req);
            }
            if (!req.localRequestOnly) {
                cycleTime = System.currentTimeMillis();
            }
            req = null;
        }
    }

    private boolean startRequest(ChosenBlock req, boolean logMINOR) {
        if (!req.isPersistent() && req.isCancelled()) {
            req.onDumped();
            return false;
        }
        if (req.key != null) {
            if (!this.sched.addToFetching(req.key)) {
                req.onDumped();
                return false;
            }
        } else if (((ChosenBlockImpl)req).request instanceof SendableInsert && !this.sched.addRunningInsert((SendableInsert)((ChosenBlockImpl)req).request, req.token.getKey())) {
            req.onDumped();
            return false;
        }
        if (logMINOR) {
            Logger.minor(this, "Running request " + req + " priority " + req.getPriority());
        }
        this.core.getExecutor().execute(new SenderThread(req, req.key), "RequestStarter$SenderThread for " + req);
        return true;
    }

    @Override
    public void run() {
        Logger.OSThread.logPID(this);
        while (true) {
            try {
                while (true) {
                    this.realRun();
                }
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        RequestStarter requestStarter = this;
        synchronized (requestStarter) {
            this.notifyAll();
        }
    }

    @Override
    public long exclude(RandomGrabArrayItem item, ClientContext context, long now) {
        if (this.sched.isRunningOrQueuedPersistentRequest((SendableRequest)item)) {
            Logger.normal(this, "Excluding already-running request: " + item, (Throwable)new Exception("debug"));
            return Long.MAX_VALUE;
        }
        if (this.isInsert) {
            return -1L;
        }
        if (!(item instanceof BaseSendableGet)) {
            Logger.error(this, "On a request scheduler, exclude() called with " + item, (Throwable)new Exception("error"));
            return -1L;
        }
        BaseSendableGet get = (BaseSendableGet)item;
        return get.getWakeupTime(context, now);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    private class SenderThread
    implements Runnable {
        private final ChosenBlock req;
        private final Key key;

        public SenderThread(ChosenBlock req, Key key) {
            this.req = req;
            this.key = key;
        }

        @Override
        public void run() {
            Logger.OSThread.logPID(this);
            if (this.key != null) {
                RequestStarter.this.stats.reportOutgoingLocalRequestLocation(this.key.toNormalizedDouble());
            }
            if (!this.req.send(RequestStarter.this.core, RequestStarter.this.sched)) {
                if (this.req.isPersistent() || !this.req.isCancelled()) {
                    Logger.error(this, "run() not able to send a request on " + this.req);
                } else {
                    Logger.normal(this, "run() not able to send a request on " + this.req + " - request was cancelled");
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Finished " + this.req);
            }
        }
    }
}

