/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.DoublyLinkedList;
import freenet.support.PromiscuousItemException;
import freenet.support.VirginItemException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DoublyLinkedListImpl<T extends DoublyLinkedList.Item<? extends T>>
implements DoublyLinkedList<T> {
    protected int size;
    protected T _firstItem;
    protected T _lastItem;

    public DoublyLinkedListImpl() {
        this.clear();
    }

    protected DoublyLinkedListImpl(T _h, T _t, int size) {
        this._firstItem = _h;
        this._lastItem = _t;
        for (T i = this._firstItem; i != null; i = i.getNext()) {
            i.setParent(this);
        }
        this.size = size;
    }

    @Override
    public void clear() {
        if (this._firstItem == null) {
            return;
        }
        for (Object pos = this._firstItem; pos != null; pos = pos.getNext()) {
            pos.setParent(null);
            pos.setPrev(null);
            Object opos = pos;
            opos.setNext(null);
        }
        this._lastItem = null;
        this._firstItem = null;
        this.size = 0;
    }

    @Override
    public final int size() {
        assert (this.size != 0 || this._firstItem == null && this._lastItem == null);
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        assert (this.size != 0 || this._firstItem == null && this._lastItem == null);
        return this.size == 0;
    }

    @Override
    public final Enumeration<T> elements() {
        return this.forwardElements();
    }

    @Override
    public boolean contains(T item) {
        for (DoublyLinkedList.Item i : this) {
            if (!i.equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final T head() {
        return this.size == 0 ? null : (T)this._firstItem;
    }

    @Override
    public final T tail() {
        return this.size == 0 ? null : (T)this._lastItem;
    }

    @Override
    public final void unshift(T i) {
        this.insertNext(null, i);
    }

    @Override
    public final T shift() {
        return this.size == 0 ? null : (T)this.remove(this._firstItem);
    }

    @Override
    public DoublyLinkedList<T> shift(int n) {
        if (n > this.size) {
            n = this.size;
        }
        if (n < 1) {
            return new DoublyLinkedListImpl<T>();
        }
        T i = this._firstItem;
        for (int m = 0; m < n - 1; ++m) {
            i = i.getNext();
        }
        T newTailItem = i;
        Object newFirstItem = newTailItem.getNext();
        newTailItem.setNext(null);
        DoublyLinkedListImpl<T> newlist = new DoublyLinkedListImpl<T>(this._firstItem, newTailItem, n);
        if (newFirstItem != null) {
            newFirstItem.setPrev(null);
            this._firstItem = newFirstItem;
        } else {
            this._lastItem = null;
            this._firstItem = null;
        }
        this.size -= n;
        return newlist;
    }

    @Override
    public final void push(T i) {
        this.insertPrev(null, i);
    }

    @Override
    public final T pop() {
        return this.size == 0 ? null : (T)this.remove(this._lastItem);
    }

    @Override
    public DoublyLinkedList<T> pop(int n) {
        if (n > this.size) {
            n = this.size;
        }
        if (n < 1) {
            return new DoublyLinkedListImpl<T>();
        }
        T i = this._lastItem;
        for (int m = 0; m < n - 1; ++m) {
            i = i.getPrev();
        }
        T newFirstItem = i;
        Object newLastItem = newFirstItem.getPrev();
        newFirstItem.setPrev(null);
        DoublyLinkedListImpl<T> newlist = new DoublyLinkedListImpl<T>(newFirstItem, this._lastItem, n);
        if (newLastItem != null) {
            newLastItem.setNext(null);
            this._lastItem = newLastItem;
        } else {
            this._lastItem = null;
            this._firstItem = null;
        }
        this.size -= n;
        return newlist;
    }

    @Override
    public final boolean hasNext(T i) {
        Object next = i.getNext();
        return next != null;
    }

    @Override
    public final boolean hasPrev(T i) {
        Object prev = i.getPrev();
        return prev != null;
    }

    @Override
    public final T next(T i) {
        Object next = i.getNext();
        return next;
    }

    @Override
    public final T prev(T i) {
        Object prev = i.getPrev();
        return prev;
    }

    @Override
    public T remove(T i) {
        if (i.getParent() == null || this.isEmpty()) {
            return null;
        }
        if (i.getParent() != this) {
            throw new PromiscuousItemException((DoublyLinkedList.Item<?>)i, i.getParent());
        }
        Object next = i.getNext();
        Object prev = i.getPrev();
        if (next == null && prev == null) assert (this.size == 1);
        if (next == null) {
            assert (this._lastItem == i);
            this._lastItem = prev;
        } else {
            assert (next.getPrev() == i);
            next.setPrev((DoublyLinkedList.Item<?>)prev);
        }
        if (prev == null) {
            assert (this._firstItem == i);
            this._firstItem = next;
        } else {
            assert (prev.getNext() == i);
            prev.setNext((DoublyLinkedList.Item<?>)next);
        }
        i.setNext(null);
        i.setPrev(null);
        --this.size;
        i.setParent(null);
        return (T)i;
    }

    @Override
    public void insertPrev(T i, T j) {
        if (j.getParent() != null) {
            throw new PromiscuousItemException((DoublyLinkedList.Item<?>)j, j.getParent());
        }
        if (j.getNext() != null || j.getPrev() != null) {
            throw new PromiscuousItemException((DoublyLinkedList.Item<?>)j);
        }
        if (i == null) {
            j.setPrev((DoublyLinkedList.Item<?>)this._lastItem);
            j.setNext(null);
            j.setParent(this);
            if (this._lastItem != null) {
                this._lastItem.setNext((DoublyLinkedList.Item<?>)j);
                this._lastItem = j;
            } else {
                this._lastItem = j;
                this._firstItem = this._lastItem;
            }
            ++this.size;
        } else {
            if (i.getParent() == null) {
                throw new PromiscuousItemException((DoublyLinkedList.Item<?>)i, i.getParent());
            }
            if (i.getParent() != this) {
                throw new PromiscuousItemException((DoublyLinkedList.Item<?>)i, i.getParent());
            }
            Object prev = i.getPrev();
            if (prev == null) {
                if (i != this._firstItem) {
                    throw new VirginItemException((DoublyLinkedList.Item<?>)i);
                }
                this._firstItem = j;
            } else {
                prev.setNext((DoublyLinkedList.Item<?>)j);
            }
            j.setPrev((DoublyLinkedList.Item<?>)prev);
            i.setPrev((DoublyLinkedList.Item<?>)j);
            j.setNext((DoublyLinkedList.Item<?>)i);
            j.setParent(this);
            ++this.size;
        }
    }

    @Override
    public void insertNext(T i, T j) {
        if (j.getParent() != null) {
            throw new PromiscuousItemException((DoublyLinkedList.Item<?>)j, i.getParent());
        }
        if (j.getNext() != null || j.getPrev() != null) {
            throw new PromiscuousItemException((DoublyLinkedList.Item<?>)j);
        }
        if (i == null) {
            j.setPrev(null);
            j.setNext((DoublyLinkedList.Item<?>)this._firstItem);
            j.setParent(this);
            if (this._firstItem != null) {
                this._firstItem.setPrev((DoublyLinkedList.Item<?>)j);
                this._firstItem = j;
            } else {
                this._lastItem = j;
                this._firstItem = this._lastItem;
            }
            ++this.size;
        } else {
            if (i.getParent() != this) {
                throw new PromiscuousItemException((DoublyLinkedList.Item<?>)i, i.getParent());
            }
            Object next = i.getNext();
            if (next == null) {
                if (i != this._lastItem) {
                    throw new VirginItemException((DoublyLinkedList.Item<?>)i);
                }
                this._lastItem = j;
            } else {
                next.setPrev((DoublyLinkedList.Item<?>)j);
            }
            j.setNext((DoublyLinkedList.Item<?>)next);
            i.setNext((DoublyLinkedList.Item<?>)j);
            j.setPrev((DoublyLinkedList.Item<?>)i);
            j.setParent(this);
            ++this.size;
        }
    }

    private Enumeration<T> forwardElements() {
        return new ForwardWalker();
    }

    public Enumeration<T> reverseElements() {
        return new ReverseWalker();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Enumeration<T> e;
            {
                this.e = DoublyLinkedListImpl.this.forwardElements();
            }

            @Override
            public boolean hasNext() {
                return this.e.hasMoreElements();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (DoublyLinkedList.Item)this.e.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static class Item<T extends Item<?>>
    implements DoublyLinkedList.Item<T> {
        private T prev;
        private T next;
        private DoublyLinkedList<? super T> list;

        @Override
        public final T getNext() {
            return this.next;
        }

        @Override
        public final T setNext(DoublyLinkedList.Item<?> i) {
            T old = this.next;
            this.next = (Item)i;
            return old;
        }

        @Override
        public final T getPrev() {
            return this.prev;
        }

        @Override
        public final T setPrev(DoublyLinkedList.Item<?> i) {
            T old = this.prev;
            this.prev = (Item)i;
            return old;
        }

        @Override
        public DoublyLinkedList<? super T> getParent() {
            return this.list;
        }

        @Override
        public DoublyLinkedList<? super T> setParent(DoublyLinkedList<? super T> l) {
            DoublyLinkedList<? super T> old = this.list;
            this.list = l;
            return old;
        }
    }

    private class ReverseWalker
    implements Enumeration<T> {
        protected T next;

        protected ReverseWalker() {
            this.next = DoublyLinkedListImpl.this._lastItem;
        }

        @Override
        public final boolean hasMoreElements() {
            return this.next != null;
        }

        @Override
        public T nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object result = this.next;
            if (this.next == null) {
                throw new IllegalStateException("next==null");
            }
            this.next = this.next.getPrev();
            return result;
        }
    }

    private class ForwardWalker
    implements Enumeration<T> {
        protected T next;

        protected ForwardWalker() {
            this.next = DoublyLinkedListImpl.this._firstItem;
        }

        @Override
        public final boolean hasMoreElements() {
            return this.next != null;
        }

        @Override
        public T nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object result = this.next;
            this.next = this.next.getNext();
            return result;
        }
    }
}

