/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.ReferenceSystem;

public class ReferenceSystemRegistry {
    private final Collection4 _referenceSystems = new Collection4();

    public void removeId(final int id) {
        this.removeReference(new ReferenceSource(){

            @Override
            public ObjectReference referenceFrom(ReferenceSystem referenceSystem) {
                return referenceSystem.referenceForId(id);
            }
        });
    }

    public void removeObject(final Object obj) {
        this.removeReference(new ReferenceSource(){

            @Override
            public ObjectReference referenceFrom(ReferenceSystem referenceSystem) {
                return referenceSystem.referenceForObject(obj);
            }
        });
    }

    public void removeReference(final ObjectReference reference) {
        this.removeReference(new ReferenceSource(){

            @Override
            public ObjectReference referenceFrom(ReferenceSystem referenceSystem) {
                return reference;
            }
        });
    }

    private void removeReference(ReferenceSource referenceSource) {
        Iterator4 i = this._referenceSystems.iterator();
        while (i.moveNext()) {
            ReferenceSystem referenceSystem = (ReferenceSystem)i.current();
            ObjectReference reference = referenceSource.referenceFrom(referenceSystem);
            if (reference == null) continue;
            referenceSystem.removeReference(reference);
        }
    }

    public void addReferenceSystem(ReferenceSystem referenceSystem) {
        this._referenceSystems.add(referenceSystem);
    }

    public void removeReferenceSystem(ReferenceSystem referenceSystem) {
        this._referenceSystems.remove(referenceSystem);
    }

    private static interface ReferenceSource {
        public ObjectReference referenceFrom(ReferenceSystem var1);
    }
}

